h34927
s 00000/00000/00279
d D 1.5 98/03/11 17:35:42 tof 6 5
c 
e
s 00000/00000/00279
d D 1.4 97/07/26 11:18:37 chris 5 4
c Version for 16 Mbyte VME
e
s 00000/00000/00279
d D 1.3 96/12/10 16:37:46 chris 4 3
c modif de rien du tou du makefile
e
s 00003/00001/00276
d D 1.2 96/11/29 11:25:35 devel 3 1
c Introduction de SID pour sccs
e
s 00000/00000/00000
d R 1.2 96/11/28 12:59:02 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/process/process.c
e
s 00277/00000/00000
d D 1.1 96/11/28 12:59:01 devel 1 0
c date and time created 96/11/28 12:59:01 by devel
e
u
U
f e 0
t
T
I 1
D 3
static char *SccsId="%w% %g%";
E 3
I 3

static char *SccsId="%W% %G%";

E 3
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:process.c
-----------------
-Auteur(s):	Christian Miguel
-Rle:
		Regroupe les fonctions relatives aux processus
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		forkn
		shared_segment
		lock_pont
		unlock_pont
	 
-Commentaires:
********************************************************************;-*/



#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <sun.h>
#include <process.h>
#include <the_errno.h>

extern Erreur the_errno;


/*++********************************************************************
------------------
ENTETE DE FONCTION	:forkn
------------------

-Rle:
		Cration de plusieurs processus.
-inclure:
-Prototype:
	int forkn(void *(tab_fonc[]) (void),int nb_fils,pid_t *tab_pid)
-Paramtres:
	tab_fonc: tableau de pointeurs sur les fonctions associes aux processus.
	nb_fils: nombre de processus  crer.
	tab_pid: tableau des numros des processus. (passage par rsultat)

-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	Le nombre de processus cres
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int forkn(tab_fonc,nb_fils,tab_pid)

void (*tab_fonc[]) (void);
int nb_fils;
pid_t *tab_pid;
{	
static int pid;
int i,numfils=0;
	
	for(i=0;i<nb_fils;i++)
	
		switch (pid=fork())
		{
		case 0: (tab_fonc[i])();
			_exit(0);

		default: if((tab_pid[i] = pid )>0)
				numfils++;
		}
	return(numfils);
}
	

/*++********************************************************************
------------------
ENTETE DE FONCTION	:shared_segment
------------------

-Rle:
	Cette fonction permet de crer des segments de mmoire partags
	par plusieurs processus.
-inclure:
-Prototype:
	long *shared_segment(cle,nb_sh)
-Paramtres:
	key_t	cle; cle du segment
	int	nb_sh; nombre de cases memoires de type long
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	Le retour de la fonction est l'adresse du segment de mmoire
	partag cr par la fonction ou NULL en cas d'erreur.
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		CLE		(process.h)	Repre du segment de mmoire.
		NB_SH_SEG	"	nombre de cases mmoire.
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

void *shared_segment(cle,nb_sh)
key_t 	cle;
int	nb_sh;
{
int shmid;	/*identification du segment */
long *adr;	/*adresse d'attachement du segment*/
int i;
	


	if((shmid=shmget(cle,nb_sh*sizeof(long),IPC_CREAT|0666))==-1)
	{
		 
		the_errno.code=errno;
		return(NULL);
	}

/* attachement */

	if((adr=shmat(shmid,0,0)) == (long *) -1)
	{
		the_errno.code=errno;
		return(NULL);
	}	

	return(adr);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:lock_pont
------------------

-Rle:
	pose un verrou consultatif pour l'utilisation du pont de bus>
-inclure:
	process.h
	the_errno.h
-Prototype:
	int lock_pont()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	0 si le verrou a t pos -1 si cela n'a pas t possible, soit pour
	un problme systme soit car le verrou est dj pos.
	Voir la valeur de the_errno.code si c'est gal  E_PONT_BUSY c'est que 
	le verrou est pos.
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int lock_pont()
{
long	*verrou;

	verrou=(long *)shared_segment(CLE_VERROU,NB_SH_VERROU);
	
	if(verrou!=NULL)
	{
		if(verrou[0]==VERROU_SET)
		{
			the_errno.code=E_PONT_BUSY;
			shmdt((void *)verrou);
			return(ERROR);
		}
		else
		{
			verrou[0]=VERROU_SET;
			shmdt((void *)verrou);
			return(OK);
		}
	}
	else
	{
		the_errno.code=errno;
		return(ERROR);
	}
	
	
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:unlock_pont
------------------

-Rle:
	Enlve le verrou pour le pont de bus, aprs utilisation.
-inclure:
-Prototype:
	int unlock_pont()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	0 ou -1 en cas de mauvais fonctionnement dans le systme.
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int unlock_pont()
{
long	*verrou;

	verrou=(long *)shared_segment(CLE_VERROU,NB_SH_VERROU);
	
	if(verrou!=NULL)
	{
		verrou[0]=VERROU_GET;
		shmdt((void *)verrou);
		return(OK);
	}
	else
	{
		the_errno.code=errno;
		return(ERROR);
	}
}

E 1
