h62030
s 00130/00000/00211
d D 1.9 98/04/14 14:53:22 tof 10 9
c mise a jour des commentaires..
e
s 00000/00000/00211
d D 1.8 98/03/11 10:33:55 chris 9 8
c correction erreur syntaxe makefile
e
s 00000/00000/00211
d D 1.7 98/03/11 10:29:01 tof 8 7
c en cours de documentation tof
e
s 00000/00000/00211
d D 1.6 97/08/27 22:39:55 chris 7 6
c 
e
s 00000/00000/00211
d D 1.5 97/07/26 11:06:45 chris 6 5
c 16 Mbyte Version, up and runnin'
e
s 00000/00000/00211
d D 1.4 96/12/18 16:12:25 chris 5 4
c version ok
e
s 00000/00000/00211
d D 1.3 96/12/10 16:33:50 chris 4 3
c modif ds makefile
e
s 00001/00000/00210
d D 1.2 96/11/29 11:22:33 devel 3 1
c Introduction de SID pour sccs et mise a jour du makefile
c concernant /devel
e
s 00000/00000/00000
d R 1.2 96/11/28 12:57:35 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/pont/inst_reg.c
e
s 00210/00000/00000
d D 1.1 96/11/28 12:57:34 devel 1 0
c date and time created 96/11/28 12:57:34 by devel
e
u
U
f e 0
t
T
I 1

I 3
static char *SccsId="%W% %G%";
E 3

I 10
/***********************************************************************;;#h#>
-------------
HEAD_OF_FILE: inst_reg.c
-------------
E 10

I 10
-Authors: Christian Miguel

-Library: Sun-inst-pont.a

-Purpose:

This file contains all the functions used in order to configure the register
of the "pont de bus". this configuration is a very important (and low level!)
step which has to be perform for the memory mapping SUN/VME.
The "main" function here is map_registres() which perform the configuration
of the registers, it is thus used in the function  map_mem (Sun-inst-pont.c)
which performs the complete memory mapping SUN/VME.

-Variables:
int	sbs915des  (915 device file descriptor)
FILE	*filedes   (config hex file descriptor)
u_char	*regbase   (virtual address of register base)
char	line_buff[LINEMAX]
-Functions:
byte_op
word_op
long_op
map_registres
-Comments:
the constant LINEMAX is defined in this file, it just corresponds to maximum
size of a line read from the config file CONFIG_REG_FILE.
The three functions byte_op, word_op and long_op are used by map_registres() in
order to explicitly set the registers in fonction of its "type" (byte, word or 
long).

-Keywords:
Memory, VME , PTSBS915 , Driver.
;;#h#<***********************************************************************/


E 10
#include <sys/types.h>
#include <sys/file.h>
#include <sys/mman.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include <sun.h>
#include <Sun-inst-pont.h>
#include <the_errno.h>



#define LINEMAX 255

long	strtol();
char	*fgets();

char	line_buff[LINEMAX];

int	sbs915des;		 /* 915 device file descriptor	*/
FILE	*filedes;		 /* config hex file descriptor	*/
u_char	*regbase;		 /* virtual address of register base */

extern Erreur the_errno;

 
I 10
/*******************************************************************;;#f#>
HEAD_OF_FUNCTION: byte_op
-Purpose:
E 10

I 10
Perform the configuration of the "B" registers of the "pont de bus".

-Prototype:
int byte_op(int roffset,char *operator,int operand,int linecount)
-Parameters:
roffset: offset of the register starting from regbase.
operator: operator used to modify the register ('='.'|' or'&')
operand: value used to modify the value of the register
linecount:number of the line currently analysed in CONFIG_REG_FILE.
-UsesVariables:
regbase
-Return:
Ok or ERROR if operator is not one of '=', '|' or '&'. In the last case
the_errno variable contains the error code: E_BAD_OPERATOR. 
-Comments:
See the registers configuration file CONFIG_REG_FILE for more details.

;;#f#<*******************************************************************/
E 10
int byte_op(roffset,operator,operand,linecount)
int	roffset;
char	*operator;
int	operand;
int	linecount;
{
	switch(*operator) {
		case '=':
			*(u_char *)(regbase+roffset) = (u_char)operand;
			break;
		case '|':
			*(u_char *)(regbase+roffset) |= (u_char)operand;
			break;
		case '&':
			*(u_char *)(regbase+roffset) &= (u_char)operand;
			break;
		default:
			the_errno.code=E_BAD_OPERATOR;
			the_errno.code=linecount;
			the_errno.where=FICH_CONF;
			return(ERROR);
			break;
	}
	return(OK);
}

I 10

/********************************************************************;;#f#>
HEAD_OF_FUNCTION: word_op
-Purpose:
Perform the configuration of the "W" registers of the "pont de bus".
-Prototype:
int word_op(int roffset,char *operator,int operand,int linecount)
-Parameters:
roffset: offset of the register starting from regbase.
operator: operator used to modify the register ('='.'|' or'&')
operand: value used to modify the value of the register
linecount:number of the line currently analysed in CONFIG_REG_FILE.
-UsesVariables:
regbase 
-Return:
Ok or ERROR if operator is not one of '=', '|' or '&'. In the last case
the_errno variable contains the error code: E_BAD_OPERATOR. 
-Comments:
See the registers configuration file CONFIG_REG_FILE for more details.
;;#f#<********************************************************************/
E 10
int word_op(roffset,operator,operand,linecount)
int	roffset;
char	*operator;
int	operand;
int	linecount;
{
	switch(*operator) {
		case '=':
			*(u_short *)(regbase+roffset) = (u_short)operand;
			break;
		case '|':
			*(u_short *)(regbase+roffset) |= (u_short)operand;
			break;
		case '&':
			*(u_short *)(regbase+roffset) &= (u_short)operand;
			break;
		default:
			the_errno.code=E_BAD_OPERATOR;
			the_errno.ctxt=linecount;
			the_errno.where=FICH_CONF;
			return(ERROR);
			break;
	}
	return(OK);
}

I 10

/*********************************************************************;;#f#>
HEAD_OF_FUNCTION: long_op
-Purpose:
Perform the configuration of the "L" registers of the "pont de bus".
-Prototype:
int long_op(int roffset,char *operator,int operand,int linecount)
-Parameters:
roffset: offset of the register starting from regbase.
operator: operator used to modify the register ('='.'|' or'&')
operand: value used to modify the value of the register
linecount:number of the line currently analysed in CONFIG_REG_FILE.
-UsesVariables:
regbase
-Return:
Ok or ERROR if operator is not one of '=', '|' or '&'. In the last case
the_errno variable contains the error code: E_BAD_OPERATOR.
-Comments:
See the registers configuration file CONFIG_REG_FILE for more details.
;;#f#<*********************************************************************/
E 10
int long_op(roffset,operator,operand,linecount)
int	roffset;
char	*operator;
int	operand;
int	linecount;
{
	switch(*operator) {
		case '=':
			*(u_long *)(regbase+roffset) = (u_long)operand;
			break;
		case '|':
			*(u_long *)(regbase+roffset) |= (u_long)operand;
			break;
		case '&':
			*(u_long *)(regbase+roffset) &= (u_long)operand;
			break;
		default:
			the_errno.code=E_BAD_OPERATOR;
			the_errno.ctxt=linecount;
			the_errno.where=FICH_CONF;
			return(ERROR);
			break;
	}
	return(OK);
}

I 10
/**********************************************************************;;#f#>
HEAD_OF_FUNCTION: map_registres
-Purpose:
This function sets the good configuration for the registers of the "pont de bus"
to the VME. this function is used by the function map_mem (Sun-inst-pont.c) in
order to initialize the registers of the "pont de bus" before doing the memory 
maping SUN/VME.
-Prototype:
int map_registres()
-UsesVariables:
filedes (config hex file descriptor - vme.conf)
sbs915des  (915 device file descriptor)
E 10

I 10
-UsesFunctions:
byte_op
word_op
long_op
-Return:
OK or ERROR if an error accurs while reading the config file or initializing
the register. The error code is returned in the variable the_errno.

-Comments:
Basically, this function reads the configuration command for the registers in
the file CONFIG_REG_FILE (vme.conf) and set the registers!
;;#f#<**********************************************************************/
E 10
int map_registres()
{
off_t	page_start;		 /* SBus addr of page start	*/
caddr_t	vpage_start;		 /* virt addr of page start	*/
u_long	page_offset;		 /* offset into mapped page	*/

int	i,j;			 /* loop index and reg offset   */
char	*d;		 	 /* ptr returned by fgets	*/
int	linecount;		 /* number of lines read so far	*/
char	*operator;		 /* operator (| or & or =)	*/
int	roffset;		 /* offset to register		*/
int	operand;		 /* operand			*/
int 	retour_op;


	if ((filedes = fopen(CONFIG_REG_FILE,"r")) == NULL)
	{
	  	the_errno.code=errno;
		the_errno.where=FICH_CONF;
		return(ERROR);
	
	}
	  	 
	sbs915des = open(DRIVER_PONT, O_RDWR);
	if (sbs915des == (-1))
	{
		the_errno.code=errno;
		the_errno.where=PONT_BUS;
		return(ERROR);
	}

	page_start = (OFFSET_REG_VME / PAGE_SIZE) * PAGE_SIZE;
	page_offset = OFFSET_REG_VME % PAGE_SIZE;
	vpage_start = mmap((caddr_t)0, TAILLE_REG, PROT_READ|PROT_WRITE,
			   MAP_SHARED, sbs915des, page_start);
	
	if (vpage_start == (caddr_t)(-1))
	{
		the_errno.code=errno;
		the_errno.where=PONT_BUS;
		return(ERROR);
	}

	regbase = (u_char *)(vpage_start + page_offset);

	i = *regbase;
	linecount = 0;

	while ( (d = fgets(&line_buff[0],LINEMAX,filedes)) != NULL)
	{
	 linecount++;
		
		if ((line_buff[0] != '#') && (line_buff[0] != '\n'))
		{
			if ( (i = sscanf(&line_buff[1],"%lx %1s %x",&roffset,
				&operator,&operand)) < 3)
			{
					the_errno.code=E_BAD_ARG_CONF;
					the_errno.where=FICH_CONF;
					the_errno.ctxt=linecount;
					return(ERROR);
			}
		}
		retour_op=OK;
	 
		switch(line_buff[0]) 
		{
		  case 'B':
		  case 'b':
			retour_op=byte_op(roffset,&operator,operand,linecount);
			break;
		  case 'W':
		  case 'w':
			retour_op=word_op(roffset,&operator,operand,linecount);
			break;
		  case 'L':
		  case 'l':
			retour_op=long_op(roffset,&operator,operand,linecount);
			break;
		  default:
			the_errno.code=E_BAD_FST_CHAR;
			the_errno.ctxt=linecount;
			the_errno.where=FICH_CONF;
			break;
		}
		if(retour_op==ERROR)
		{
			munmap(vpage_start,TAILLE_REG);
			return(ERROR);
		}
	   }
	if(munmap(vpage_start,TAILLE_REG)==ERROR)
	{
		the_errno.code=errno;
		return(ERROR);
	}
	return(OK);
}
I 10






E 10
E 1
