h41463
s 00004/00023/00484
d D 1.12 00/04/27 16:34:53 jeje 13 12
c 
e
s 00000/00000/00507
d D 1.11 00/04/06 11:53:12 jeje 12 11
c 
e
s 00015/00005/00492
d D 1.10 00/03/31 13:12:17 jeje 11 10
c 
e
s 00046/00026/00451
d D 1.9 98/04/14 11:44:37 tof 10 9
c mise a jour des commentaires...
e
s 00000/00000/00477
d D 1.8 98/03/11 10:33:55 chris 9 8
c correction erreur syntaxe makefile
e
s 00082/00071/00395
d D 1.7 98/03/11 10:29:00 tof 8 7
c en cours de documentation tof
e
s 00000/00000/00466
d D 1.6 97/08/27 22:39:54 chris 7 6
c 
e
s 00196/00260/00270
d D 1.5 97/07/26 11:06:45 chris 6 5
c 16 Mbyte Version, up and runnin'
e
s 00001/00005/00529
d D 1.4 96/12/18 16:12:24 chris 5 4
c version ok
e
s 00000/00000/00534
d D 1.3 96/12/10 16:33:49 chris 4 3
c modif ds makefile
e
s 00003/00001/00531
d D 1.2 96/11/29 11:22:32 devel 3 1
c Introduction de SID pour sccs et mise a jour du makefile
c concernant /devel
e
s 00000/00000/00000
d R 1.2 96/11/28 12:57:35 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/pont/Sun-inst-pont.c
e
s 00532/00000/00000
d D 1.1 96/11/28 12:57:34 devel 1 0
c date and time created 96/11/28 12:57:34 by devel
e
u
U
f e 0
t
T
I 1
D 3
static char *SccsId="%w% %g%";
E 3
I 3

static char *SccsId="%W% %G%";

E 3
D 8
/*;+********************************************************************
E 8
I 8
/*********************************************************************;;#h#>
E 8
-----------------
D 6
ENTETE DE FICHIER	:Sun-inst-pont.c
E 6
I 6
D 8
HEAD OF FILE	:Sun-inst-pont.c
E 8
I 8
HEAD_OF_FILE: Sun-inst-pont.c
E 8
E 6
-----------------
D 6
-Auteur(s):	Christian Miguel
-Rle:
Ce fichier regroupe l'ensemble des fonctions servant  l'installation du pont de bus du cote SUN. Il dfinit l'ensemble des fonctions servant  rendre la mmoire commune SUN-VME exploitable ie: en lecture et en criture.
E 6
I 6
D 8
-Author(s):	Christian Miguel
-Role:
E 8
I 8
-Authors:	Christian Miguel
-Library: Sun-inst-pont.a
-Purpose:
E 8
This file contains all the functions for The Ptsbs915 bus driver. Thanks to
those functions a program linking the library Sun-inst-pont.a can access the
memory of the VME machine, which must be shared (readable and writable )in the
acquisition program.

E 6
	
D 8
-Variables
E 8
I 8
-Variables:
E 8
D 6
	Internes au fichier:
		int		desc_pont	(descripteur du driver de pont)
		void 		*Pt_vme_base
E 6
I 6
	
int		desc_pont	(dev of driver)
void 		*Pt_vme_base    (points on the first elt mapped)
E 6

D 6
		Tb_point	*Pt_point;	(pointeurs sur les tables 
		Tb_acq		*Pt_acq;		servant a l'acquisition)
		Tb_ctrl_cam	*Pt_cam;
		Tb_ctrl		*Pt_ctrl;
		Datum		*Pt_data;
E 6
I 6
Tb_point	*Pt_point;	(pointers on acq info) 
Tb_acq		*Pt_acq;		
Tb_ctrl_cam	*Pt_cam;
Tb_ctrl		*Pt_ctrl;
Datum		*Pt_data;
E 6

	 	
D 6
-Fonctions:
	Internes au fichier:
		open_driver_pont
		close_driver_pont
		add_point
		Map_Memory
		map_mem
		map_mem_fils
		installe_pont		  
		ferme_pont		 
E 6
I 6
-Functions:

open_driver_pont
close_driver_pont
add_point
I 8
sub_point
E 8
map_mem
I 8
unmap_mem
E 8
map_mem_fils
installe_pont		  
ferme_pont		 
E 6
	 
D 6
-Commentaires:
L'installation du pont de bus est dlicate. L'utilisation du pont est dangereuse et risque de planter la station (reboot) si l'installation est mal faite.
E 6
I 6
-Comments:
D 8
installing the mapping is quite tricky without those functions. It is very
E 8
I 8
Installing the mapping is quite tricky without those functions. It is very
E 8
important to follow the instructions to use those functions because they are
very low level. The first error may reboot the station.
E 6

D 6
Afin d'installer le pont, il convient de distinguer deux cas d'utilisation:
E 6
I 6
There are two ways of installing the bus to the VME machine from the SUN:
E 6

D 6
* Dans le cas d'un environnement mono processus l'installation du pont de bus se fait par un appel  installe_pont et une fermeture par ferme_pont.
E 6
I 6
1)
If only one process needs to map the memory, we are in the simpliest case.
D 8
The call of installe_pont installs every thing.
E 8
I 8
The call of installe_pont installs everything.
E 8
It is possible to read and write in the shared memory using the pointers
on the acquisition info (if they are declared as extern in the other files).
WARNING: It is essential to call ferme_pont before exiting to close the
device.
E 6

D 6
* Dans le cas d'un environnement multi processus, les oprations relatives  l'installation du pont de bus doivent tre effectus aprs la cration des processus. Un seul processus doit faire l'opration d'initialisation, comme dans le cas mono processus, les autres doivent utiliser les fonctions map_mem et unmap_mem (ou munmap).
	
Les variables internes  ce fichier sont effectivement dclars ici,il faut donc les redclarer en extern dans les fichiers qui y font rfrence.
E 6
I 6
2)
If 2 processes, at least, must access the shared memory, it is rather more
complicated.
D 10
One process, the father, must proceed as if it were the only one (like 1).
E 10
I 10
One process, the father, must proceed as if it was the only one (like 1).
E 10
The other ones must use the function map_mem_fils instead of install_pont
and close the device using unmap_mem.
E 6

I 6
-Keywords:
D 8
Memory, VME, PTSBS915,Driver
E 6
********************************************************************;-*/
E 8
I 8
Memory, VME, PTSBS915,Driver.
;;#h#<*********************************************************************/
E 8


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <fcntl.h>
#include <sys/mman.h>		/* pour les cstes utiles a mmap  */
#include <unistd.h>
D 6
#include <errno.h>
E 6
I 6
#include <errno.h>              
E 6

D 6
#include	<sun.h>
E 6
I 6
#include	<sun.h>        /* not system section */
E 6
#include	<Sun-inst-pont.h>
#include 	<acq.h>
#include	<the_errno.h>



D 6
void 		*Pt_vme_base=NULL;
E 6
I 6
void 		*Pt_vme_base=NULL;  
E 6

Tb_point	*Pt_point=NULL;
Tb_acq		*Pt_acq=NULL;
Tb_ctrl_cam	*Pt_cam=NULL;
Tb_ctrl		*Pt_ctrl=NULL;
Datum		*Pt_data=NULL;

int 		desc_pont;


D 6
extern Erreur the_errno;
E 6
I 6
extern Erreur the_errno;    /* see errors library */
E 6


D 8
/*++********************************************************************
E 8
I 8
/*******************************************************************;;#f#>
E 8
------------------
D 6
ENTETE DE FONCTION	:open_driver_pont
E 6
I 6
D 8
HEAD OF FUNCTION	:open_driver_pont
E 8
I 8
HEAD_OF_FUNCTION: open_driver_pont
E 8
E 6
------------------
I 8
-Purpose:
Open the driver of the "pont".
E 8

-Prototype:
D 6
	int open_driver_pont()
E 6
I 6
int open_driver_pont()
E 6

D 6
-Retour:
	Le descripteur du driver du pont de bus ncessaire  toute opration
	d'installation du pont de bus
E 6
I 6
-Return:
D 8
The return of the open function in the name of the driver
E 8
I 8
The return of the open function in the name of the driver DRIVER_PONT
E 8
E 6

D 6
-Constantes utilises
 	Importes:
		DRIVER_PONT (Sun-inst-pont.h)
E 6
I 6
D 8
-uses:
E 8
I 8
;;#f#<*********************************************************************/
E 8

E 6
D 8
********************************************************************--*/
E 8

D 8

E 8
int open_driver_pont()
{
	return(open(DRIVER_PONT,O_RDWR));

}





D 8
/*++********************************************************************
E 8
I 8
/******************************************************************;;#f#>
E 8
------------------
D 6
ENTETE DE FONCTION	:close_driver_pont
E 6
I 6
D 8
HEAD OF FUNCTION	:close_driver_pont
E 8
I 8
HEAD_OF_FUNCTION: close_driver_pont
E 8
E 6
------------------

I 8
-Purpose:
Close the driver of the "pont".

E 8
-Prototype:
D 6
	int close_driver_pont()
E 6
I 6
int close_driver_pont()
E 6

I 8
-UsesVariables:
desc_pont:  The "file handle" of the driver.
E 8
D 6
-Retour:
	Le code erreur de la fermeture.
E 6
I 6
-Return:
the return of the close function.
I 8
-Comments:
Note that this function takes no parameters : "close(desc_pont)" is 
directly used in the code.
E 8
E 6

D 6
-Constantes utilises
 	Importes:
		DRIVER_PONT (Sun-inst-pont.h)
E 6
D 8
********************************************************************--*/
E 8
I 8
;;#f#<******************************************************************/
E 8

D 8

E 8
int close_driver_pont()
{
	return(close(desc_pont));
}




D 8


/*++********************************************************************
E 8
I 8
/******************************************************************;;#f#>
E 8
------------------
D 6
ENTETE DE FONCTION	:add_point
E 6
I 6
D 8
HEAD OF FUNCTION	:add_point
E 8
I 8
HEAD_OF_FUNCTION: add_point
E 8
E 6
------------------

D 6
-Rle:	permet d'additionner des pointeurs
E 6
I 6
D 8
-Role:	
adding pointer !
E 8
I 8
-Purpose:	
Adding two pointers !
E 8
E 6
-Prototype:
	void * add_point(void *base,void *offset)
D 6
-Paramtres:
	base:	le pointeur de base
	offset:	le pointeur  ajouter
E 6
I 6
-Parameters:
	base:	one pointer
	offset:	the other one !
E 6

D 6
-Retour: la somme des deux pointeurs sous le type void *.
E 6
I 6
-Return:
D 8
The sum, there is error checking.
E 8
I 8
The sum.
-Comments:
There is no error checking.
E 8
E 6

D 10
********************************************************************--*/
E 10
I 10
;;#f#<*********************************************************************/
E 10


void *add_point(base,offset)
void *base;
void *offset;
{
	return((void *)((u_long)offset+(u_long)base));
}


D 8
/*++********************************************************************
E 8
I 8
/*******************************************************************;;#f#>
E 8
------------------
D 6
ENTETE DE FONCTION	:sub_point
E 6
I 6
D 8
HEAD OF FUNCTION	:sub_point
E 8
I 8
HEAD_OF_FUNCTION: sub_point
E 8
E 6
------------------

D 6
-Rle:	permet de soustraire des pointeurs
E 6
I 6
D 8
-Role:
substracting pointers
E 8
I 8
-Purpose:
Substracting pointers.
E 8
E 6
-Prototype:
	void * sub_point(void *base,void *offset)
D 6
-Paramtres:
	base:	le pointeur de base
	offset:	le pointeur a retrancher
E 6
I 6
-Parameters:
	base:	One pointer
	offset:	The one to substract.
E 6

D 6
-Retour: la soustraction des deux pointeurs sous le type void *.
E 6
I 6
-Return: 
D 8
The result, there is no error checking
E 8
I 8
The result.
-Comments:
There is no error checking
E 8
E 6

D 8
 ********************************************************************--*/
E 8
I 8
;;#f#<*******************************************************************/
E 8


void *sub_point(base,offset)
void *base;
void *offset;
{
	return((void *)((u_long)base-(u_long)offset));
}


I 6

 
E 6
D 8
/*++********************************************************************
E 8
I 8
/*******************************************************************;;#f#>
E 8
------------------
D 6
ENTETE DE FONCTION	:Map_Memory
E 6
I 6
D 8
HEAD OF FUNCTION	:map_mem
E 8
I 8
HEAD_OF_FUNCTION: map_mem
E 8
E 6
------------------

D 6
-Rle:
	Cette fonction permet de voir du cot de la SUN, la mmoire du VME
	comme si celle-ci faisait partie de la mmoire de la SUN.
	mapping d'une zone mmoire passe en paramtre.
E 6
I 6
D 8
-Role:
E 8
I 8
-Purpose:
E 8
Mapping address, the lowest level function in this file.
E 6

D 6
-inclure:
E 6
-Prototype:
D 6
	caddr_t Map_Memory(
			     int taille_mem,
			     int desc_pont,
			     u_long offset_port)
E 6
I 6
	int map_mem(u_long offset, int desc)
E 6

D 6
-Paramtres:
	taille_mem est la taille de l'espace  mapper
	desc_pont est le descripteur du driver.
	offset_port est l'adresse physique de la mmoire  mapper
E 6
I 6
-Parameters:
D 8
offset is the physical address of the memory of the VME machine. It depends on
E 8
I 8
offset: The physical address of the memory of the VME machine. It depends on
E 8
type of bus, 16 32 bits etc...
D 8
desc is the real device.
E 8
I 8
desc: is the real device.
E 8
E 6

D 6
-Retour:
	0 si tout va bien	
-Commentaires:
	Cette fonction ne doit pas tre appel directement par un programme.
********************************************************************--*/
E 6
I 6
D 8
-uses
E 8
I 8
-UsesVariables:
E 8
E 6

D 6
   
E 6
I 6
D 8
Pt_vme_base	@ virtuelle du debut de la zone de donnees
Pt_point	@ virtuelle de la table des pointeurs
Pt_acq		@ virtuelle de la table d'acquisition
Pt_ctrl		@ virtuelle de la table de controle
Pt_data		@ virtuelle du debut de zone de donnees
Pt_cam		@ virtuelle de la table de ctrl des cameras
E 8
I 8
Pt_vme_base 	virtual @ of the beginning of the global data area
Pt_point	virtual @ of the table of the pointers
Pt_acq		virtual @ of the acquisition table
Pt_ctrl		virtual @ of the control table
Pt_data		virtual @ of the biginning of the data area
Pt_cam		virtual @ of the cameras control table
E 8
E 6

I 8
-UsesFunctions:
map_registres (int_reg.c)
E 8
D 6
caddr_t Map_Memory(taille_mem,desc_pont,offset_port)
int desc_pont,taille_mem;
u_long offset_port;
{
 return(  mmap(	0,
		taille_mem,
		PROT_READ|PROT_WRITE,
		MAP_SHARED,
		desc_pont,
		offset_port));     
}
E 6
D 11

E 11
I 11
x
E 11
I 6
-Return:
D 8
OK or ERROR there is an error control (the_errno variable)
E 8
I 8
OK or ERROR. There is an error control (the_errno variable)
E 8
E 6


I 6
D 8
-uses:
--Functions:
map_registres (int_reg.c)
E 6

D 6
 
/*++********************************************************************
------------------
ENTETE DE FONCTION	:map_mem
------------------
E 6

D 6
-Rle:
Map une partie de mmoire du VME et fait correspondre les adresses de plusieurs objets essentiels du cot SUN et VME.

-Prototype:
	int map_mem(u_long offset, int desc)
-Paramtres:
offset est l'adresse physique de la table des pointeurs dans la mmoire du VME. desc est le descripteur du driver du pont de bus.

-Variables globales utilises
	Internes au fichier:
		Pt_vme_base	@ virtuelle du debut de la zone de donnees
		Pt_point	@ virtuelle de la table des pointeurs
		Pt_acq		@ virtuelle de la table d'acquisition
		Pt_ctrl		@ virtuelle de la table de controle
		Pt_data		@ virtuelle du debut de zone de donnees
		Pt_cam		@ virtuelle de la table de ctrl des cameras
	Importes:

-Retour:OK ou ERROR et affecte  the_errno le code d'erreur correspondant

-Description:
La fonction map aussi un registre de la carte du pont qui est dans le VME afin de le programmer. Ici, on indique  la carte quelle fentre de mmoire de la station SUN, on utilise pour le mapping.
-Constantes utilises
	Internes au fichier:
	Importes:
		TAILLE_MEM_COM		(Sun-inst-pont.h)
		OFFSET_PORT_VME
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		map_registres (int_reg.c)

-Exemple:
E 6
-Commentaires:
E 8
I 8
-Comments:
E 8
D 6
	Ne doit pas tre appel directement.
E 6
I 6
Not to be called directly. This functions not only maps the memory but maps the registers of the card to programm them.
E 6
D 8
********************************************************************--*/
E 8
I 8
Note that the standard function mmap(...) is used here.
E 8

I 8
;;#f#<*******************************************************************/

E 8
int map_mem(offset,desc) 
D 6
u_long offset;
int desc;
{
caddr_t Registres;
int	i;
E 6
I 6
u_long offset; 
int desc; 
{ 
  caddr_t Registres;
  int i;
E 6

D 5
     	printf("\n Avant map Registres");
E 5
I 5
D 13

E 5
	 	
E 13
D 6
	if(ERROR == map_registres())
		return(ERROR);
E 6
I 6
  if(ERROR == map_registres())
    return(ERROR);
E 6

D 5
	printf("\n Apres map registres");

E 5
D 6
 
	Pt_vme_base=Map_Memory(TAILLE_MEM_COM,desc,OFFSET_PORT_VME);
E 6
D 13

I 11
  printf("(map_mem) desc=%ld\n", desc);
  printf("(map_mem) OFFSET_PORT_VME=%ld\n", OFFSET_PORT_VME);
E 11
I 6
  Pt_vme_base=mmap(0,TAILLE_MEM_COM,PROT_READ|PROT_WRITE,MAP_SHARED,desc,OFFSET_PORT_VME);
E 6
D 5
	printf("\n Apres Map Memory");
E 5
        
E 13
I 13
  Pt_vme_base=mmap(0,TAILLE_MEM_COM,PROT_READ|PROT_WRITE,MAP_SHARED,desc,OFFSET_PORT_VME); 
       
E 13
D 6
	if((int)Pt_vme_base == MAP_FAILED)
	{
		printf("\n ERROR map memoire");
		the_errno.code=errno;
		return(ERROR);	
	}
        
D 5
	printf("\n Avant les affectations d'adresses");
E 5
 	
	Pt_point=add_point(Pt_vme_base,(void *)offset);
 	printf("\n Apres l'affectation de Pt_point");
E 6
I 6
  if((int)Pt_vme_base == MAP_FAILED) 
    { printf("\n ERROR mapmemoire"); 
      the_errno.code=errno; return(ERROR); 
    }
E 6

I 11
D 13
  printf("(map_mem) Pt_vme_base=%ld\n", Pt_vme_base);
  printf("(map_mem) offset=%ld\n", offset);
E 13
E 11
D 6
	Pt_acq=(Tb_acq *)add_point(Pt_point->pt_tab_acq,Pt_vme_base);
	Pt_ctrl=(Tb_ctrl *)add_point(Pt_point->pt_ctrl,Pt_vme_base);
	Pt_data=(Datum *)add_point(Pt_point->pt_data,Pt_vme_base);
	Pt_cam=(Tb_ctrl_cam *)add_point(Pt_point->pt_cam,Pt_vme_base);
E 6
I 6
  Pt_point=add_point(Pt_vme_base,(void *)offset); 
D 11
  printf("\nApres l'affectation de Pt_point");
E 6

E 11
I 11
D 13
  printf("\nApres l'affectation de Pt_point\n");
  printf("(map_mem) Pt_point=%ld\n", Pt_point);
  printf("(map_mem) Pt_point->pt_tab_acq=%ld\n", Pt_point->pt_tab_acq);
  printf("(map_mem) Pt_vme_base=%ld\n",Pt_vme_base);
E 11
I 6
  Pt_acq=(Tb_acq *)add_point(Pt_point->pt_tab_acq,Pt_vme_base);
I 11
  printf("(map_mem) apres Tb_acq\n");
E 13
I 13
  Pt_acq=(Tb_acq *)add_point(Pt_point->pt_tab_acq,Pt_vme_base); 
E 13
E 11
  Pt_ctrl=(Tb_ctrl *)add_point(Pt_point->pt_ctrl,Pt_vme_base);
I 11
D 13
  printf("(map_mem) apres Tb_ctrl\n");
E 13
E 11
  Pt_data=(Datum *)add_point(Pt_point->pt_data,Pt_vme_base);
I 11
D 13
  printf("(map_mem) apres Datum\n");
E 13
E 11
  Pt_cam=(Tb_ctrl_cam *)add_point(Pt_point->pt_cam,Pt_vme_base);
D 11
  
E 11
I 11
D 13
  printf("(map_mem) fin\n");
E 13
E 11
E 6
 
D 6
	return(OK);
E 6
I 6
  return(OK);
E 6
}

D 8
/*++********************************************************************
E 8
I 8
/*******************************************************************;;#f#>
E 8
------------------
D 6
ENTETE DE FONCTION	:unmap_mem
E 6
I 6
D 8
HEAD OF FUNCTION	:unmap_mem
E 8
I 8
HEAD_OF_FUNCTION: unmap_mem
E 8
E 6
------------------

D 6
-Rle:
Ferme le pont de bus dans le cas d'un appel  map_mem (un appel  installe_pont doit par contre correspondre  un appel  ferme_pont) 
-inclure:
E 6
I 6
D 8
-Role:
end the mapping of memory
E 8
I 8
-Purpose:
End the mapping of memory.
E 8

E 6
-Prototype:
	int unmap_mem()
D 6
-Paramtres:
-Variables globales utilises
	Internes au fichier:
		void *Pt_vme_base; pointeur de dbut de mapping.
	Importes:
E 6
I 6
D 8
-Parameters:
-uses:
--Variables
 Pt_vme_base 
E 8
E 6

D 8
-Retour:
D 6
	0 ou -1 le code d'erreur est dans errno !!
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		TAILLE_MEM_COM (Sun-inst-pont.h)
	
-Fonctions utilises
	Internes au fichier:
	Importes:
E 6
I 6
	Ok or ERROR, there is an error control
E 8
I 8
-UsesVariables:
 Pt_vme_base : virtual @ of the biginning of the global data area
E 8
E 6

I 8
-Return:
Ok or ERROR. There is an error control in this function.
-Comments:
Note that the standard function munmap(...) is used here.
;;#f#<*********************************************************************/
E 8
D 6
-Exemple:
-Commentaires:
E 6
I 6

E 6
D 8
********************************************************************--*/
E 8

D 8

E 8
int unmap_mem()
{
	return(munmap(Pt_vme_base,TAILLE_MEM_COM));

}

D 8
/*++********************************************************************
E 8
I 8
/******************************************************************;;#f#>
E 8
------------------
D 6
ENTETE DE FONCTION	:map_mem_fils
E 6
I 6
D 8
HEAD OF FUNCTION	:map_mem_fils
E 8
I 8
HEAD_OF_FUNCTION: map_mem_fils
E 8
E 6
------------------

D 6
-Rle:
Identique  map_mem mais n'ecrit rien dans la mmoire commune cela permet de faire plusieurs mapping de mmoire. Les adresses de la tables de pointeurs sont interprt comme des adresses SUN.
-inclure:
E 6
I 6
D 8
-Role:
Similar to the map_mem function but is to be used in a multi process
environment. Must be used by a son process.
E 8
I 8
-Purpose:
E 8

I 8
It is similar to the map_mem function but is to be used in a multi process
environment. It has to be used by the (or a) son process when both father and son(s) have to access the shared mmemory of the VME.

E 8
E 6
-Prototype:
	int map_mem_fils(ex_base,offset,desc)
D 6
-Paramtres:
ex_base doit la valeur de Pt_vme_base obtenue par le premier mapping c'est  dire par la fonction installe_pont. cela suppose une petite communication entre les processus. offset doit tre la valeur retourne par adresse_tb_point de la bibliothque Sun-clnt-vme.a.
desc le descripteur du pont de bus retourn par open_driver_pont
E 6
I 6
-Parameters:
D 8
exbase is the Pt_vme_base value obtained in the first map (calling of 
E 8
I 8
D 10
exbase: is the Pt_vme_base value obtained in the first map (calling of 
E 8
install_pont
offset is the value of the Pt_point in the VME (VME address)
desc is the device.
E 10
I 10
exbase: is the Pt_vme_base value obtained in the first map (calling of install_pont offset is the value of the Pt_point in the VME (VME address)).
desc:  is the device.
E 10
E 6

D 6
-Variables globales utilises
	Internes au fichier:
		Pt_vme_base
		Pt_point
		Pt_acq
		Pt_ctrl
		Pt_data
		Pt_cam
	Importes:
E 6
I 6
D 10
-uses:
--Variables:	
E 10
I 10
-UsesVariables:	
E 10
Pt_vme_base
Pt_point
Pt_acq
Pt_ctrl
Pt_data
Pt_cam
E 6

I 10
-UsesFunctions:
add_point
sub_point
E 10
D 6
-Retour:OK ou ERROR et affecte  the_errno le code d'erreur correspondant
-Description:
-Constantes utilises
	Internes au fichier:
			Importes:
	
-Fonctions utilises
	Internes au fichier:
		Map_Memory
	Importes:
E 6

D 6
-Exemple:
-Commentaires:
	Cette fonction permet  plusieurs processus de l'utilisation du  
	pont de bus.
E 6
I 6
-Return:
OK or ERROR there is an error control

I 10
-Comments:
Note that the standard function mmap(...) is used here.
E 10

E 6
D 8
********************************************************************--*/
E 8
I 8
;;#f#<*********************************************************************/
E 8


int map_mem_fils(ex_base,offset,desc)
u_long ex_base;
u_long offset;
int desc;
D 6
{
u_short *Registres;
int i;
	
	Pt_vme_base=Map_Memory(TAILLE_MEM_COM,desc,OFFSET_PORT_VME);
	
	if((int)Pt_vme_base == -1)
		return(ERROR); 
E 6
I 6
{ 
  u_short *Registres;
  int i;
E 6

D 6
	Pt_point=add_point(Pt_vme_base,(void *)offset);
 
	Pt_acq=(Tb_acq *)add_point(Pt_point->pt_tab_acq,
				sub_point(Pt_vme_base,(void *)ex_base));
	Pt_ctrl=(Tb_ctrl *)add_point(Pt_point->pt_ctrl,
				sub_point(Pt_vme_base,(void *)ex_base));
	Pt_data=(Datum *)add_point(Pt_point->pt_data,
				sub_point(Pt_vme_base,(void *)ex_base));
	Pt_cam=(Tb_ctrl_cam *)add_point(Pt_point->pt_cam,
				sub_point(Pt_vme_base,(void *)ex_base));
	return(OK);
E 6
I 6
  /* Pt_vme_base=Map_Memory(TAILLE_MEM_COM,desc,OFFSET_PORT_VME);*/
  Pt_vme_base=mmap(0,TAILLE_MEM_COM,PROT_READ|PROT_WRITE,MAP_SHARED,desc,OFFSET_PORT_VME);


  if((int)Pt_vme_base == ERROR)
    return(ERROR); 

  Pt_point=add_point(Pt_vme_base,(void *)offset);
  
  Pt_acq=(Tb_acq *)add_point(Pt_point->pt_tab_acq,
			     sub_point(Pt_vme_base,(void *)ex_base));
  Pt_ctrl=(Tb_ctrl *)add_point(Pt_point->pt_ctrl,
			       sub_point(Pt_vme_base,(void *)ex_base));
  Pt_data=(Datum *)add_point(Pt_point->pt_data,
			     sub_point(Pt_vme_base,(void *)ex_base));
  Pt_cam=(Tb_ctrl_cam *)add_point(Pt_point->pt_cam,
				  sub_point(Pt_vme_base,(void *)ex_base));
  return(OK);
E 6
}





D 10
/*++********************************************************************
E 10
I 10
/*********************************************************************;;#f#>
E 10
------------------
D 6
ENTETE DE FONCTION	:installe_pont
E 6
I 6
D 10
HEAD OF FUNCTION	:installe_pont
E 10
I 10
HEAD_OF_FUNCTION: installe_pont
E 10
E 6
------------------

D 6
-Rle:
Cette fonction ralise toutes les oprations d'installation du pont de bus du cot SUN. Elle lance le mapping sur les zones ncessaires et affecte les pointeurs utiles sur les bonnes adresses de la mmoire VME.
-inclure:
E 6
I 6
D 10
-Role:
This function do every thing necessary to install the shared memory
E 10
I 10
-Purpose:
This function do every thing necessary to install the shared memory.
E 10

E 6
-Prototype:
	Tb_point *installe_pont(offset)
D 6
-Paramtres:
	offset est valeur retourne par adresse_tb_point de la bibliothque
	Sun-clnt-vme.a.
-Variables globales utilises
	Internes au fichier:
		desc_pont (le descripteur du driver du pont)
	Importes:
E 6
I 6
-Parameters:
D 10
offset is the value of Pt_point in the VME (VME address value)
E 10
I 10
offset: is the value of Pt_point in the VME (VME address value).
E 10
E 6

D 6
-Retour:
	Elle retourne le pointeur sur la table des pointeurs
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:
	
-Exemple:
-Commentaires:
Aprs avoir lancer cette fonction, il faut lancer la fonction ferme_pont pour remettre la mmoire du VME dans un bon etat. Dans le cas d'un environnement multi processus, il faut que le processus utilisant cette fonction effectue un flock avec le paramtre LOCK_UN sur le descripteur du pont afin de permettre aux autres processus d'accder  la ressource. Lorsque les processus ont fait map_mem_fils, il faut alors reverrouiller le pont part un flock avec le paramtre: LOCK_EX|LOCK_NB.
E 6
I 6
D 10
-uses:
--Variables:
E 10
I 10
-UsesVariables:
E 10
desc_pont 
I 10
Pt_acq
Pt_ctrl
Pt_data
Pt_cam
Pt_Point
-UsesFunctions:
open_driver_pont
map_mem
E 10

D 10

E 10
-Return:
D 10
Pt_point, Sun address of Tb_point structure
E 10
I 10
Pt_point, Sun address of Tb_point structure.
E 10

I 10
-Comments:
Once this function is called, the SUN can access the shared memory of the VME.
E 10

I 10
;;#f#<*********************************************************************/
E 10

D 10

E 6
********************************************************************--*/

E 10
Tb_point *installe_pont(offset)
u_long offset;
{ 
	desc_pont=open_driver_pont();

	if(ERROR==desc_pont)
	{
		printf("\n Erreur ouverture");
		the_errno.code=errno;
		return(NULL);
	}
	
	if(map_mem(offset,desc_pont)==ERROR)
	{
		printf("\n Erreur map");
		return(NULL);
	}
	
D 13


E 13
/* On met les adresses SUN dans la table des pointeurs */

D 13

I 11
  printf("(installe_pont) apres map_mem\n");
E 13
E 11
	Pt_point->pt_tab_acq=Pt_acq;
	Pt_point->pt_ctrl=Pt_ctrl;
	Pt_point->pt_data=Pt_data;
	Pt_point->pt_cam=Pt_cam;
D 11
 	
E 11
I 11
D 13
	printf("(installe_pont) fin\n");
E 13
I 13

E 13
E 11
	return(Pt_point);
}





D 10
/*++********************************************************************
E 10
I 10
/*********************************************************************;;#f#>
E 10
------------------
D 6
ENTETE DE FONCTION	:ferme_pont
E 6
I 6
D 10
HEAD OF FUNCTION	:ferme_pont
E 10
I 10
HEAD_OF_FUNCTION: ferme_pont
E 10
E 6
------------------

D 6
-Rle: ferme le pont de bus (operation inverse du mapping).
-inclure:
E 6
I 6
D 10
-Role:
ends the mapping after a call of Install_pont
E 10
I 10
-Purpose:
Ends the mapping after a call of Install_pont.
E 10

E 6
-Prototype:
	int ferme_pont()
D 6
-Fonctions utilises
	Internes au fichier:
	Importes:
		unlock_pont (process.a)
E 6
D 10

E 10
I 10
-UsesVariables:
desc_pont
Pt_acq
Pt_ctrl
Pt_data
Pt_cam
Pt_vme_base
-UsesFunctions:
sub_point
E 10
D 6
-Commentaires:
Tout comme il faut faire un free apres un malloc, il faut effectuer un "unmap" apres un "map". Il faut donc lancer cette fonction lorsque l'on arrte un programme qui a mapp la memoire VME.
E 6
I 6
-Comments:
It is really,really important to call this function after Install_pont
before exiting !!
E 6
D 10
********************************************************************--*/
E 10
I 10
Note that the standard function munmap is used here.
;;#f#<*********************************************************************/
E 10

int ferme_pont()
{	
D 6
int ret;
E 6
I 6

E 6
	
/* on remet les adresses VME dans la table des pointeurs */

	Pt_point->pt_tab_acq=sub_point(Pt_acq,Pt_vme_base);
	Pt_point->pt_ctrl=sub_point(Pt_ctrl,Pt_vme_base);
	Pt_point->pt_data=sub_point(Pt_data,Pt_vme_base);
	Pt_point->pt_cam=sub_point(Pt_cam,Pt_vme_base);		
	 
	if(ERROR==munmap(Pt_vme_base,TAILLE_MEM_COM))
	{
		the_errno.code=errno;
		return(ERROR);
	}
 		
 	
	close(desc_pont);
	return(OK);
		
}


I 10



E 10
E 1
