
static char *SccsId="@(#)util_param.c	1.23 06/30/99";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:util_param.c
-----------------
-Authors:	C Miguel
-Library:
          param.a
-Purpose:
This file contains few functions used to decode the file containing the 
acquisition parameters (FILE_RAO_PAR). Basically they search and identify
the useful parameters and indices in the file.
	
-Functions:
		l_char
		extrait_mcle
		extrait_indice
	 
-Keywords:
keyword, parameter.

;;#h#<*********************************************************************/


#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <errno.h>

#include	<sun.h>
#include 	<acq.h>
#include 	<the_errno.h>

extern Erreur the_errno;
extern FILE   *fd_spy;


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:l_char
------------------

-Purpose:
        Read the acquisition file (FILE_RAO_PAR) character by character until a
	new line is found (i.e. read the file line by line) and transfer these
	characters in a string.

-Prototype:
	int l_char(fd,ligne);
-Parameters:
FILE *fd: file handle of the acquisition parameters file.
char *ligne: read and returned line from the file.
-Return:
This functions returns the number of character read before the new line or
-1 if the end of file is met. 

-Comments:
	
Important! The first character of a ligne is never considered (for 
compatibility reason with a PASCAL code...I guess...).

The string 'ligne' will then be used to identify the keywords and their values
and then use the associated function (defined in action.c) to store this
information in memory.

;;#f#<*********************************************************************/


int l_char(fd,ligne)
FILE	*fd;
char *ligne;
{
  int nlus=0,i=0,nl=0;
  char c=' ';
  char parasite;
	 
/* le premier caractere est un parasite pascal */

	fread(&parasite,sizeof(char),1,fd);
	 
  	while( (c!='\n')&&(!feof(fd)) )
	{
		nl = fread(&c,sizeof(char),1,fd);     
		ligne[i] = c;
		/*nlus+=1;*/
		i++;
	} 
	
	ligne[i]='\0';

 	if(!feof(fd))
		return(OK);
	else
	{
 		the_errno.code=errno;	
		return(ERROR);
   	}
}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:extrait_mcle
------------------

-Purpose:
	
Look for the first word in the string defined by "l_char" until the first
white space or '=' or '\n'.

Recherche le premier mot dans la chaine dfinie dans l_char jusqu'au premier
	caractre blanc ou signe = ou retour charriot.

-Prototype:
	int extrait_mcle(ligne,cle)

-Parameters:
    char *ligne : The line to analyze. It is obtain thanks to l_char.
    cle : The read and returned keyword.
-Return:
It returns OK !
-Comments:
The string 'cle' (which should correspond to a keyword) will then be 
tested in order to check it corresponds to a valid keyword. (This is done
in the function 'etudie_ligne' in the file decode_mcle.c).

;;#f#<*********************************************************************/


int extrait_mcle(ligne,cle)
char *ligne;
char *cle;
{
int indice=0;
 
 if(ligne[TAILLE_MCLE-1]=='=')
   { 
     do
       {
	 cle[indice]=ligne[indice];
	 indice++;
       }
     while((ligne[indice]!=' ')&&(ligne[indice]!='=')
	   &&(ligne[indice]!='\n')&&(indice<TAILLE_MCLE-1));

  
     cle[indice]='\0';
     return(OK);
   }
 else
   {
     the_errno.code=E_DECODE_SYNT;
     return(ERROR);
   }

}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:extrait_indice
------------------

-Purpose:
This functions allows to extract, from a line "ligne" read in FILE_RAO_PAR,
the value of the indice corresponding to the parameter which has been read 
in "ligne" thanks to the function 'extrait_mcle'.

What is called 'indice' here is the value (if it exists) located between
the keyword and the '=' in a line of the file FILE_RAO_PAR. 

-Prototype:
	long extrait_indice(ligne);
-Parameters:
char *ligne: The line to analyze. It is obtained thanks to l_char.
-UsesVariables:
		TAILLE_INDIC	(param.h)
-Return:
It returns the value of the read indice!	
-Comments:
This function will be called by (certain) functions defined in action.c.
;;#f#<*********************************************************************/


long extrait_indice(ligne)
char *ligne;
{
char	ch_indice[TAILLE_INDIC];
int	i_ligne=0,i_indice=0;

  do
  {
	 i_ligne++;
  }
  while((ligne[i_ligne]!=' ')&&(ligne[i_ligne]!='=')&&(i_ligne<TAILLE_MCLE));

  i_ligne++;
  
  if(i_ligne<TAILLE_MCLE)
    {
      do
	{
	  if( (isspace(ligne[i_ligne])) || (isdigit(ligne[i_ligne])))
	    {
	      ch_indice[i_indice]=ligne[i_ligne];
	      i_ligne++;
	      i_indice++;
	    }
	  else
	    {
	      message_spy(fd_spy,"\n<<indice en erreur>>");
	      return(ERROR);
	    }
	}
      while(ligne[i_ligne]!='=');
      
      ch_indice[i_indice]='\0';
      return(atol(ch_indice));
    }
  else
    return(ERROR);
}

long is_number(chaine)
char *chaine;
{
  int i,longueur;
  char message[TAILLE_MES];

 

  for(i=0;i<TAILLE_VALU;i++)
    {
      if((!isspace(chaine[i]))&&
	 (!isdigit(chaine[i]))&&
	 (chaine[i]!='-')&&
	 (chaine[i]!='+')&&
	 (chaine[i]!=1))
	{
	  sprintf(message,"\nISNUMBER<---%c---%d---%d--->",chaine[i],chaine[i],i);
	  message_spy(fd_spy,message);
	  return(ERROR);
	}
    }
  return(OK);

}

long is_float(chaine)
char *chaine;
{
  int i,longueur;
  char message[TAILLE_MES];


  for(i=0;i<TAILLE_VALU;i++)
    {
      if((!isspace(chaine[i]))&&
	 (!isdigit(chaine[i]))&&
	 (chaine[i]!='.')&&
	 (chaine[i]!='-')&&
	 (chaine[i]!='+')&&
	 (chaine[i]!=1))
	{
	  sprintf(message,"\nISFLOAT ind <---%d--->",i);
	  message_spy(fd_spy,message);
	  sprintf(message,"\nISFLOAT char<---%c--->",chaine[i]);
	  message_spy(fd_spy,message);
	  sprintf(message,"\nISFLOAT num <---%d--->",chaine[i]);
	  message_spy(fd_spy,message);
	  return(ERROR);
	}
    }
  return(OK);

}







