
static char *SccsId="@(#)affiche_tables.c	1.16 01/09/98";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:affiche_tables.c
-----------------
-Authors:	M Savinelli

-Purpose:
	Le fichier contient les fonctions d'affichage des tables du
	fichier de paramtres d'acquisition.

-Variables:
		Tb_acq *Pt_acq;		pointeur sur la table d'acquisition.
		Tb_enrg *Pt_enrg;	pointeur sur la table d'enregistrement.
		Tb_visu *Pt_visu;	pointeur sur la table de visualisation.	 	
-Functions:
		affiche_Tb_acq
		affiche_Tb_visu
		affiche_Tb_enrg
-Comments:
	Le fichier affiche  l'cran les tables du fichier de paramtres 
	d'acquisition.

;;#h#<*********************************************************************/


#include	<stdio.h>
#include	<acq.h>
#include	<enrg.h>
#include	<visu.h>

#include	<param.h>

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:affiche_Tb_acq
------------------

-Purpose:
	Rle d'affichage de la table d'acquisition.
	Note: include acq.h
-Prototype:
	void affiche_Tb_acq()

-UsesVariables:
		Tb_acq *Pt_acq	 

		TAILLE_MAX_MCLE		(param.h)
		NB_MAX_OBT		(acq.h)
		NB_MAX_FEN		(th_form.h)

;;#f#<*********************************************************************/

void affiche_Tb_acq(Pt_acq)
Tb_acq	*Pt_acq;
{
int ifen;
char mess[TAILLE_MAX_MCLE];

printf("\n\n AFFICHAGE DE TB_ACQ\n");
	
	printf("\n longueur de enfen = %d",Pt_acq->enfen);
	printf("\n modob             = %d",Pt_acq->modob);
	printf("\n ctrac             = %d",Pt_acq->ctrac);
	printf("\n cadac             = %d",Pt_acq->cadac);
	printf("\n monit             = %d",Pt_acq->monit);
	printf("\n mecan             = %d",Pt_acq->meca);
	printf("\n nbfen             = %d",Pt_acq->nbfen);

/* affichage des durees d'integration */

printf("\n\n AFFICHAGE DES DUREES D'INTEGRATION \n");

	printf("\t\tObturateur\tDuree (micro s)\n");

	for(ifen=0; ifen<NB_MAX_OBT; ifen++)
		printf("\t%12d\t\t%12d\n",ifen,Pt_acq->dintg[ifen]);

/* affichage des fenetres */
printf("\n\n AFFICHAGE DES DONNEES FENETRES\n\n");
printf ("Numero\tNumero\tNombre\tNombre\tLigne\tColonne\t  Sens\t   Type\n");
printf ("Fenetre\tCamera\tlignes\tcol.\tdebut\tdebut\tlecture\t  Donnees\n");

	for(ifen=0; ifen<NB_MAX_FEN; ifen++)
	{
	if(Pt_acq->tab_fen[ifen].nbcol != 0)
	  {
	  if( Pt_acq->tab_info_fen[ifen].sens == 0 ) 
		strcpy(mess,"Colonne");
	  else
		strcpy(mess ,"Ligne");

	  printf ("%7d%7d%8d%8d%7d%10d%10s%8d\n",
			ifen,
			Pt_acq->tab_info_fen[ifen].nocam,
			Pt_acq->tab_fen[ifen].nblig,
			Pt_acq->tab_fen[ifen].nbcol,
			Pt_acq->tab_fen[ifen].ligdb,
			Pt_acq->tab_fen[ifen].coldb,
			mess,
			Pt_acq->tab_info_fen[ifen].type);
	  }
	}

	
}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:affiche_Tb_visu
------------------

-Purposee:
	Rle d'affichage de la table de visualisation.

-Prototype:
	void affiche_Tb_visu()

-UsesVariables:
		Tb_visu *Pt_visu

		NB_MAX_FEN	(th_form.h)


;;#f#<*********************************************************************/
	
void affiche_Tb_visu(Pt_visu)
Tb_visu	*Pt_visu;
{
int ind;
	printf("\n\n AFFICHAGE DE TB_VISU\n");
	printf("\n Fenetres a visualiser:"); 

	for(ind=0; ind<NB_MAX_FEN; ind++)
  	{
  		if(Pt_visu->numfen[ind] == 1)
			printf(" %d",ind);
	}

	printf("\n");
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:affiche_Tb_enrg
------------------

-Purpose:
	Rle d'affichage de la table d'enregistrement.
-Prototype:
	void affiche_Tb_enrg()
-UsesVariables:
		Tb_enrg *Pt_enrg
		NB_MAX_FEN	(th_form.h)
;;#f#<*********************************************************************/ 

void affiche_Tb_enrg(Pt_enrg)
Tb_enrg	*Pt_enrg;
{
int ind;
	printf("\n\n AFFICHAGE DE TB_ENRG\n");

	printf("\n Fenetres a enregistrer:"); 

	for(ind=0; ind<NB_MAX_FEN; ind++)
  	{
  		if(Pt_enrg->numfen[ind] == 1)
			printf(" %d",ind);
	}

}

 
