
static char *SccsId="%W% %G%";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE: init-tab.c
-----------------
-Authors: Christian Miguel
-Library:
          param.a
-Purpose:	
This file contains the functions used to initialize the table of the common
memory (VME, SUN) which will be used to store the information read from the
acquisition parameters file FILE_RAO_PAR.
There exist different tables, regrouping different information, which can be
access thanks to the pointers: Pt_acq, Pt_ctrl,Pt_ctrl_cam, Pt_visu, Pt_enrg.
 	
-Functions:
		init_tb_acq 
		init_tb_ctrl 
		init_tb_ctrl_cam 
		init_tb_visu
		init_tb_enrg
	 
-Comments:
The initialization of the tables is done each time a new decoding of a 
acquisition parameter file (FILE_RAO_PAR) is done. The initialization will
first set default values (which is a security) before the real one are set
thanks to the decoding of the file.  

-Keywords:

keyword, parameter.

;;#h#<*********************************************************************/


#include 	<stdio.h>
#include  	<acq.h>
#include 	<enrg.h>
#include	<visu.h>


extern FILE *fd_spy;

  

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: init_tb_acq
------------------

-Purpose:
Initialization of the acquisition table. This means fill the acquisition
strucutre with 0 or default value before affecting the real value get from
the decoding of the file FILE_RAO_PAR>
	
Note: include acq.h et enrg.h
-Prototype:
	void init_tb_acq(Tb_acq *Pt_acq);
-Parameters:
	*Pt_acq:Pointer to the acquisition table.

-UsesVariables:
		NB_MAX_FEN	(th_form.h)
		NB_MAX_OBT	(acq.h)
		TAILLE_ENT_FEN	(enrg.h)
-Comments:
The size of the window header is set to TAILLE_ENT_FEN (i.e. 6) by default.
	
;;#f#<*********************************************************************/

void init_tb_acq(Pt_acq,format)
Tb_acq 	    *Pt_acq;
int         format;
{
  int i;

  Pt_acq->enfen=TAILLE_ENT_FEN;
  Pt_acq->nbfen=ZERO;
  Pt_acq->nbcam=ZERO;


  for(i=0;i<NB_MAX_FEN;i++)
    {
      Pt_acq->tab_fen[i].ligdb=ZERO;
      Pt_acq->tab_fen[i].coldb=ZERO;
      Pt_acq->tab_fen[i].nblig=ZERO;
      Pt_acq->tab_fen[i].nbcol=ZERO;
    }

  for(i=0;i<NB_MAX_FEN;i++)
    {
      Pt_acq->tab_info_fen[i].sens=ZERO;
      Pt_acq->tab_info_fen[i].nocam=NOTH;
      Pt_acq->tab_info_fen[i].nobuf=NOTH;
      Pt_acq->tab_info_fen[i].type=ZERO;
      Pt_acq->tab_info_fen[i].noplan=IMAGE;
      Pt_acq->tab_info_fen[i].mem_offset=NOTH;
    }

  for(i=0;i<NB_MAX_OBT;i++)
    {
      Pt_acq->dintg[i]=ZERO;
    }

  if(format != ZERO)
    {
      (Pt_acq->dyn).longitud=NOTH;
      (Pt_acq->dyn).latitud=NOTH;
      (Pt_acq->dyn).longcarr=NOTH;
      (Pt_acq->dyn).polarang=NOTH;
      (Pt_acq->dyn).svector=NOTH;
      (Pt_acq->index).seq_ind=NOTH;
      (Pt_acq->dyn).dist_ew=NOTH;
      (Pt_acq->dyn).dist_ns=NOTH;
      (Pt_acq->index).ind_reg = NOTH;
    }

  /*
  (Pt_acq->index).indstep= ZERO;
  (Pt_acq->index).indstepx= ZERO;
  (Pt_acq->index).indstepy= ZERO;
*/
  (Pt_acq->index).nbreg = NOTH;
  Pt_acq->nbacq=ZERO;
  Pt_acq->cadac=NOTH;
  Pt_acq->ctrac=NOTH;
  Pt_acq->modob=NOTH;
  Pt_acq->themisff=NOTH;
  Pt_acq->meca=ZERO;
  Pt_acq->monit=ZERO;
  Pt_acq->npix=ZERO;
}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:init_tb_ctrl
------------------

-Purpose:
This function allows to initialize the controle table Tb_ctrl. 

The controle table (Tb_ctrl) implements a read/write lock (on the shared memory
areas) between the VME and the SUN during the process of data acquisition.
Currently only two 'acquisition memory' areas are used: while the VME is 
writting data in one, the SUN is reading acquisition data in the other one.
For each 'acquisition memory' Tb_ctrl maintain a variable corresponding to
the action allowed on the memory area (VME write or SUN read). 
	
        Note: include acq.h

-Prototype:
	void init_tb_ctrl(Pt_ctrl,taille_zone);
-Parameters:
	Tb_ctrl	*Pt_ctrl: pointer to the controle table.
	long taille_zone:size of an acquisition memory area.
-UsesVariables:
		NB_MAX_EMPL	(acq.h)
		SUN_BUSY	(acq.h)

-Comments:
  Here, all the fields are set to SUN_BUSY (free for the VME and BUSY for the
SUN).
;;#f#<*********************************************************************/



void init_tb_ctrl(Pt_ctrl,taille_zone)
Tb_ctrl	    *Pt_ctrl;
long taille_zone;
{
/* Le champ qui pointe sur les donnees est positionne des l'allocation */
int i;

	Pt_ctrl->nb_empl=NB_MAX_EMPL;
	Pt_ctrl->taille_empl=taille_zone;

	for(i=0;i<NB_MAX_EMPL;i++)
	{
		Pt_ctrl->vervis[i]=SUN_BUSY;
		Pt_ctrl->verrou[i]=SUN_BUSY;
	}
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:init_tb_ctrl_cam
------------------

-Purpose:
Initialize the control table for the cameras interface: Tb_ctrl_cam. 
Basically, this table contains the 'state' of each camera.

-Prototype:
	void init_tb_ctrl_cam(Pt_cam);
-Parameters:
	Tb_ctrl_cam *Pt_cam: Pointer to the table.
-UsesVariables:
		NB_MAX_CAM		(tb_ctrl_cam.h)
	
-Comments:
Each field of the structis set to 0, Pt_cam->tab_reg_cam[i].n_obt=0 means
the default is : all the cameras are not in use. NO_FREEZE = 255, empeche
le refroidissement sur les cameras.

;;#f#<*********************************************************************/



void init_tb_ctrl_cam(Pt_cam)
Tb_ctrl_cam *Pt_cam;
{
int i;
	Pt_cam->cam_num=0;
	Pt_cam->plan_num=0;
	Pt_cam->controle=0;
	Pt_cam->etat=0;
	Pt_cam->obturateur=0;
	Pt_cam->go=0;
	Pt_cam->integration=0;
	Pt_cam->horloge=0;
	Pt_cam->watchdog=0;
	
	for(i=0;i<NB_MAX_CAM;i++)
	{
		Pt_cam->tab_reg_cam[i].etat=0;
		Pt_cam->tab_reg_cam[i].n_obt=0;
		Pt_cam->tab_reg_cam[i].theta=NO_FREEZE;
	}
}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:init_tb_enrg
------------------

-Purpose:
Initialization the recording table (Tb_enrg).

Tb_enrg contains, for each window to be recorded, the corresponding window 
number and recording file.

-Prototype:
	void init_tb_enrg(Pt_enrg);
-Parameters:
	Tb_enrg *Pt_enrg: pointer to the recording table.
-UsesVariables:
		NB_MAX_FEN (th_form.h)

;;#f#<*********************************************************************/


void init_tb_enrg(Pt_enrg,format)
Tb_enrg *Pt_enrg;
int      format;
{
  int i;
 char message[80];

	Pt_enrg->nbfen=ZERO;
	Pt_enrg->nb_li_princ=ZERO;
	Pt_enrg->nb_li_dyn=ZERO;
	Pt_enrg->indstart_dyn=ZERO;

	(Pt_enrg->tab_phy).naxis=NOTH;
	(Pt_enrg->tab_phy).naxis3=NOTH;
	(Pt_enrg->tab_phy).waveunit=NOTH;


	if(format != ZERO)
	  {
	    strcpy((Pt_enrg->tab_phy).physpara,EMPTY);
	    strcpy((Pt_enrg->tab_phy).object,EMPTY);
	    strcpy((Pt_enrg->tab_phy).obs_mode,EMPTY);
	    (Pt_enrg->tab_phy).longtrc=NOTH;
	    (Pt_enrg->tab_phy).latirc=NOTH;
	    strcpy((Pt_enrg->tab_phy).institut,EMPTY);
	    strcpy((Pt_enrg->tab_phy).cmp_name,EMPTY);
	    strcpy((Pt_enrg->tab_phy).contact,EMPTY);
	    strcpy((Pt_enrg->tab_phy).instrume,EMPTY);
	  }

	for(i=0;i<NB_MAX_FEN;i++)
	{
		Pt_enrg->numfen[i]=NOTH;
		Pt_enrg->fich[i]=NULL;
		(Pt_enrg->tab_phy).wavelnth[i]= -1;
	}
}	

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:init_tb_visu
------------------

-Purpose:
Initialization of the visu table(Tb_visu).
This table contains all the useful information regarding the visualisation ,
i.e. number of window to visualize, which ones, their size etc...
Note: include visu.h
-Prototype:
	void init_tb_visu(Pt_visu);
-Parameters:
	Tb_visu *Pt_visu: pointer to the visu table.
-UsesVariables:
		NB_MAX_FEN	(th_form.h)
-Comments:
 All the fields are set to 0.

;;#f#<*********************************************************************/

	

void init_tb_visu(Pt_visu)
Tb_visu *Pt_visu;
{
  int i;

  Pt_visu->nbfen=0;
  Pt_visu->modob=NOTH;
	
  for(i=0;i<NB_MAX_FEN;i++)
    {
      Pt_visu->numfen[i]=NOTH;
     
     
      Pt_visu->numcam_de_donnee[i]=NOTH;
      Pt_visu->tab_fen[i].ligdb=0;
      Pt_visu->tab_fen[i].coldb=0;
      Pt_visu->tab_fen[i].nblig=0;
      Pt_visu->tab_fen[i].nbcol=0;
    }

  for(i=0;i<NB_MAX_FEN_VISU;i++)
    {
      
      Pt_visu->numcam_de_fenvisu[i]=NOTH;
      Pt_visu->status_de_fenvisu[i]=0;
      Pt_visu->color[i]=NOTH;
    }


  for(i=0;i<NB_MAX_FEN_VISU;i++)
    {
      Pt_visu->minvi[i]=0;
      Pt_visu->maxvi[i]=0;
    }
}	










