
static char *SccsId="%W% %G%";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:def_mcle.c
-----------------
-Authors:Christian Miguel
-library: param.a
-Purpose:
 This file is only a definition file. It contains the definition of the
 table Mcle_spe[NB_MCLE_SPE] and others. Each element of this table is a
 structure with
 two fields:
      .mot_cle: string containing a keyword read from the FILE_RAO_PAR file
      (i.e. the paracq.don file).
      .fonction: pointer to the function to be used to store in memory the
      information relative to this keyword. 

Note that all these functions are written in the file action.c

How does it work?
The file containing the acquisition parameter (paracq.don) is parsed and
decoded in order to store the information it contains in memory. Each time
a keyword is met (i.e. at each line), it is identify and the information 
corresponding to this keyword is stored in memory thanks to its associated
function defined in action.c . Remember that all the information is stored
in the following pointer: Pt_acq, Pt_enrg, Pt_visu , Pt_ctrl_cam, Pt_ctrl, 
Pt_obs.
	
-Variables:
		Source_mcle	Mcle_spe[NB_MCLE_SPE]
		Source_mcle	Mcle_sol[NB_MCLE_SOL] (not currently used)
	 	
	 
-Comments:
In order to add a keyword:

    -Update the constante for the number of keywords: NB_MCLE_SPE (param.h)
    -Add the new keyword in the list Mcle_spe with its associated function.
    -Write the prototype of the function in param.h
    -Write the corresponding function in action.c

-Keywords:

keyword, parameter..

;;#h#<********************************************************************/



#include	<stdio.h>

#include	<acq.h>


Source_mcle Mcle_tout[NB_MCLE_TOUT] = {
  /* Mcle_spe[NB_MCLE_SPE] */
  {"MODOB\0",action_modob},
  {"NAXIS3\0",action_naxis3},
  {"OBTUR\0",action_obtur},
  {"TPCAM\0",action_tpcam},
  {"ANA\0"  ,action_rien},
  {"DINTG\0",action_dintg},
  {"NBACQ\0",action_nbacq},
  {"CTRAC\0",action_ctrac},
  {"CADAC\0",action_cadac},
  {"NBFEN\0",action_nbfen},
  {"NOCAM\0",action_nocam},
  {"NOBUF\0",action_nobuf},
  {"NBLIG\0",action_nblig},
  {"NBCOL\0",action_nbcol},
  {"LIGDB\0",action_ligdb},
  {"COLDB\0",action_coldb},
  {"VISUF\0",action_visuf},
  {"ENREG\0",action_enreg},
  {"NBCAM\0",action_nbcam},
  {"SENSL\0",action_sensl},
  {"THEMISFF\0",action_themisff},
  {"WAVLT\0",action_wavlt},
  {"LAMBD\0",action_lambd},
  {"NRBUF\0",action_nrbuf},
  {"CMP_DESC\0",action_cmp_desc},
  {"BINNING\0",action_binning},
  /* Mcle_fix */
  {"SIMPLE\0",action_simple},
  {"BITPIX\0",action_bitpix},
  {"EXTEND\0",action_extend},
  {"TELESCOP\0",action_telescop},
  {"ORIGIN\0",action_origin},
  {"BSCALE\0",action_bscale},
  {"BZERO\0",action_bzero},
  {"BLANK\0",action_blank},
  {"BUNIT\0",action_bunit},
  {"DIMPIX\0",action_dimpix},
  {"GRECHEL\0",action_grechel},
  {"XTENSION\0",action_xtension},
  {"PCOUNT\0",action_pcount},
  {"GCOUNT\0",action_gcount},
  /* Mcle_phy */
  {"NAXIS\0",action_naxis},
  {"CTYPE1\0",action_ctype1},
  {"CTYPE2\0",action_ctype2},
  {"CTYPE3\0",action_ctype3},
  {"OBS_TYPE\0",action_obs_type},
  {"PHYSPARA\0",action_physpara},
  {"EMAIL\0",action_email},
  {"AUTHOR\0",action_author},
  {"PROG_ID\0",action_prog_id},
  {"OBS_PROG\0",action_obs_prog},
  {"SCI_OBJ\0",action_sci_obj},
  {"CONTACT\0",action_contact},
  {"INSTITUT\0",action_institut},
  {"CMP_NAME\0",action_cmp_name},
  {"CMP_NO\0",action_cmp_no},
  {"CMP_TYPE\0",action_cmp_type},
  {"WAVEUNIT\0",action_waveunit},
  {"ANALYS\0",action_analys},
  {"INSTRUME\0",action_instrume},
  {"OBSERVER\0",action_observer},
  {"RESCIENT\0",action_rescient},
  {"OBJECT\0",action_object},
  {"OBJ_ID\0",action_obj_id},
  {"OBS_MODE\0",action_obs_mode},
  {"PROG_NUM\0",action_prog_num},
  {"DETECTOR\0",action_detector},
  {"TIMESTEP\0",action_timestep},
  {"FIELVIEW\0",action_fielview},
  {"IXWIDTH\0",action_ixwidth},
  {"IYWIDTH\0",action_iywidth},
  {"ACTIFMIR\0",action_actifmir},
  {"XSCALE\0",action_xscale},
  {"YSCALE\0",action_yscale},
  {"COUNT\0",action_count},
  {"ANGLE\0",action_angle},
  {"NOMASK\0",action_nomask},
  {"OFFNAME\0",action_offname},
  {"OFFSETS\0",action_offsets},
  {"FILEACQ\0",action_fileacq},
  {"NBREG\0",action_nbreg},
  {"LNGSTART\0",action_lngstart},
  {"LATSTART\0",action_latstart},
  {"SYSCOORD\0",action_syscoord},
  {"STEP_X\0",action_stepx},
  {"STEP_Y\0",action_stepy},
  {"NBSTEP\0",action_nbstep},
  {"NBSTEP_X\0",action_nbstepx},
  {"NBSTEP_Y\0",action_nbstepy},
  {"LATIRC\0",action_latirc},
  {"LONGTRC\0",action_longtrc},
  {"TCYCLE\0",action_tcycle},
  {"TREGION\0",action_tregion},
  {"GRPRED\0",action_grpred},
  {"SPATSC\0",action_spats},
  {"SPECSC\0",action_specs},
  {"SCALFAC\0",action_scalfac},
  {"SLIT\0",action_slit},
  {"FILTERCH\0",action_filterch},
  {"FILTERFE\0",action_filterfe},
  {"FILTERSP\0",action_filtersp},
  {"SEQ_STOK\0",action_seq_stok},
  {"NBLAMBD\0",action_nblambd},
  {"BEAMEX\0",action_beamex},
  {"COMMENT\0",action_comment},
  /* Mcle_sem */
  {"SOLROT_N\0",action_solrot_n},
  {"SOLAR_R\0",action_solar_r},
  {"SOLAR_P0\0",action_solar_p0},
  {"SOLAR_B0\0",action_solar_b0},
  {"PREDANG\0",action_predang},

  {"ECHELANG\0",action_echelang},
  {"TEMPQWP1\0",action_tempqwp1},
  {"TEMPQWP2\0",action_tempqwp2},
  {"TEMPBMSP\0",action_tempbmsp},

  {"END\0",action_end}
};


Source_mcle	Mcle_spe[NB_MCLE_SPE]=
	{
	 {"MODOB\0",action_modob},
	 {"NAXIS3\0",action_naxis3},
	 {"OBTUR\0",action_obtur},
	 {"TPCAM\0",action_tpcam},
	 {"ANA\0"  ,action_rien},
	 {"DINTG\0",action_dintg},
	 {"NBACQ\0",action_nbacq},
	 {"CTRAC\0",action_ctrac},
	 {"CADAC\0",action_cadac},
	 {"NBFEN\0",action_nbfen},
	 {"NOCAM\0",action_nocam},
	 {"NOBUF\0",action_nobuf},
	 {"NBLIG\0",action_nblig},
	 {"NBCOL\0",action_nbcol},
	 {"LIGDB\0",action_ligdb},
	 {"COLDB\0",action_coldb},
	 {"VISUF\0",action_visuf},
	 {"ENREG\0",action_enreg},
	 {"NBCAM\0",action_nbcam},
	 {"SENSL\0",action_sensl},
	 {"THEMISFF\0",action_themisff},
	 {"WAVLT\0",action_wavlt},
	 {"LAMBD\0",action_lambd},
	 {"NRBUF\0",action_nrbuf},
	 {"END\0",action_end}
	};


Source_mcle	   Mcle_fix[NB_MCLE_FIX]=
	{
	 {"SIMPLE\0",action_simple},
	 {"BITPIX\0",action_bitpix},
	 {"EXTEND\0",action_extend},
	 {"TELESCOP\0",action_telescop},
	 {"ORIGIN\0",action_origin},
	 {"BSCALE\0",action_bscale},
	 {"BZERO\0",action_bzero},
	 {"BLANK\0",action_blank},
	 {"BUNIT\0",action_bunit},
	 {"DIMPIX\0",action_dimpix},
	 {"END\0",action_end},
	 {"GRECHEL\0",action_grechel},
	 {"XTENSION\0",action_xtension},
	 {"PCOUNT\0",action_pcount},
	 {"GCOUNT\0",action_gcount}
	};


Source_mcle	Mcle_phy[NB_MCLE_PHY]=
	{
	 {"NAXIS\0",action_naxis},
	 {"CTYPE1\0",action_ctype1},
	 {"CTYPE2\0",action_ctype2},
	 {"CTYPE3\0",action_ctype3},
	 {"OBS_TYPE\0",action_obs_type},
	 {"PHYSPARA\0",action_physpara},
	 {"EMAIL\0",action_email},
	 {"AUTHOR\0",action_author},
	 {"PROG_ID\0",action_prog_id},
	 {"OBS_PROG\0",action_obs_prog},
	 {"SCI_OBJ\0",action_sci_obj},
	 {"CONTACT\0",action_contact},
	 {"INSTITUT\0",action_institut},
	 {"CMP_NAME\0",action_cmp_name},
	 {"CMP_NO\0",action_cmp_no},
	 {"CMP_TYPE\0",action_cmp_type},
	 {"WAVEUNIT\0",action_waveunit},
	 {"ANALYS\0",action_analys},
	 {"INSTRUME\0",action_instrume},
	 {"OBSERVER\0",action_observer},
	 {"RESCIENT\0",action_rescient},
	 {"OBJECT\0",action_object},
	 {"OBJ_ID\0",action_obj_id},
	 {"OBS_MODE\0",action_obs_mode},
	 {"PROG_NUM\0",action_prog_num},
	 {"DETECTOR\0",action_detector},
	 {"TIMESTEP\0",action_timestep},
	 {"FIELVIEW\0",action_fielview},
	 {"IXWIDTH\0",action_ixwidth},
	 {"IYWIDTH\0",action_iywidth},
	 {"ACTIFMIR\0",action_actifmir},
	 {"XSCALE\0",action_xscale},
	 {"YSCALE\0",action_yscale},
	 {"COUNT\0",action_count},
	 {"ANGLE\0",action_angle},
	 {"NOMASK\0",action_nomask},
	 {"OFFNAME\0",action_offname},
	 {"OFFSETS\0",action_offsets},
	 {"FILEACQ\0",action_fileacq},
	 {"NBREG\0",action_nbreg},
	 {"LNGSTART\0",action_lngstart},
	 {"LATSTART\0",action_latstart},
	 {"SYSCOORD\0",action_syscoord},
	 {"STEP_X\0",action_stepx},
	 {"STEP_Y\0",action_stepy},
	 {"NBSTEP\0",action_nbstep},
	 {"NBSTEP_X\0",action_nbstepx},
	 {"NBSTEP_Y\0",action_nbstepy},
	 {"LATIRC\0",action_latirc},
	 {"LONGTRC\0",action_longtrc},
	 {"TCYCLE\0",action_tcycle},
	 {"TREGION\0",action_tregion},
	 {"GRPRED\0",action_grpred},
	 {"SPATS\0",action_spats},
	 {"SPECS\0",action_specs},
	 {"SCALFAC\0",action_scalfac},
	 {"SLIT\0",action_slit},
	 {"FILTERCH\0",action_filterch},
	 {"FILTERFE\0",action_filterfe},
	 {"FILTERSP\0",action_filtersp},
	 {"SEQ_STOK\0",action_seq_stok},
	 {"NBLAMBD\0",action_nblambd},
	 {"BEAMEX\0",action_beamex},
	 {"COMMENT\0",action_comment},
	 {"END\0",action_end}
	};


Source_mcle	Mcle_sem[NB_MCLE_SEM]=
	{
	 {"SOLROT_N\0",action_solrot_n},
	 {"SOLAR_R\0",action_solar_r},
	 {"SOLAR_P0\0",action_solar_p0},
	 {"SOLAR_B0\0",action_solar_b0},
	 {"PREDANG\0",action_predang},
	 {"ECHELANG\0",action_echelang},
	 {"TEMPQWP1\0",action_tempqwp1},
	 {"TEMPQWP2\0",action_tempqwp2},
	 {"TEMPBMSP\0",action_tempbmsp},
	 {"END\0",action_end}
	};

char Liste_mcle[NB_MCLE][TAILLE_MCLE]=
        {
	 "SIMPLE\0",
	 "BITPIX\0",
	 "EXTEND\0",
	 "XTENSION\0",
	 "PCOUNT\0",
	 "GCOUNT\0",
	 "TELESCOP\0",
	 "ORIGIN\0",
	 "BSCALE\0",
	 "BZERO\0",
	 "BLANK\0",
	 "BUNIT\0",
	 "END\0",
	 "DIMPIX\0",
	 "GRECHEL\0",
	 "SOLROT_N\0",
	 "SOLAR_R\0",
	 "SOLAR_P0\0",
	 "SOLAR_B0\0",
	 "PREDANG\0",
	 "ECHELANG\0",
	 "LONGCARR\0",
	 "TEMPQWP1\0",
	 "TEMPQWP2\0",
	 "TEMPBMSP\0",
	 "NBCAM\0",
	 "NBWIN\0",
	 "NOWIN\0",
	 "NOBUF\0",
	 "NOCAM\0",
	 "NSHUTTER\0",
	 "EXPTIME\0",
	 "THEMISFF\0",
	 "ROWSTART\0",
	 "COLSTART\0",
	 "TEMPCAM\0",
	 "NAXIS\0",
	 "NAXIS1\0",
	 "NAXIS2\0",
	 "NAXIS3\0",
	 "CTYPE1\0",
	 "CTYPE2\0",
	 "CTYPE3\0",
	 "OBS_TYPE\0",
	 "PHYSPARA\0",
	 "EMAIL\0",
	 "AUTHOR\0",
	 "PROG_ID\0",
	 "OBS_PROG\0",
	 "SCI_OBJ\0",
	 "CONTACT\0",
	 "INSTITUT\0",
	 "CMP_NAME\0",
	 "CMP_NO\0",
	 "CMP_TYPE\0",
	 "WAVEUNIT\0",
	 "ANALYS\0",
	 "DATE_OBS\0",
	 "INSTRUME\0",
	 "OBSERVER\0",
	 "RESCIENT\0",
	 "OBJECT\0",
	 "OBJ_ID\0",
	 "OBS_MODE\0",
	 "PROG_NUM\0",
	 "FILENAME\0",
	 "FILEORIG\0",
	 "DETECTOR\0",
	 "TIMESTEP\0",
	 "FIELVIEW\0",
	 "IXWIDTH\0",
	 "IYWIDTH\0",
	 "ACTIFMIR\0",
	 "XSCALE\0",
	 "YSCALE\0",
	 "COUNT\0",
	 "WAVELNTH\0",
	 "ANGLE\0",
	 "NOMASK\0",
	 "OFFNAME\0",
	 "OFFSETS\0",
	 "FILEACQ\0",
	 "NBREG\0",
	 "LNGSTART\0",
	 "LATSTART\0",
	 "SYSCOORD\0",
	 "STEP_X\0",
	 "STEP_Y\0",
	 "NBSTEP\0",
	 "NBSTEP_X\0",
	 "NBSTEP_Y\0",
	 "LATIRC\0",
	 "LONGTRC\0",
	 "TCYCLE\0",
	 "TREGION\0",
	 "GRPRED\0",
	 "SPATS\0",
	 "SPECS\0",
	 "SPATSCAL\0",
	 "SPECSCAL\0",
	 "SCALFAC\0",
	 "SLIT\0",
	 "FILTERCH\0",
	 "FILTERFE\0",
	 "FILTERSP\0",
	 "SEQ_STOK\0",
	 "NBLAMBD\0",
	 "DATE_END\0",
	 "PREFENTE\0",
	 "POSROT\0",
	 "ELEVA\0",
         "AZIMUT\0",
         "ALPHA\0",
         "DELTA\0",
         "POLARANG\0",
         "SVECTOR\0",
         "LONGITUD\0",
         "LATITUD\0",
         "DATE-OBS\0",
         "SEQ_IND\0",
         "INDREG\0",
         "INDSTEPX\0",
         "INDSTEPY\0",
         "INDSTEP\0",
	 "LAMBD\0",
	 "INDLAMBD\0",
	 "STOKES\0",
	 "BEAMEX\0",
	 "COMMENT\0",
	 "DIST_NS\0",
	 "DIST_EW\0",
	 "NRBUF\0",
	 "CMP_DESC\0",
	 "BINNING\0",
	 "POSQWP1\0",
	 "POSQWP2\0"
	};

chfits Liste_instrume[NB_INSTRUME]=
       { 
	   "FULLDISK\0",
	   "MSDP\0",
	   "SPECTRA\0",
	   "IPM\0",
	   "F1\0",
	   "F2\0"
       };

chfits Liste_obs_mode[NB_OBS_MODE]=
{
  "FULLSUN\0",
  "SINGLE\0",
  "SCAN\0",
  "SERIES\0",
  "PATROL\0",
  "MFLAT\0",
  "RFLAT\0",
  "MDARK\0",
  "RDARK\0",
  "RFSTOP\0",
  "MFSTOP\0",
  "CALIB\0",
  "ENGINEERING\0",
  "TEST\0"
};

chfits Liste_instituts[NB_INSTITUTS]=
{
  "THEMIS\0",
  "IAC\0",
  "PICDUMIDI\0",
  "OAC\0",
  "MEUDON\0",
  "ARCETRI\0",
  "PARISOBS\0",
  "UTRECHT\0",
  "NANCAY\0",
  "OMP\0",
  "OCA\0",
  "UNIFIRENZE\0",
  "UNITORVERGATA\0",
  "IFSI_CNR\0",
  "UNILAQUILA\0",
  "UNICALABRIA\0",
  "UNINAPOLI\0"
};



  
/*Tableau contenant les mots cle devant apparaitre dans les entetes
principales des fichiers. Ces informations sont classees suivant l'ordre
d'apparition dans l'entete FITS!.*/

Param_info Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];

/*Tableau contenant les mots cle devat apparaitre dans les entetes 
dynamiques. Ces informations sont classees suivant l'ordre
d'apparition dans l'entete FITS!.*/

Param_info Tb_header_dyn [NB_LI_BLOC_FITS+NB_LI_BLOC_FITS*NB_MAX_FEN];

/*Pointeur sur la structure contenant l'entete principale ecrite en memoire.*/

Mem_header *Pt_top_header;

Mem_header *Pt_dyn_header;

/*Listes des mots cles exceptionnels..c'est a dire devant apparaitre dans les*/
/*entetes FITS dans un ordre precis...*/
/*Chaque ligne de la liste est associee a un type de header. Elle est *?
/*completee par des NOTH en cas de taille inferieure a TAILLE_MAX_LIST_ORDO*/
Ind_mcle Liste_ordo[NB_TYPE_HEADER][TAILLE_MAX_LIST_ORDO]=
{
  {_SIMPLE,_BITPIX,_NAXIS,_NAXIS1,_NAXIS2,_NAXIS3,_EXTEND,NOTH},
  {_XTENSION,_BITPIX,_NAXIS,_NAXIS1,_NAXIS2,_PCOUNT,_GCOUNT,_NAXIS3}
};



