
static char *SccsId="%W% %G%";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:decode_mcle.c
-----------------
-Authors:	C Miguel
-Purpose:
	Etude des lignes du fichier de paramtres d'acquisition et des
	autres fichiers (paracq.fix, paracq.sem, paracq.phy, paracq.don)
		
-Comments:
	Etude du contenu des lignes du fichier.
	Dcodage, lancement des actions correspondantes aux mots cl.
	

;;#h#<*********************************************************************/


#include <stdio.h>
#include <fcntl.h>
#include <errno.h>

#include	<sun.h>
#include 	<acq.h>
#include 	<enrg.h>
#include 	<visu.h>
#include 	<param.h>
#include 	<the_errno.h>


extern FILE *fd_spy;


extern 	Erreur the_errno;
extern	int errno;


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:etudie_ligne
------------------

-Purpose:
	Recherche le mot cl dans la ligne et sa validit et lance l'action 
	correspondante.
-Prototype:
	int etudie_ligne(Mcle,nb_mcle,ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
-Parameters:
	Source_mcle	*Mcle :
	int		nb_mcle :
	char 		*ligne :
	Tb_enrg 	*Pt_enrg :
	Tb_visu 	*Pt_visu :
	Tb_acq  	*Pt_acq :
	Tb_ctrl_cam	*Pt_cam :

-Return:
	0 si ok
	-1 si le mot cl n'est pas trouv (ce qui provoque la sortie).
-UsesVariables:
		TAILLE_MCLE		(param.h)
		 	
-usesFunctions:
		extrait_mcle		(util_param)

-Example:
	Si le mot cl NBFEN est trouv on lance action_nbfen. 

;;#f#<*********************************************************************/


int etudie_ligne(Mcle,nb_mcle,ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)

Source_mcle	*Mcle;
int		nb_mcle;
char 		*ligne;
Tb_enrg 	*Pt_enrg;
Tb_visu 	*Pt_visu;
Tb_acq  	*Pt_acq;
Tb_ctrl_cam	*Pt_cam;
{
  char	motcle[TAILLE_MCLE];
  char    message[TAILLE_MES];
  int	indice_mcle=0;
  int	end=1;
  int	retour_action=OK;
 	 

  

  if(ERROR==extrait_mcle(ligne,motcle))
    {
      return(ERROR);
    }
  sprintf(message," [%s]",motcle);


  while((end)&&(indice_mcle<nb_mcle))
    {
		 
      if(strcmp(motcle,Mcle[indice_mcle].mot_cle)==0)
	{
	  end=0;

	  retour_action=(Mcle[indice_mcle].fonction)(ligne,Pt_enrg,Pt_visu,
						     Pt_acq,Pt_cam);
	  indice_mcle=0;
	}

      indice_mcle++;
    }

  /* Erreur de syntaxe ou de parametre*/

  if(retour_action==DECODE_FIN)
    return(DECODE_FIN);

  if(retour_action==ERROR)
    return(ERROR);

  if(indice_mcle==nb_mcle)
    {
		
      the_errno.code=E_DECODE_SYNT;		
      return(ERROR);
    }

  return(OK);
}




/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:analyseur_fich
------------------

-Purpose:
	Ouverture et lecture du fichier de paramtres d'acquisition.

-Prototype:
	int analyseur_fich(Mcle,nb_mcle,nom_fich,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
-Parameters:
Source_mcle	*Mcle :	Liste des mots cl et des actions correspondantes
int		nb_mcle :
char 		*nom_fich :
Tb_enrg		*Pt_enrg :
Tb_visu		*Pt_visu :
Tb_acq		*Pt_acq :
Tb_ctrl_cam	*Pt_cam :

-Return:
	0 si ok
	Sinon, le numro de la ligne du fichier de paramtres d'acquisition qui
	a caus une erreur.
-Comments:
	Tant que l'on ne trouve pas le mot cl END, la fonction tudie les 
	lignes.
-UsesVariables:
		TAILLE_LIGNE	(param.h)
	
-UsesFunctions:
		etudie_ligne
		l_char()	(util_param)

;;#f#<*********************************************************************/

int analyseur_fich(Mcle,nb_mcle,nom_fich,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)

Source_mcle	*Mcle;
int		nb_mcle;
char 		*nom_fich;
Tb_enrg		*Pt_enrg;
Tb_visu		*Pt_visu;
Tb_acq		*Pt_acq;
Tb_ctrl_cam	*Pt_cam;
{
  FILE	*desc_fich;
  char	*ligne;
  int	i,retour_etude=0;
  int	compteur_ligne=0;
  char  message[TAILLE_MES];

  desc_fich=fopen(nom_fich,"r");
  ligne=(char *)malloc(sizeof(char)*TAILLE_LIGNE);	



  if(desc_fich!=NULL)
    {

      do
	{
	  compteur_ligne++;
	
	  sprintf(message,"\n-----------> ligne %i",compteur_ligne);

	  if(l_char(desc_fich,ligne)!=ERROR)
	    {
	      retour_etude=etudie_ligne(Mcle,nb_mcle,ligne,Pt_enrg\
					,Pt_visu,Pt_acq,Pt_cam);
	    }
	  else
	      retour_etude=ERROR;
	}
      while(retour_etude==OK);	

      free(ligne);
      fclose(desc_fich);

      if( (retour_etude==OK)||(retour_etude==DECODE_FIN) )
	return(OK);
      else
	{
	  message_spy(fd_spy,"\n dans ana fich affectation de ctxt et numero");
	  the_errno.numero=compteur_ligne;
	  the_errno.ctxt=ALALIGNE;
	  return(compteur_ligne);
	}
    }
  else
    {
      the_errno.code=errno;
      return(ERROR);
    }
}














