
static char *SccsId="%W% %G%";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:ctrl_param.c
-----------------
-Authors:Christian Miguel
-Library:
            param.a
-Purpose:
This file contains the functions which allows to control the acquisition
parameters (read from the file FILE_RAO_PAR). These functions check the
global coherence of the parameters.


-Functions:
		check_param
		check_mode
		check_intg
		check_cam
		check_fen
		check_visu
		check_enrg


-Keywords:

keyword, parameter.
		
;;#h#<*********************************************************************/



#include 	<stdio.h>

#include	<sun.h>
#include	<acq.h>
#include	<visu.h>
#include	<enrg.h>
#include	<the_errno.h>
#include	<camera.h>
#include        <param.h>

extern 	Erreur	the_errno;
extern  FILE    *fd_spy;
extern Param_info Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];
extern  chfits          Liste_obs_mode[NB_OBS_MODE];


int complete_motcle(Pt_acq,Pt_enrg,Pt_cam,Pt_visu)
Tb_acq		*Pt_acq;
Tb_enrg		*Pt_enrg;
Tb_ctrl_cam	*Pt_cam;
Tb_visu		*Pt_visu;
{
  int ind=0;
  long value,buf,obt;
  char message[TAILLE_MES];
  double new_val;

  for(ind=0;ind<Pt_enrg->nb_li_princ;ind++)
    {
      switch(Tb_header_princ[ind].indice)
	{
	case _EXPTIME:
	  {
	    message_spy(fd_spy,"\nCTRL.C 10 EXPTIME");
	    buf=Tb_header_princ[ind].value.type_long;
	    sprintf(message," buffer %d",buf);
	    message_spy(fd_spy,"\nCTRL.C 10.01 EXPTIME");
	    message_spy(fd_spy,message);

	    obt=Pt_cam->tab_reg_cam[buf].n_obt;
	    sprintf(message," obturateur %d",obt);
	    message_spy(fd_spy,"\nCTRL.C 10.02 EXPTIME");
	    message_spy(fd_spy,message);
	    value=Pt_acq->dintg[obt];
	    message_spy(fd_spy,"\nCTRL.C 10.1 EXPTIME");
	    Tb_header_princ[ind].type=TYPE_DOUBLE;
	    new_val = value;
	    new_val = new_val/1000;
	    Tb_header_princ[ind].value.type_double=new_val;
	    message_spy(fd_spy,"\nCTRL.C 10.2 EXPTIME");
	    break;
	  }
	case _NSHUTTER:
	  {
	
	    buf=Tb_header_princ[ind].value.type_long;
	    value=Pt_cam->tab_reg_cam[buf].n_obt;
	    Tb_header_princ[ind].value.type_long=value;
	
	    break;
	  }
	case _TEMPCAM:
	  {
	
	    buf=Tb_header_princ[ind].value.type_long;
	    value=Pt_cam->tab_reg_cam[buf].theta;
	    Tb_header_princ[ind].value.type_long=value;
	
	    break;
	  }
	default:
	  break;
	}
    }
  return(OK);
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:check_param
------------------

-Purpose:
This function allows to check the coherence of the acquisition parameters and
to avoid contradictions between different parameters.
	
-Prototype:
	int check_param(Pt_acq,Pt_enrg,Pt_cam,Pt_visu);
-Parameters:
	Tb_acq	*Pt_acq : pointer to the acqusition table (cf acq.h)
	Tb_enrg	*Pt_enrg : pointer to the recording table( cf enrg.h)
	Tb_ctrl_cam *Pt_cam : pointer to the ctrl camera table( tb_ctrl_cam.h)
	Tb_visu : pointer to the visu table (cf visu.h) 
-UsesFunctions:
                check_mode
		check_intg
		check_cam
		check_fen
		check_visu
		check_enrg

-Return:
	0 or -1 . In the last case, the function set the error variable 
the_errno to the corresponding error code.

-Comments:
This function is the main controle function, it uses the other one (see 
the previous field "Uses Functions").

;;#f#<*********************************************************************/

int check_param(Pt_acq,Pt_enrg,Pt_cam,Pt_visu)
Tb_acq		*Pt_acq;
Tb_enrg		*Pt_enrg;
Tb_ctrl_cam	*Pt_cam;
Tb_visu		*Pt_visu;
{
  char message[TAILLE_MES];

  if(Pt_enrg!=NULL)
    {
      if(Pt_acq->nbfen==NOTH)
	{
	  the_errno.code=E_BAD_FEN_NUM;
	  the_errno.where=FICH_PARA;
	  return(ERROR);
	}

      if((ERROR==check_mode(Pt_acq,Pt_enrg))||
	 (ERROR==check_intg(Pt_acq))||
	 (ERROR==check_fen(Pt_acq))||
	 (ERROR==check_cam(Pt_cam,Pt_acq))||
	 (ERROR==check_enrg(Pt_enrg,Pt_acq))||
	 (ERROR==check_b2000(Pt_enrg,Pt_acq)))
	return(ERROR);
				
    }


  if(OK==complete_motcle(Pt_acq,Pt_enrg,Pt_cam,Pt_visu))
    {
      sprintf(message," nb mot cle: %i",Pt_enrg->nb_li_princ);
      return(OK);
    }


}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:check_mode
------------------

-Purpose:
This function checks the "small" parameters of the acquisition table such as
the observation mode (modob)...
The goal here is not to detect a wrong value for a parameter (because this 
is done in the corresponding 'action' functions!) but rather to be sure
that mandatory parameters have really been specified in the file FILE_RAO_PAR
and recorded in the acquisition table!

-Prototype:
	int check_mode(Pt_acq)
-Parameters:
Tb_acq *Pt_acq: pointer to the acquisition table (cf acq.h)
-Return: 
OK or ERROR et set 'the_errno' to the corresponding error code.

-Comments:
Here, currently, only two parameters are checked in order to ensure that they
really have been specified in the acquisition parameters file (FILE_RAO_PAR).
They are 'modob' and 'ctrac'.
;;#f#<*********************************************************************/


int check_mode(Pt_acq,Pt_enrg)

Tb_acq *Pt_acq;
Tb_enrg	*Pt_enrg;
{
  char message[TAILLE_MES];

  message_spy(fd_spy,"\nDans check_mode");


  sprintf(message,"\nthemisff = %d",Pt_acq->themisff);
  message_spy(fd_spy,message);

  sprintf(message,"\nnaxis = %d",(Pt_enrg->tab_phy).naxis);
  message_spy(fd_spy,message);

  sprintf(message,"\nnaxis3 = %d",(Pt_enrg->tab_phy).naxis3);
  message_spy(fd_spy,message);

  sprintf(message,"\nextend = %c",(Pt_enrg->tab_fix).extend);
  message_spy(fd_spy,message);



  switch(Pt_acq->themisff)
    {
    case OK:
      {
	if(Pt_acq->modob==NOTH)
	  {
	    the_errno.code=E_NO_MODOB;
	    the_errno.where=FICH_PARA;
	    return(ERROR);
	  }
	break;
      }
    case FITS3:
      { message_spy(fd_spy,"\nDans check_mode fits 3");
	
	if(((Pt_enrg->tab_phy).naxis != 3)||((Pt_enrg->tab_phy).naxis3 == NOTH))
	  {
	    the_errno.code=E_BAD_NAXIS;
	    the_errno.ctxt=FORMATAGE;
	    return(ERROR);
	  }
	break;
      }
    /* FITS 1 et 2 */
    case FITS2:
      {
	 message_spy(fd_spy,"\nDans check_mode fits2");
	if(((Pt_enrg->tab_phy).naxis != 2) || ((Pt_enrg->tab_phy).naxis3 != NOTH))
	  {
	    the_errno.code=E_BAD_NAXIS;
	    the_errno.ctxt=FORMATAGE;
	    return(ERROR);
	  }
	if((Pt_enrg->tab_fix).extend != 'T')
	  {
	    the_errno.code=E_BAD_NAXIS;
	    the_errno.ctxt=FORMATAGE;
	    the_errno.where=FICH_PAR_FIX;
	    return(ERROR);
	  }

      }
    default:
      {
	if(((Pt_enrg->tab_phy).naxis != 2) || ((Pt_enrg->tab_phy).naxis3 != NOTH))
	  {
	    the_errno.code=E_BAD_NAXIS;
	    the_errno.ctxt=FORMATAGE;
	    return(ERROR);
	  }
      }
    }



  return(OK);
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:check_intg
------------------

-Purpose:
Checks that the parameters for the integration times are ok.
In particular the following inequality must be met in order to allow
a coherent evolution of the program:
<LISTING><H4>max(dintg)+temps de num < cadence</H4></LISTING>
-Prototype:
	int check_intg(Pt_acq);
-Parameters:
	Tb_acq	*Pt_acq: pointer to the acquisition table. (cf acq.h)
-Return:
	OK or ERROR (resp 0 ou -1). In the last case, the_errno is set to the corresponding error code. Note that E_BAD_DINTG means a wrong integration time.
-Comments:

Note that, currently, this must be checked only when the 'ctrac' parameter is
set to CADENCEUR (i.e. 2).In the other cases SIMPLE (only one acquisition) or
CONTINU (new acquisition as soon as possible) this has no sense anymore. 
;;#f#<*********************************************************************/

int check_intg(Pt_acq)

Tb_acq	*Pt_acq;
{
  int 	i;
  long	maxdintg=0;

  /* verifie que max(dintg)+temps de num < cadence */


  if(Pt_acq->ctrac==CADENCEUR)
    {
      if(Pt_acq->cadac==NOTH)
	{
	  the_errno.code=E_NO_CAD;
	  the_errno.where=FICH_PARA;
	  return(ERROR);
	}

      for(i=0;i<NB_MAX_OBT;i++)
	{
	  if(Pt_acq->dintg[i]>maxdintg)
	    maxdintg=Pt_acq->dintg[i];
	}

      

      if(Pt_acq->cadac<=TPS_NUM_PRAT+TPS_LECT*Pt_acq->nbfen)
	{
	  the_errno.code=E_NO_CAD;
	  return(ERROR);
	}
    }
  return(OK);
}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:check_cam
------------------

-Purpose:
Check that the cameras parameters are coherent. The number of cameras (resp
of window)  must be equal to NBCAM (resp NBFEN) in the acquisition parameters
file FILE_RAO_PAR.

-Prototype:
	int check_cam(Pt_cam,Pt_acq)
-Parameters:
	Tb_ctrl_cam	*Pt_cam :pointer to the cameras table.
	Tb_acq		*Pt_acq :pointer to the acquisition table.

-Return:
 OK or ERROR. In the last case,the error code returned in the_errno can be:
 ->E_BAD_CAM_NUM: cameras numbers don't match.
 ->E_BAD_FEN_NUM:windows numbers don't match.

-Comments:
This is important because it allow to detect an error in the acquisition
parameters file. The fields Pt_acq->nbcam (resp Pt_acq->nbfen) is set 
thanks to the keyword _NBCAM (resp _NBFEN) which is independant from the
way the list of used camera and windows are build (thanks to _NOCAM).
 
-Example:
If the acquisition parameters file contains the lines:
<LISTING><H4>
        NBFEN      =           3
	NOCAM     0=           1
	NOCAM     1=           2
</H4></LISTING>
Then a camera is missing and E_BAD_CAM_NUM is returned in the_errno.
;;#f#<*********************************************************************/

int check_cam(Pt_cam,Pt_acq)

Tb_ctrl_cam	*Pt_cam;
Tb_acq		*Pt_acq;
{
  int	i,nbbuf=0,nbfen=Pt_acq->nbfen,nobuf,nocam;
  int   nbcam=0;
  long	checker[NB_MAX_CAM];


  init_tableau(ERROR,checker,NB_MAX_CAM);
  
  for(i=0;i<nbfen;i++)
    {

      nobuf=Pt_acq->tab_info_fen[i].nobuf;
      nocam=Pt_acq->tab_info_fen[i].nocam;

      if(in_tab(nocam,checker,NB_MAX_CAM)==ERROR)
	{
	  nbcam++;
	  checker[nocam-1]=nocam;	      
	}


      if(Pt_cam->tab_reg_cam[nobuf].n_obt==NOTH)
	{
	  the_errno.code=E_BAD_OBTUR; 
	  the_errno.ctxt=CAMERAS;
	  the_errno.numero=Pt_acq->tab_info_fen[i].nocam;
	  return(ERROR);
	}

      if(Pt_acq->dintg[Pt_cam->tab_reg_cam[nobuf].n_obt]<TPS_INTG_MIN)
	{
	  the_errno.code=E_BAD_DINTG;
	  the_errno.ctxt=OBTURAT;
	  the_errno.numero=Pt_cam->tab_reg_cam[nobuf].n_obt;
	  return(ERROR);
	}
    }
  
  if(nbcam != Pt_acq->nbcam)
    {
      the_errno.code=E_BAD_CAM_NB;
      return(ERROR);
    }
    
  return(OK);
}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:check_fen
------------------

-Purpose:
Check that the window parameters are ok.
-Prototype:
	int check_fen(Pt_acq)
-Parameters:
	Tb_acq *Pt_acq :pointer to the acquisition table.
-UsesVariables:
     		MAX_COL_CCD     (see camera.h)
		MAX_LIG_CCD     (see camera.h)
		E_BAD_FENCOOR   (see the_errno.h)
-Return:
 OK or ERROR. In the last case, th_errno is set to E_BAD_FENCOOR.

;;#f#<*********************************************************************/

int check_fen(Pt_acq)

Tb_acq	*Pt_acq;
{
  int fen,nbfen=Pt_acq->nbfen;
  long nbcol,coldb,nblig,ligdb;
 

  for(fen=0;fen<nbfen;fen++)
    {
      if(Pt_acq->tab_info_fen[fen].nocam==NOTH)
	{
	  the_errno.where=FICH_PARA;
	  the_errno.code=E_BADCAM_NUM;
	  the_errno.ctxt=FENETRES;
	  the_errno.numero=fen;
	  return(ERROR);
	}

      if(Pt_acq->tab_info_fen[fen].nobuf==NOTH)
	{
	  the_errno.where=FICH_PARA;
	  the_errno.code=E_BAD_BUF;
	  the_errno.ctxt=FENETRES;
	  the_errno.numero=fen;
	  return(ERROR);
	}
      
      nbcol=Pt_acq->tab_fen[fen].nbcol;
      coldb=Pt_acq->tab_fen[fen].coldb;
      nblig=Pt_acq->tab_fen[fen].nblig;
      ligdb=Pt_acq->tab_fen[fen].ligdb;

      if(((nbcol+coldb)>MAX_COL_CCD)||((nblig+ligdb)>MAX_LIG_CCD)||
	 (nbcol==0)||(nblig==0))
	{
	  the_errno.code=E_BAD_FENCOOR;
	  the_errno.where=FICH_PARA;
	  the_errno.ctxt=FENETRES;
	  the_errno.numero=fen;
	  return(ERROR);
	}	
	
    }
  return(OK);
}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:check_visu
------------------

-Purpose:
Check that the windows set for visualization (in Pt_visu) are really defined
(i.e. they are associated to a camera in Pt_acq) and that their number 
corresponds to the field Pt_visu->nbfen. 
    
-Prototype:
	int check_visu(Pt_visu,Pt_acq);
-Parameters:
	Tb_visu	*Pt_visu :pointer to the visu table  (cf visu.h)
	Tb_acq	*Pt_acq :pointer to the acquisition table  (cf acq.h)

-UsesVariables:
		NB_MAX_FEN (see th_form.h)	
		E_BAD_FENVISU (see the_errno.h)
-Return:
 ERROR or OK. In the last case E_BAD_FENVISU is returned in 'the_errno.code'.


;;#f#<*********************************************************************/


int check_visu(Pt_visu,Pt_acq)

Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
{
  int i,nbfen=Pt_acq->nbfen;


  for(i=0;i<NB_MAX_FEN;i++)
    {
      if((Pt_visu->numfen[i]==1)&&(i>nbfen))
	{
	  the_errno.ctxt=FENETRES;
	  the_errno.numero=i;
	  the_errno.code=E_BAD_FENVISU;
	  return(ERROR);

	}
    }
  return(OK);
}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:check_enrg
------------------
-Purpose:
Check that all the windows set for recording are defined: i.e they correspond
to an existing camera. And check also that their number is equal to the field
Pt_enrg->nbfen.
-Prototype:
	int check_enrg(Pt_enrg, Pt_acq);
-Parameters:
	Tb_enrg	*Pt_enrg :pointer to the recording table (enrg.h)
	Tb_acq	*Pt_acq :pointer to the acquisition table (acq.h)
-UsesVariables:
		NB_MAX_FEN (th_form.h)
		E_BAD_FENENRG (the_errno.h)
-Return:
	OK or ERROR. In the last case the_errno.code is set to E_BAD_FENENRG.
-Comments:
It is important to be acquisition and recording! A window (a camera) can be 
required for acquisition (which means that the data arrive on the VME) but
not for recording (which means not to store them on disk): for instance if
the window is only required for visualisation.
	
;;#f#<*********************************************************************/


int check_enrg (Pt_enrg,Pt_acq)

Tb_enrg	*Pt_enrg;
Tb_acq	*Pt_acq;
{
  int i,nbfen=Pt_acq->nbfen,nbfencheck=0;


  for(i=0;i<nbfen;i++)
    {
      if(Pt_enrg->numfen[i]==1)
	{
	  if(i>nbfen)   
	    {
	      the_errno.code=E_BAD_FENENRG;
	      the_errno.ctxt=FENETRES;
	      the_errno.numero=i;
	      the_errno.where=FICH_PARA;
	      return(ERROR);
	    }
	  nbfencheck++;
	}
      
      if( (Pt_enrg->tab_phy).wavelnth[i] == NOTH)
	{
	  the_errno.code=E_BAD_WAVE;
	  the_errno.where=FICH_PARA;
	  the_errno.ctxt=FENETRES;
	  the_errno.numero=i;
	  return(ERROR);
	}

    }

  if(nbfencheck==Pt_enrg->nbfen)
    return(OK);
  else
    {
      the_errno.code=E_BAD_ENRGNUM;
      the_errno.where=FICH_PARA;
      return(ERROR);
    }

}

int check_b2000 (Pt_enrg,Pt_acq)

Tb_enrg	*Pt_enrg;
Tb_acq	*Pt_acq;
{
  int i,nbfen=Pt_acq->nbfen,nbfencheck=0;
  char message[TAILLE_MES];


  if(Pt_acq->themisff != OK)
    {
  
      if(Pt_enrg->tab_phy.waveunit == NOTH)
	{
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_WAVEUNIT;
	  return(ERROR);
	}
      if(Pt_acq->dyn.longitud == NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_LONGITUD;
	  return(ERROR);
	}
      if(Pt_acq->dyn.latitud == NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_LATITUD;
	  return(ERROR);
	}
      if(Pt_acq->dyn.longcarr == NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_LONGCARR;
	  return(ERROR);
	}
      if(Pt_acq->dyn.polarang == NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_POLARANG;
	  return(ERROR);
	}
      if(Pt_acq->dyn.svector == NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_SVECTOR;
	  return(ERROR);
	}
      if(Pt_acq->index.seq_ind== NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_SEQ_IND;
	  return(ERROR);
	}
      if(Pt_acq->index.nblambd== NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_NBLAMBD;
	  return(ERROR);
	}

      sprintf(message,"\n-->ctrl_param: INDLAMBD = %d",(Pt_acq->index).indlambd);
      message_spy(fd_spy,message);

      if(Pt_acq->index.indlambd== NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_INDLAMBD;
	  return(ERROR);
	}
      if(Pt_acq->index.nbreg== NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_NBREG;
	  return(ERROR);
	}

      if(Pt_acq->index.ind_reg== NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_INDREG;
	  return(ERROR);
	}


      if(Pt_enrg->tab_phy.longtrc == NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_LONGTRC;
	  return(ERROR);
	}
      if(Pt_enrg->tab_phy.latirc == NOTH)
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_LATIRC;
	  return(ERROR);
	}
      if(OK == strcmp(Pt_enrg->tab_phy.institut,EMPTY))
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_INSTITUT;
	  return(ERROR);
	}
      if(OK == strcmp(Pt_enrg->tab_phy.cmp_name,EMPTY))
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_CMP_NAME;
	  return(ERROR);
	}
      if(OK == strcmp(Pt_enrg->tab_phy.contact,EMPTY))
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_CONTACT;
	  return(ERROR);
	}
      if(OK == strcmp(Pt_enrg->tab_phy.instrume,EMPTY))
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_INSTRUME;
	  return(ERROR);
	}
      if(OK == strcmp(Pt_enrg->tab_phy.physpara,EMPTY))
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_PHYSPARA;
	  return(ERROR);
	}
      if(OK == strcmp(Pt_enrg->tab_phy.object,EMPTY))
	{ 
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_OBJECT;
	  return(ERROR);
	}
      if(OK == strcmp(Pt_enrg->tab_phy.obs_mode,EMPTY))
	{
	  the_errno.code=E_BASS2000;
	  the_errno.ctxt=MMOTCLE;
	  the_errno.numero=_OBS_MODE;
	  return(ERROR);       
	}
    }
  message_spy(fd_spy,"\nCTRL.C 7 check_bass2000");
  return(OK);

}


int test_obs_mode(obsmode)
chfits obsmode;
{
int index=0;

  while((strstr(obsmode,Liste_obs_mode[index]) == NULL)&&(index<NB_OBS_MODE))
    {
      index++;
    }
  if(index == NB_OBS_MODE)
    return(ERROR);
  else
    return(OK);
}












