
static char *SccsId="@(#)action_sem.c	1.25 07/24/98";

/********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:action.c
-----------------
-Authors:      C Miguel
-Library:
             param.a
-Purpose:
This File contains the functions dealing with the keywords, each keyword
corresponds to an action for the program which reads the parameter file
(FILE_RAO_SEM).
The acquisition parameters must be read and stored in memory. Once a keyword
is found in the file, the program starts the corresponding action which is
named action_<keyword found>. All the following functions are stored in a
Variable the documentation is in the def_mcle.c file.


-Functions:

		action_end
	 
-Comments:

1)The functions returns:
	->	0 if ok 
	->	-1 if error (syntaxe ou smantique)
	->	+1 when the end keyword is found.
All the lines in the parameters file start with a meaningless letter (usually
"_"), this due to a difficult compatibility between the different languages
found in the data acquisition.


2)The acquisition parameter file (FILE_RAO_PAR) contains a keyword by
line. One can distinguish two types of line depending of the corresponding
keyword. 

->The first type as the format: <LISTING><H4>KEY  =      value</H4></LISTING>
->The second:<LISTING><H4>KEY indice =      value</H4></LISTIN

So 'action' functions which correspond to keyword of the second type will
call 'extrait_indice' (cf util_param.c) inn order to extract the indice.

3)Note that most of the 'action' functions defined here will use these three
constantes defined in param.h:

->TAILLE_VALU: Size of the string where will be stored the value read from
the file FILE_RAO_ACQ. This string will then be converted into integer.

->TAILLE_VAL: Size of the string (corresponding to the field value) read in
the file FILE_RAO_ACQ. Of course TAILLE_VALU >= TAILLE_VAL is preferable.

->DEBUT_VAL: starting position (in a line of the FILE_RAO_PAR file) from
which the field 'value' can be read. DEBUT_VAL should be high enough to 
cat only 'value' (and not the previous field 'key' and 'indice').  

-Keywords:
          keyword,parameter.
  	
;;#h#<*********************************************************************/



#include <stdio.h>
#include <stdlib.h>

 
#include	<sun.h>
#include 	<acq.h>
#include 	<enrg.h>
#include 	<visu.h>
#include 	<param.h>
#include 	<camera.h>
#include 	<the_errno.h>

extern Erreur the_errno;
extern FILE *fd_spy;
extern Param_info Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];




action_solrot_n(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_enrg->tab_sem).solrot_n=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SOLROT_N;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_sem).solrot_n);



  return(OK);
}

action_solar_r(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  
  (Pt_enrg->tab_sem).solar_r=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SOLAR_R;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action:%f",(Pt_enrg->tab_sem).solar_r);


  return(OK);
	
}

action_solar_p0(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{ char cval[TAILLE_VAL];
 char message[TAILLE_MES];
 double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

 (Pt_enrg->tab_sem).solar_p0=value;

 Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SOLAR_P0;
 Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
 Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
 Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
 Pt_enrg->nb_li_princ++;

 sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_sem).solar_p0);

 return(OK);
	
}
action_solar_b0(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_sem).solar_b0=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SOLAR_B0;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_sem).solar_b0);

  return(OK);
	
}

action_predang(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_sem).predang=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_PREDANG;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_sem).predang);

  return(OK);
	
}


action_echelang(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_sem).echelang=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_ECHELANG;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_sem).echelang);

  return(OK);
	
}


action_tempqwp1(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_sem).tempqwp1=value;
  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TEMPQWP1;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_sem).tempqwp1);

  return(OK);
	
}

action_tempqwp2(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_sem).tempqwp2=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TEMPQWP2;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_sem).tempqwp2);

  return(OK);
	
}

action_tempbmsp(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_sem).tempbmsp=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TEMPBMSP;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_sem).tempbmsp);

  return(OK);
	
}

/*
Retrait pour eliminer le mot PREDRES 27/4/2000
action_predres(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  

  (Pt_enrg->tab_sem).predres=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_PREDRES;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_sem).predres);



  return(OK);
}

*/
