
static char *SccsId="@(#)action_phy1.c	1.23 05/27/98";

/********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:action_phy1.c
-----------------
-Authors:      C Miguel
-Library:
             param.a
-Purpose:
This File contains some functions dealing with the keywords, each keyword
corresponds to an action for the program which reads the parameter file
paracq.phy.
The acquisition parameters must be read and stored in memory. Once a keyword
is found in the file, the program starts the corresponding action which is
named action_<keyword found>. All the following functions are stored in a
Variable the documentation is in the def_mcle.c file.


-Functions:
		action_naxis
	
	 
-Comments:

1)The functions returns:
	->	0 if ok 
	->	-1 if error (syntaxe ou smantique)
	->	+1 when the end keyword is found.
All the lines in the parameters file start with a meaningless letter (usually
"_"), this due to a difficult compatibility between the different languages
found in the data acquisition.


2)The acquisition parameter file paracq.phy contains a keyword by
line. One can distinguish two types of line depending of the corresponding
keyword. 

->The first type as the format: <LISTING><H4>KEY  =      value</H4></LISTING>
->The second:<LISTING><H4>KEY indice =      value</H4></LISTIN

So 'action' functions which correspond to keyword of the second type will
call 'extrait_indice' (cf util_param.c) inn order to extract the indice.

3)Note that most of the 'action' functions defined here will use these three
constantes defined in param.h:

->TAILLE_VALU: Size of the string where will be stored the value read from
the file FILE_RAO_ACQ. This string will then be converted into integer.

->TAILLE_VAL: Size of the string (corresponding to the field value) read in
the file FILE_RAO_ACQ. Of course TAILLE_VALU >= TAILLE_VAL is preferable.

->DEBUT_VAL: starting position (in a line of the FILE_RAO_PAR file) from
which the field 'value' can be read. DEBUT_VAL should be high enough to 
cat only 'value' (and not the previous field 'key' and 'indice').  

-Keywords:
          keyword,parameter.
  	
;;#h#<*********************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <sys/ddi.h>
 
#include	<sun.h>
#include 	<acq.h>
#include 	<enrg.h>
#include 	<visu.h>
#include 	<param.h>
#include 	<camera.h>
#include 	<the_errno.h>

extern Erreur the_errno;
extern FILE *fd_spy;
extern Param_info Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];
extern Param_info Tb_header_dyn [NB_LI_BLOC_FITS+NB_LI_BLOC_FITS*NB_MAX_FEN];
extern char Liste_mcle[NB_MCLE][TAILLE_MCLE];

 


action_naxis(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  if( (value<=NAXIS_MAX)&&(value>0) )
    {
      (Pt_enrg->tab_phy).naxis=value;

      Tb_header_princ[Pt_enrg->nb_li_princ].indice=_NAXIS;
      Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
      Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
      Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
      Pt_enrg->nb_li_princ++;
      
      Tb_header_dyn[Pt_enrg->nb_li_dyn].indice=_NAXIS;
      Tb_header_dyn[Pt_enrg->nb_li_dyn].type=TYPE_LONG;
      Tb_header_dyn[Pt_enrg->nb_li_dyn].fenetre=NOTH;
      Tb_header_dyn[Pt_enrg->nb_li_dyn].value.type_long=value;
      Pt_enrg->nb_li_dyn++;
      Pt_enrg->indstart_dyn++;
  
      return(OK);
    }
  else
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
}

action_ctype1(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).ctype1),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_CTYPE1;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).ctype1);


  return(OK);
	
}


action_ctype2(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).ctype2),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_CTYPE2;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).ctype2);


  return(OK);
	
}
action_ctype3(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).ctype3),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_CTYPE3;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).ctype3);


  return(OK);
	
}



action_obs_type(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).obs_type),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OBS_TYPE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).obs_type);


  return(OK);
	
}

action_physpara(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).physpara),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_PHYSPARA;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).physpara);


  return(OK);
	
}

action_email(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).email),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_EMAIL;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).email);


  return(OK);
	
}

action_author(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;



  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).author),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_AUTHOR;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).author);


  return(OK);
	
}

action_prog_id(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).prog_id),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_PROG_ID;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).prog_id);


  return(OK);
	
}

action_obs_prog(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).obs_prog),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OBS_PROG;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).obs_prog);


  return(OK);
	
}

action_sci_obj(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).sci_obj),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SCI_OBJ;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).sci_obj);


  return(OK);
	
}

action_contact(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).contact),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_CONTACT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).contact);


  return(OK);
	
}

action_institut(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).institut),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_INSTITUT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).institut);


  return(OK);
	
}

action_cmp_name(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).cmp_name),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_CMP_NAME;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).cmp_name);


  return(OK);
	
}
action_cmp_no(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  
  (Pt_enrg->tab_phy).cmp_no=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_CMP_NO;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_phy).cmp_no);


  return(OK);
	
}

action_cmp_type(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).cmp_type),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_CMP_TYPE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).cmp_type);


  return(OK);
	
}

action_waveunit(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_enrg->tab_phy).waveunit=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_WAVEUNIT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_phy).waveunit);


  return(OK);
	
}

action_analys(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).analys),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_ANALYS;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).analys);


  return(OK);
	
}

action_instrume(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).instrume),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_INSTRUME;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).instrume);


  return(OK);
	
}

action_observer(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).observer),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OBSERVER;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).observer);


  return(OK);
	
}

action_rescient(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).rescient),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_RESCIENT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).rescient);


  return(OK);
	
}

action_object(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).object),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OBJECT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).object);


  return(OK);
	
}

action_obj_id(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).obj_id),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OBJ_ID;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).obj_id);


  return(OK);
	
}
action_obs_mode(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).obs_mode),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OBS_MODE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);



  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).obs_mode);

  
  if(OK == test_obs_mode(Pt_enrg->tab_phy.obs_mode))
    {
      return(OK);
    }
  else
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
    
}

action_prog_num(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_enrg->tab_phy).prog_num=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_PROG_NUM;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_phy).prog_num);


  return(OK);
	
}
action_detector(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).detector),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_DETECTOR;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).detector);


  return(OK);
	
}
action_timestep(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).timestep=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TIMESTEP;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).timestep);


  return(OK);
	
}


action_fielview(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).fielview),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_FIELVIEW;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).fielview);


  return(OK);
	
}
action_ixwidth(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).ixwidth=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_IXWIDTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).ixwidth);


  return(OK);
	
}

int action_iywidth(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).iywidth=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_IYWIDTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).iywidth);


  return(OK);
	
}
action_actifmir(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval;
  char message[TAILLE_MES];

  cval=ligne[POS_CHAR];
  

  (Pt_enrg->tab_phy).actifmir=cval;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_ACTIFMIR;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %c",  (Pt_enrg->tab_phy).actifmir);


  return(OK);
	
}
action_beamex(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval;
  char message[TAILLE_MES];

  cval=ligne[POS_CHAR];
  

  (Pt_enrg->tab_phy).beamex=cval;

  if( (cval == 'Y')||(cval == 'N'))
    {
      
      Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BEAMEX;
      Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
      Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
      Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;
      Pt_enrg->nb_li_princ++;
    }
  else
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  sprintf(message,"ENRG: valeur action: %c",  (Pt_enrg->tab_phy).beamex);


  return(OK);
	
}
action_comment(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_COMMENT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);
  return(OK);
	
}
action_xscale(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).xscale=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_XSCALE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).xscale);


  return(OK);
	
}
action_yscale(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).yscale=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_YSCALE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).yscale);


  return(OK);
	
}

action_count(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_enrg->tab_phy).count=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_COUNT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_phy).count);


  return(OK);
	
}


action_angle(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).angle=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_ANGLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).angle);


  return(OK);
	
}
action_nomask(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).offname),&ligne[DEBUT_VAL],taille_ligne);


  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_NOMASK;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
          &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).offname);


  return(OK);
	
}
action_offname(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).offname),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OFFNAME;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).offname);


  return(OK);
	
}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:action_offsets
------------------

-Purpose:
       

-Prototype:
int action_offsets(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam);
-Parameters:
char	*ligne:
Tb_enrg	*Pt_enrg:
Tb_visu	*Pt_visu:
Tb_acq	*Pt_acq:
Tb_ctrl_cam *Pt_cam:
-Example:
<LISTING><H4>
_OFFSETS =       "fichiers"
</H4></LISTING>
;;#f#<*********************************************************************/

int action_offsets(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval;
  char message[TAILLE_MES];

  cval=ligne[POS_CHAR];
  

  (Pt_enrg->tab_phy).offsets=cval;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_OFFSETS;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %c",  (Pt_enrg->tab_phy).offsets);



  return(OK);
	
}

action_fileacq(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).fileacq),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_FILEACQ;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).fileacq);


  return(OK);
	
}

action_nbreg(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_acq->index).nbreg=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_NBREG;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %i",  (Pt_acq->index).nbreg);


  return(OK);
	
}
action_lngstart(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).lngstart=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_LNGSTART;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).lngstart);


  return(OK);
	
}

action_latstart(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).latstart=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_LATSTART;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).latstart);


  return(OK);
	
}
action_syscoord(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).syscoord),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SYSCOORD;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).syscoord);


  return(OK);
	
}

action_stepx(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_acq->index).stepx=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_STEP_X;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_acq->index).stepx);


  return(OK);
	
}
action_stepy(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_acq->index).stepy=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_STEP_Y;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_acq->index).stepy);


  return(OK);
	
}
action_nbstepx(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_acq->index).nbstepx=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_NBSTEP_X;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_acq->index).nbstepx);


  return(OK);
	
}
action_nbstepy(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_acq->index).nbstepy=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_NBSTEP_Y;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_acq->index).nbstepy);


  return(OK);
	
}

action_latirc(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).latirc=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_LATIRC;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).latirc);


  return(OK);
	
}

action_longtrc(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).longtrc=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_LONGTRC;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).longtrc);


  return(OK);
	
}
action_tcycle(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_enrg->tab_phy).tcycle=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TCYCLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_phy).tcycle);


  return(OK);
	
}

action_tregion(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_enrg->tab_phy).tregion=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TREGION;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_phy).tregion);


  return(OK);
	
}

action_grpred(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).grpred),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_GRPRED;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).grpred);


  return(OK);
	
}

action_spats(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int 	ind=extrait_indice(ligne);
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).spatscal=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SPATSCAL;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=ind;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).spatscal);


  return(OK);
	
}

action_specs(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int 	ind=extrait_indice(ligne);
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).specscal=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SPECSCAL;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=ind;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).specscal);


  return(OK);
	
}
action_scalfac(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_enrg->tab_phy).scalfac=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SCALFAC;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_phy).scalfac);


  return(OK);
	
}
action_filterch(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).filterch),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_FILTERCH;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).filterch);


  return(OK);
	
}
action_filterfe(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).filterfe),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_FILTERFE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).filterfe);


  return(OK);
	
}
action_filtersp(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).filtersp),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_FILTERSP;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).filtersp);


  return(OK);
	
}
action_seq_stok(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).sequence),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SEQ_STOK;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).sequence);


  return(OK);
	
}
action_slit(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_phy).slit),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SLIT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_phy).slit);


  return(OK);
	
}


action_nblambd(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_acq->index).nblambd=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_NBLAMBD;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_acq->index).nblambd);


  return(OK);
	
} 



action_nbstep(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
    
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  (Pt_acq->index).nbstep=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_NBSTEP;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %i",  (Pt_acq->index).nbstep);


  return(OK);
	
}










