static char *SccsId="@(#)action_fix.c	1.23 05/27/98";

/********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:action_phy1.c
-----------------
-Authors:      C Miguel
-Library:
             param.a
-Purpose:
This File contains some functions dealing with the keywords, each keyword
corresponds to an action for the program which reads the parameter file
paracq.phy.
The acquisition parameters must be read and stored in memory. Once a keyword
is found in the file, the program starts the corresponding action which is
named action_<keyword found>. All the following functions are stored in a
Variable the documentation is in the def_mcle.c file.


-Functions:
	action_simple
	action_bitpix
	action_extend
	action_telescop
	action_origin
	action_bscale
	action_bzero
	action_blank
	action_bunit
	action_paracar
	action_dimpix
	action_grechel
	action_xtension
	
	 
-Comments:

1)The functions returns:
	->	0 if ok 
	->	-1 if error (syntaxe ou smantique)
	->	+1 when the end keyword is found.
All the lines in the parameters file start with a meaningless letter (usually
"_"), this due to a difficult compatibility between the different languages
found in the data acquisition.


2)The acquisition parameter file paracq.phy contains a keyword by
line. One can distinguish two types of line depending of the corresponding
keyword. 

->The first type as the format: <LISTING><H4>KEY  =      value</H4></LISTING>
->The second:<LISTING><H4>KEY indice =      value</H4></LISTIN

So 'action' functions which correspond to keyword of the second type will
call 'extrait_indice' (cf util_param.c) inn order to extract the indice.

3)Note that most of the 'action' functions defined here will use these three
constantes defined in param.h:

->TAILLE_VALU: Size of the string where will be stored the value read from
the file FILE_RAO_ACQ. This string will then be converted into integer.

->TAILLE_VAL: Size of the string (corresponding to the field value) read in
the file FILE_RAO_ACQ. Of course TAILLE_VALU >= TAILLE_VAL is preferable.

->DEBUT_VAL: starting position (in a line of the FILE_RAO_PAR file) from
which the field 'value' can be read. DEBUT_VAL should be high enough to 
cat only 'value' (and not the previous field 'key' and 'indice').  

-Keywords:
          keyword,parameter.
  	
;;#h#<*********************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <sys/ddi.h>

 
#include	<sun.h>
#include 	<acq.h>
#include 	<enrg.h>
#include 	<visu.h>
#include 	<camera.h>
#include 	<the_errno.h>

extern Erreur the_errno;
extern FILE *fd_spy;
extern Ind_mcle ind_mcle;
extern Param_info Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];
extern Param_info Tb_header_dyn [NB_LI_BLOC_FITS+NB_LI_BLOC_FITS*NB_MAX_FEN];

action_simple(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval;
  char message[TAILLE_MES];

  cval=ligne[POS_CHAR];

  if( (cval == 'T')||(cval == 'F'))
    {

      (Pt_enrg->tab_fix).simple=cval;

      Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SIMPLE;
      Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
      Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
      Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;
      Pt_enrg->nb_li_princ++;
      return(OK);
    }
  else
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
}


action_bitpix(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  (Pt_enrg->tab_fix).bitpix=value;

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BITPIX;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].indice=_BITPIX;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].type=TYPE_LONG;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].fenetre=NOTH;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].value.type_long=value;
  Pt_enrg->nb_li_dyn++;
  Pt_enrg->indstart_dyn++;
 

  return(OK);	
}


action_extend(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{ char cval;
 char message[TAILLE_MES];
 cval=ligne[POS_CHAR];

 (Pt_enrg->tab_fix).extend=cval;

 Tb_header_princ[Pt_enrg->nb_li_princ].indice=_EXTEND;
 Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
 Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
 Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;

 Pt_enrg->nb_li_princ++;
 sprintf(message,"ENRG: valeur action: %c",  (Pt_enrg->tab_fix).extend);


 return(OK);
}

action_telescop(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);


  strncpy(((Pt_enrg->tab_fix).telescop),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TELESCOP;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).telescop);


  return(OK);
}


action_origin(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;

  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  taille_ligne=min(taille_ligne,TAILLE_VAL);
  strncpy(((Pt_enrg->tab_fix).origin),&ligne[DEBUT_VAL],taille_ligne);
  

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_ORIGIN;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).origin);


  return(OK);
	
}


action_bscale(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  (Pt_enrg->tab_fix).bscale=value;
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      message_spy(fd_spy,"\n<------------> Dans action bscale is float retourne une erreur ");
      message_spy(fd_spy,"\n<------------> sur la ligne :::");
      message_spy(fd_spy,ligne);
      message_spy(fd_spy,":::");
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BSCALE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_fix).bscale);


  return(OK);
	
}


action_bzero(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  (Pt_enrg->tab_fix).bzero=value;
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BZERO;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_fix).bzero);

  return(OK);	
}

action_blank(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  (Pt_enrg->tab_fix).blank=value;
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BLANK;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_fix).blank);
  return(OK);	
}

action_bunit(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);

  taille_ligne=min(taille_ligne,TAILLE_VAL);
  strncpy(((Pt_enrg->tab_fix).bunit),&ligne[DEBUT_VAL],TAILLE_VAL);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BUNIT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).bunit);


  return(OK);
	
}

action_dimpix(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);

  strncpy(((Pt_enrg->tab_fix).dimpix),&ligne[DEBUT_VAL],TAILLE_VAL);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_DIMPIX;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).dimpix);


  return(OK);
	
}
action_grechel(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);

  strncpy(((Pt_enrg->tab_fix).grechel),&ligne[DEBUT_VAL],TAILLE_VAL);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_GRECHEL;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).grechel);


  return(OK);
	
}
action_xtension(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);


  taille_ligne=min(taille_ligne,TAILLE_VAL);

  strncpy(((Pt_enrg->tab_fix).xtension),&ligne[DEBUT_VAL],TAILLE_VAL);

  Tb_header_dyn[Pt_enrg->nb_li_dyn].indice=_XTENSION;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].type=TYPE_CHFITS;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].fenetre=NOTH;
  strncpy(Tb_header_dyn[Pt_enrg->nb_li_dyn].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_dyn++;
  Pt_enrg->indstart_dyn++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).xtension);


  return(OK);
	
}

action_pcount(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  Tb_header_dyn[Pt_enrg->nb_li_dyn].indice=_PCOUNT;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].type=TYPE_LONG;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].fenetre=NOTH;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].value.type_long=value;
  Pt_enrg->nb_li_dyn++;
  Pt_enrg->indstart_dyn++;
 
  return(OK);	
}

action_gcount(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];

  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
  Tb_header_dyn[Pt_enrg->nb_li_dyn].indice=_GCOUNT;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].type=TYPE_LONG;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].fenetre=NOTH;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].value.type_long=value;
  Pt_enrg->nb_li_dyn++;
  Pt_enrg->indstart_dyn++;
 
  return(OK);	
}

