h54659
s 00000/00033/00504
d D 1.11 99/08/31 16:06:47 chris 12 11
c ok
e
s 00004/00000/00533
d D 1.10 99/06/30 10:18:17 chris 11 10
c avant dev formatage 3
e
s 00042/00029/00491
d D 1.9 99/04/13 18:58:59 chris 10 9
c deniere modif avant obs de mai 99 - ctrl des params -
e
s 00021/00021/00499
d D 1.8 99/02/05 15:11:16 chris 9 8
c suppression des lignes avec message_spy
e
s 00045/00001/00475
d D 1.7 98/09/18 15:48:44 tof 8 7
c creation de action_xtension(). Mise a jour de action_bitpix() pour ecrire aussi dans le tableau dynamique..
e
s 00010/00010/00466
d D 1.6 98/08/07 16:38:39 chris 7 6
c chgt float -> double
e
s 00001/00000/00475
d D 1.5 98/08/05 15:03:04 chris 6 5
c ajout des mots cle COUNT, ANGLE et PREDRES, les deux premiers
e
s 00000/00000/00475
d D 1.4 98/07/24 19:07:00 chris 5 4
c ajout des fonctions pour paracq.sem, non tests mais compile
e
s 00225/00014/00250
d D 1.3 98/07/22 15:21:16 chris 4 3
c Version de test avec creation des informations du formatage\    
e
s 00037/00006/00227
d D 1.2 98/07/19 17:40:19 chris 3 1
c premiere version pas de controle de coherence
e
s 00000/00000/00000
d R 1.2 98/07/19 16:49:08 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/param/action_fix.c
e
s 00233/00000/00000
d D 1.1 98/07/19 16:49:07 chris 1 0
c date and time created 98/07/19 16:49:07 by chris
e
u
U
f e 0
t
T
I 1
D 7
static char *SccsId="@(#)action_sim.c	1.23 05/27/98";
E 7
I 7
static char *SccsId="@(#)action_fix.c	1.23 05/27/98";
E 7

/********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:action_phy1.c
-----------------
-Authors:      C Miguel
-Library:
             param.a
-Purpose:
This File contains some functions dealing with the keywords, each keyword
corresponds to an action for the program which reads the parameter file
paracq.phy.
The acquisition parameters must be read and stored in memory. Once a keyword
is found in the file, the program starts the corresponding action which is
named action_<keyword found>. All the following functions are stored in a
Variable the documentation is in the def_mcle.c file.


-Functions:
	action_simple
	action_bitpix
	action_extend
	action_telescop
	action_origin
	action_bscale
	action_bzero
	action_blank
	action_bunit
	action_paracar
	action_dimpix
	action_grechel
I 8
	action_xtension
E 8
	
	 
-Comments:

1)The functions returns:
	->	0 if ok 
	->	-1 if error (syntaxe ou smantique)
	->	+1 when the end keyword is found.
All the lines in the parameters file start with a meaningless letter (usually
"_"), this due to a difficult compatibility between the different languages
found in the data acquisition.


2)The acquisition parameter file paracq.phy contains a keyword by
line. One can distinguish two types of line depending of the corresponding
keyword. 

->The first type as the format: <LISTING><H4>KEY  =      value</H4></LISTING>
->The second:<LISTING><H4>KEY indice =      value</H4></LISTIN

So 'action' functions which correspond to keyword of the second type will
call 'extrait_indice' (cf util_param.c) inn order to extract the indice.

3)Note that most of the 'action' functions defined here will use these three
constantes defined in param.h:

->TAILLE_VALU: Size of the string where will be stored the value read from
the file FILE_RAO_ACQ. This string will then be converted into integer.

->TAILLE_VAL: Size of the string (corresponding to the field value) read in
the file FILE_RAO_ACQ. Of course TAILLE_VALU >= TAILLE_VAL is preferable.

->DEBUT_VAL: starting position (in a line of the FILE_RAO_PAR file) from
which the field 'value' can be read. DEBUT_VAL should be high enough to 
cat only 'value' (and not the previous field 'key' and 'indice').  

-Keywords:
          keyword,parameter.
  	
;;#h#<*********************************************************************/



#include <stdio.h>
I 6
#include <stdlib.h>
E 6
I 4
#include <sys/ddi.h>
E 4

 
#include	<sun.h>
#include 	<acq.h>
#include 	<enrg.h>
#include 	<visu.h>
D 3
#include 	<param.h>
E 3
#include 	<camera.h>
#include 	<the_errno.h>

extern Erreur the_errno;
I 4
extern FILE *fd_spy;
extern Ind_mcle ind_mcle;
extern Param_info Tb_header_princ[NB_MCLE+NB_MCLE_DEPEND_FEN*NB_MAX_FEN];
I 8
extern Param_info Tb_header_dyn [NB_LI_BLOC_FITS+NB_LI_BLOC_FITS*NB_MAX_FEN];
E 8
E 4

D 8

E 8
D 4

E 4
action_simple(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval;
D 4
  cval=ligne[TAILLE_LIGNE-1];
E 4
I 4
  char message[TAILLE_MES];
E 4

I 4
  cval=ligne[POS_CHAR];
D 10
  
E 10

E 4
D 10
  (Pt_enrg->tab_fix).simple=cval;
E 10
I 10
  if( (cval == 'T')||(cval == 'F'))
    {
E 10

I 4
D 10
  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SIMPLE;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;
  Pt_enrg->nb_li_princ++;
E 10
I 10
      (Pt_enrg->tab_fix).simple=cval;
E 10

D 10
  sprintf(message,"ENRG: valeur action: %c",  (Pt_enrg->tab_fix).simple);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 4
E 3
  return(OK);
E 10
I 10
      Tb_header_princ[Pt_enrg->nb_li_princ].indice=_SIMPLE;
      Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
      Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
      Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;
      Pt_enrg->nb_li_princ++;
      return(OK);
    }
  else
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
E 10
D 3
	
E 3
}


action_bitpix(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
D 4
  long value=atoi(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VAL));
E 4
I 4
  char message[TAILLE_MES];

D 7
  long value=atoi(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
I 7
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
E 4
  
I 10
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
  
E 10
  (Pt_enrg->tab_fix).bitpix=value;
E 3
D 4
  return(OK);
	
E 4
I 4

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BITPIX;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;
I 8
  Tb_header_dyn[Pt_enrg->nb_li_dyn].indice=_BITPIX;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].type=TYPE_LONG;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].fenetre=NOTH;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].value.type_long=value;
  Pt_enrg->nb_li_dyn++;
  Pt_enrg->indstart_dyn++;
D 10
  
E 8
  sprintf(message,"ENRG: valeur action: %i",  (Pt_enrg->tab_fix).bitpix);
E 10
I 10
 
E 10
D 9
  message_spy(fd_spy,message);
E 9

D 10

I 9

E 10
E 9
  return(OK);	
E 4
}


action_extend(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

D 3
{
E 3
I 3
{ char cval;
D 4
  cval=ligne[TAILLE_LIGNE-1];
E 4
I 4
 char message[TAILLE_MES];
 cval=ligne[POS_CHAR];
E 4

D 4
  (Pt_enrg->tab_fix).extend=cval;
E 4
I 4
 (Pt_enrg->tab_fix).extend=cval;
E 4

E 3
D 4
  return(OK);
E 4
I 4
 Tb_header_princ[Pt_enrg->nb_li_princ].indice=_EXTEND;
 Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHAR;
 Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
 Tb_header_princ[Pt_enrg->nb_li_princ].value.type_char=cval;

 Pt_enrg->nb_li_princ++;
 sprintf(message,"ENRG: valeur action: %c",  (Pt_enrg->tab_fix).extend);
D 9
 message_spy(fd_spy,message);
E 9

I 9

E 9
 return(OK);
E 4
D 3
	
E 3
}
I 3

E 3
action_telescop(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

D 3
{
E 3
I 3
D 4
{ 
E 4
I 4
{
E 4
  char cval[TAILLE_VAL];
D 4
  strncpy(((Pt_enrg->tab_fix).telescop),&ligne[DEBUT_VAL],TAILLE_VAL);
E 4
I 4
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
  taille_ligne=min(taille_ligne,TAILLE_VAL);
  sprintf(message,"min taille : %i",taille_ligne);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
  strncpy(((Pt_enrg->tab_fix).telescop),&ligne[DEBUT_VAL],taille_ligne);

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_TELESCOP;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"debut val: %c",ligne[DEBUT_VAL]);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).telescop);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 4
E 3
  return(OK);
D 3
	
E 3
}


action_origin(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
D 4
  strncpy(((Pt_enrg->tab_fix).origin),&ligne[DEBUT_VAL],TAILLE_VAL);
E 4
I 4
  char message[TAILLE_MES];
  int taille_ligne;

  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  taille_ligne=min(taille_ligne,TAILLE_VAL);
  strncpy(((Pt_enrg->tab_fix).origin),&ligne[DEBUT_VAL],taille_ligne);
  

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_ORIGIN;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;


  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).origin);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 4
E 3
  return(OK);
	
}


action_bscale(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
D 4
  float value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VAL));
E 4
I 4
  char message[TAILLE_MES];

D 7
  float value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
I 7
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
E 4
  (Pt_enrg->tab_fix).bscale=value;
I 10
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
I 11
      message_spy(fd_spy,"\n<------------> Dans action bscale is float retourne une erreur ");
      message_spy(fd_spy,"\n<------------> sur la ligne :::");
      message_spy(fd_spy,ligne);
      message_spy(fd_spy,":::");
E 11
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
E 10
I 4

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BSCALE;
D 7
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_FLOAT;
E 7
I 7
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
E 7
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
D 7
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_float=value;
E 7
I 7
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
E 7
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_fix).bscale);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 4
E 3
  return(OK);
	
}


action_bzero(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
D 4
  float value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VAL));
E 4
I 4
  char message[TAILLE_MES];

D 7
  float value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
I 7
  double value=atof(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
E 4
  (Pt_enrg->tab_fix).bzero=value;
I 10
  
  if(ERROR==is_float(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
E 10
I 4

D 10

E 10
  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BZERO;
D 7
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_FLOAT;
E 7
I 7
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_DOUBLE;
E 7
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
D 7
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_float=value;
E 7
I 7
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_double=value;
E 7
  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_fix).bzero);
D 9
  message_spy(fd_spy,message);
E 9

D 10

I 9

E 9
E 4
E 3
  return(OK);
	
E 10
I 10
  return(OK);	
E 10
}

action_blank(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
D 4
  float value=atoi(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VAL));
E 4
I 4
  char message[TAILLE_MES];

D 7
  float value=atoi(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
I 7
  long value=atol(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU));
E 7
E 4
  (Pt_enrg->tab_fix).blank=value;
I 10
  
  if(ERROR==is_number(strncpy(cval,&ligne[DEBUT_VAL],TAILLE_VALU)))
    {
      the_errno.code=E_DECODE_SEM;
      return(ERROR);
    }
E 10
I 4

D 10

E 10
  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BLANK;
D 7
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_FLOAT;
E 7
I 7
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_LONG;
E 7
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  Tb_header_princ[Pt_enrg->nb_li_princ].value.type_long=value;
  Pt_enrg->nb_li_princ++;

D 10

E 10
  sprintf(message,"ENRG: valeur action: %f",  (Pt_enrg->tab_fix).blank);
D 9
  message_spy(fd_spy,message);
E 9
D 10


I 9

E 9
E 4
E 3
  return(OK);
	
E 10
I 10
  return(OK);	
E 10
}
I 4

E 4
action_bunit(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
I 4
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);
D 9
  message_spy(fd_spy,message);
E 9

I 9
D 10

E 10
E 9
  taille_ligne=min(taille_ligne,TAILLE_VAL);
D 10

E 10
E 4
  strncpy(((Pt_enrg->tab_fix).bunit),&ligne[DEBUT_VAL],TAILLE_VAL);
I 4

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_BUNIT;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).bunit);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 4
E 3
  return(OK);
	
}
D 12
action_paracar(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;
E 12

D 12
{
I 3
  char cval[TAILLE_VAL];
I 4
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
  taille_ligne=min(taille_ligne,TAILLE_VAL);

E 4
  strncpy(((Pt_enrg->tab_fix).paracar),&ligne[DEBUT_VAL],TAILLE_VAL);
I 4

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_PARACAR;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;
  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).paracar);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 4
E 3
  return(OK);
	
}
E 12
action_dimpix(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
I 4
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
  taille_ligne=min(taille_ligne,TAILLE_VAL);

E 4
  strncpy(((Pt_enrg->tab_fix).dimpix),&ligne[DEBUT_VAL],TAILLE_VAL);
I 4

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_DIMPIX;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).dimpix);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 4
E 3
  return(OK);
	
}
action_grechel(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
I 3
  char cval[TAILLE_VAL];
I 4
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
  taille_ligne=min(taille_ligne,TAILLE_VAL);

E 4
  strncpy(((Pt_enrg->tab_fix).grechel),&ligne[DEBUT_VAL],TAILLE_VAL);
I 4

  Tb_header_princ[Pt_enrg->nb_li_princ].indice=_GRECHEL;
  Tb_header_princ[Pt_enrg->nb_li_princ].type=TYPE_CHFITS;
  Tb_header_princ[Pt_enrg->nb_li_princ].fenetre=NOTH;
  strncpy(Tb_header_princ[Pt_enrg->nb_li_princ].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_princ++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).grechel);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
I 8
  return(OK);
	
}
action_xtension(ligne,Pt_enrg,Pt_visu,Pt_acq,Pt_cam)
char	*ligne;
Tb_enrg	*Pt_enrg;
Tb_visu	*Pt_visu;
Tb_acq	*Pt_acq;
Tb_ctrl_cam *Pt_cam;

{
  char cval[TAILLE_VAL];
  char message[TAILLE_MES];
  int taille_ligne;


  taille_ligne=strlen(ligne)-TAILLE_MCLE-TAILLE_SEPA;
  sprintf(message,"taille : %i",taille_ligne);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
  taille_ligne=min(taille_ligne,TAILLE_VAL);

  strncpy(((Pt_enrg->tab_fix).xtension),&ligne[DEBUT_VAL],TAILLE_VAL);

  Tb_header_dyn[Pt_enrg->nb_li_dyn].indice=_XTENSION;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].type=TYPE_CHFITS;
  Tb_header_dyn[Pt_enrg->nb_li_dyn].fenetre=NOTH;
  strncpy(Tb_header_dyn[Pt_enrg->nb_li_dyn].value.type_chfits,\
	  &ligne[DEBUT_VAL],taille_ligne);

  Pt_enrg->nb_li_dyn++;
  Pt_enrg->indstart_dyn++;

  sprintf(message,"ENRG: valeur action: %s",  (Pt_enrg->tab_fix).xtension);
D 9
  message_spy(fd_spy,message);
E 9

I 9

E 9
E 8
E 4
E 3
  return(OK);
	
}
E 1
