
static char *SccsId="@(#)util_obscu.c	1.4 03/11/98";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:util_obscu.c
-----------------
-Auteur(s):Monique Savinelli
-Rle:
	Le fichier regroupe les fonctions utiles pour la mesure des
	courants d'obscurit et les manipulations de tableau de donnes. 

-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		add_fenetre
		init_fenetre
		affiche_fenetre
		div_fenetre
		min_max
	 
-Commentaires:
	Lorsque l'on fait des courants d'obscurit sur les camras (ie
	des acquisitions avec l'obturateur ferm) on ajoute les rsultats qui
	sont des fentres de taille maximale, dans une variable dont les
 	valeurs vont grandir jusqu' ce que l'on arrte les acquisitions. 
	On fait alors une moyenne en divisant le rsultat par le nombre de fois
	que l'on a ajout une fentre.

********************************************************************;-*/


#include 	<stdio.h>
#include 	<sys/types.h>

#include	<th_form.h>


/*++********************************************************************
------------------
ENTETE DE FONCTION	:add_fenetre
------------------

-Rle:
	Cette fonction ajoute une fentre  une autre de mme taille
-inclure:
-Prototype:
	void add_fenetre(nblig,nbcol,fen1,fen2)
-Paramtres:
	int nblig; nombre de lignes des fentres
	int nbcol; nombre de colonnes des fentres
	u_long *fen1;
	Datum *fen2;
		pointeurs sur les fentres.
		fen2 est pass par valeur
		fen1 est pass par valeur rsultat.
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
	Ajoute pixel par pixel les fentres et met le rsultat dans fen1.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

void add_fenetre(nblig,nbcol,fen1,fen2)
int nblig;
int nbcol;
u_long *fen1;
Datum  *fen2;
{
int i;
long nbval = nblig * nbcol;


	for(i = 0;i < nbval;i++)
		fen1[i] += fen2[i];

}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:init_fenetre
------------------

-Rle:
	Initialiser une fentre !
-inclure:
-Prototype:
	u_long *init_fenetre(nblig,nbcol)
-Paramtres:
	int nblig,nbcol;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour: Le pointeur sur la fentre.
-Description:
	effectue un malloc pour allouer le pointeur sur la fentre et met des 0
	partout dans la zone alloue.

-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

u_long *init_fenetre(nblig,nbcol)
int nblig,nbcol;
{
long nbval = nblig*nbcol;
u_long *fen;
int i; 

	fen = (u_long*)malloc(sizeof(u_long)*nbval);

	for(i = 0; i < nbval; i++)
		fen[i] = 0;
	return(fen);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:affiche_fenetre
------------------

-Rle:
	Affichage d'une fentre pour tester le dveloppement des programmes.
-inclure:
-Prototype:
	void affiche_fenetre(fen,nblig,nbcol)
-Paramtres:
	u_long	*fen;
	int	nblig,nbcol;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	rien du tout.
-Description:
	on fait des "print", soit de toute la fentre, soit d'une petite partie,
	car les fentres relles ne peuvent pas tre affiches (elles sont trop
	grosses). Cependant, on peut tout afficher, si on travaille sur des 
	petites fentres pour tester le programme.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

void affiche_fenetre(fen,nblig,nbcol)
u_long	*fen;
int	 nblig,nbcol;
{
int icol = 10;			/*nbre de colonnes d'impression*/
int ival, i = 0;
long nbval = nblig*nbcol;

	for(ival = 0;ival < nbval; ival++)
	{ 
		if((i % icol) == 0) printf("\n");
		printf("%ld", fen[ival]);
		i++;
	}
 
}




/*++********************************************************************
------------------
ENTETE DE FONCTION	:div_fenetre
------------------

-Rle:
	Effectue une moyenne sur la fentre.
-inclure:
-Prototype:
	void div_fenetre(nblig,nbcol,nbfen,fen)
-Paramtres:
	int nblig,nbcol; dimension de la fentre.
	int nbfen:	Ce par quoi il faut diviser
	u_long	*fen;
		la fentre pass par rsultat et par valeur.
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
	On divise chaque pixel par nbfen.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Cette fonction sert  effectuer la moyenne. Lorsque l'on a ajout
	toutes les fentres et stock le rsultat, on divise par le nombre
	de fentres que l'on a ajout.
********************************************************************--*/

void div_fenetre(nblig,nbcol,nbfen,fen)
int 	nblig,nbcol;
int 	nbfen;
u_long *fen;
{
long nbval = nblig * nbcol;
int i;
	for (i = 0; i < nbval; i++)
		fen[i] = fen[i] / nbfen;
}
/*******************************************************************/



/*++********************************************************************
------------------
ENTETE DE FONCTION	:min_max
------------------

-Rle:
	trouve le minimum et le maximum dans un tableau
-inclure:
-Prototype:
	void min_max(Pt_tab,taille,min,max)
-Paramtres:
	Datum *Pt_tab (th_form.h) pointeur sur le tableau
	long taille    taille du tableau
	Datum min      min du tableau, passage par rsultat.
	Datum max	max du tableau, passage par rsultat. 
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	Cette fonction doit servir au programme de visualisation temps 
	rel avec idl. Le calcul du min et max dans une fentre doit viter
	 idl de recalculer  chaque fois ces deux valeurs.
********************************************************************--*/

void min_max(fen2,taille,min,max)
Datum *fen2;
long taille;
Datum *min;
Datum *max;
{
long i;
	*min = fen2[0];
	*max = fen2[0];

	for(i = 0; i < taille; i++)
	{
		if(*min > fen2[i]) 
			*min = fen2[i];
		else
		if(*max < fen2[i])
			*max = fen2[i];
	}
}

