
static char *SccsId="@(#)shared-mem.c	1.7 03/26/99";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:shared-mem.c
-----------------
-Auteur(s):	Christian Miguel

-Rle:	Le fichier regroupe des fonctions utiles au partage de la mmoire commune.
 	 	
-Fonctions:
	Internes au fichier:
		is_locked_zone
		lock_zone
		total_data
		indice_fenetre
-Commentaires:
	Fichier en cours de dveloppement.
	(Il y aura srement plus de fontions dans le mme thme dans la version finale)

********************************************************************;-*/





#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <errno.h>

#include	<sun.h>
#include 	<acq.h>
#include 	<the_errno.h>


extern Erreur the_errno;
extern FILE *fd_spy;
 




/*++********************************************************************
------------------
ENTETE DE FONCTION	:is_locked_zone
------------------

-Rle:
Regarde si une zone de donnes est occupe ou libre pour une lecture ou une ecriture.
-inclure:
	acq.h pour avoir les constantes des verrous  passer en paramtres.

-Prototype:
	int is_locked_zone (Tb_ctrl *Pt_ctrl,int zone)
-Paramtres:
	Pt_ctrl		Le pointeur sur la table de contrle du partage mmoire.
	zone		Le numro de la zone de donnes 0 ou 1.
 
-Retour:
	Elle retourne la valeur du verrou sur cette zone.
 	
-Exemple:
-Commentaires:
********************************************************************--*/



int is_locked_zone (Pt_ctrl,zone)
Tb_ctrl *Pt_ctrl;
int zone;
{
	 
	if((Pt_ctrl->nb_empl<=zone)||(zone<0))
	{
	 	the_errno.code=EINVAL;
		return(ERROR);
	}
	else
		return(Pt_ctrl->verrou[zone]);
}



 
/*++********************************************************************
------------------
ENTETE DE FONCTION	:lock_zone
------------------

-Rle:
	verrouille une zone de donnes
-inclure:
	acq.h
-Prototype:
	int lock_zone (Tb_ctrl *Pt_ctrl,int zone,lock)
-Paramtres:
	Pt_ctrl		pointeur sur la table de contrle du partage mmoire
	zone		le numero de la zone de donnes (0 ou 1)
	lock 		La valeur du verrou  mettre.
 
-Retour:
	OK ou ERROR si il y a eu un problme.
 
-Exemple:
-Commentaires:
Le programme appelant devrait avoir besoin de la dfinition des constantes qui sont dans acq.h et qui reprsentent les valeurs des verrous.
Par exemple: SUN_BUSY, SUN_NOT_BUSY, VME_BUSY...
********************************************************************--*/


int lock_zone (Pt_ctrl,zone,lock)
Tb_ctrl *Pt_ctrl;
int zone;
int lock;
{

	if((Pt_ctrl->nb_empl<=zone)||(zone<0))
	{
		the_errno.code=EINVAL;
		return(ERROR);
	}
	else
	{
		Pt_ctrl->verrou[zone]=lock;
		return(OK);
	}
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:total_data
------------------

-Rle:	Calcule le nombre de donnes en short  lire dans la zone rserve
	de mmoire commune (total de toutes les fentres)
 
-Prototype:
	long total_data(Tb_acq *Pt_acq)
	
-Paramtres:
	Pt_acq 		pointeur sur la table d'acquisition.
 
-Retour:
	Le total de ces donnees ou ERROR si il y a eu un problme.
 
-Constantes utilises
	Importes:
		NB_MAX_FEN		(th_form.h)

-Exemple:
-Commentaires:
********************************************************************--*/

long total_data(Pt_acq)
Tb_acq *Pt_acq;
{
long total = 0;
long fen_obs = 0;
 	
	do
	{
		if((((Pt_acq->tab_fen[fen_obs]).nblig) != 0) &&
			(((Pt_acq->tab_fen[fen_obs]).nbcol) != 0))
		{
			
		  total += Pt_acq->enfen+((Pt_acq->tab_fen[fen_obs]).nblig)
			*((Pt_acq->tab_fen[fen_obs]).nbcol);
		  fen_obs ++;

		}
	}while((fen_obs) < Pt_acq->nbfen);

	return(total);
	
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:indice_fenetre
------------------

-Rle:  
calcule l'adresse de debut des fenetres
-inclure:
-Prototype:
	int indice_fenetre(Tb_acq *Pt_acq)

-Paramtres:
	*Pt_acq		est le pointeur sur la table d'acquisition.
 
-Retour:
	OK ou  ERROR
 	
-Exemple:
-Commentaires:
	
********************************************************************--*/

int  indice_fenetre(Pt_acq)

Tb_acq *Pt_acq;
{
  int i=0;
  long indice=sizeof(Ent_acq);
  lldiv_t division;
  int nblig=(Pt_acq->tab_fen)[i].nblig;
  int nbcol=(Pt_acq->tab_fen)[i].nbcol;



  while(i<NB_MAX_FEN )
    {	
      if((nblig!=0) &&(nbcol!=0))
	{
	  division=lldiv(indice,ADR_DMA);
	  if ( division.rem==0)
	    {
	      (Pt_acq->tab_info_fen)[i].mem_offset=indice;
	      indice+=nblig*nbcol*sizeof(short);
	    }
	  else
	    {
	      (Pt_acq->tab_info_fen)[i].mem_offset=(division.quot+1)*(ADR_DMA);
	      indice+=nblig*nbcol*sizeof(short)+ADR_DMA-division.rem;
	    }
	}

      i++;
    }
  return(OK);
}



