// Client socket sous forme d'application graphique

// import java.applet.Applet; 
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.security.AccessControlException;

public class Client2 implements ActionListener {
  private static String chaineInfo = "Client v2.0 (C) Jrme Minec, 10-04-2000.\n";

  private Socket s;
  private Ecoute ecoute;

  public int port = 2222;
  public static String serveur_def = "persee";

  // public static final String separateur = "\n\r";

  private Frame frame = new Frame("Client 2");

  private Button boutonConnexion = new Button("Connexion");
  private Button boutonDeconnexion = new Button("Dconnexion");
  private Button boutonSepCmd = new Button("Ajouter \\n\\r");
  private Button boutonEffaceEnvoi = new Button("Effacer");
  private Button boutonEnvoi = new Button("Envoi");
  private Button boutonEffaceRecep = new Button("Effacer");
  private TextField textServeur = new TextField(serveur_def, 12);
  private TextField textPort = new TextField(Integer.toString(port), 4);
  private TextField textStatus = new TextField(50);
  private TextArea textEnvoi = new TextArea(2, 30);
  private TextArea textRecep = new TextArea(3, 30);

  BufferedReader fromServer;
  PrintWriter toServer;

  public void init() {
    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) { destroy(); }
    });
    
    // cree et positionne le gestionnaire de repartition BorderLayout
    frame.setLayout(new FlowLayout(FlowLayout.CENTER));

    // panel connexion
    Panel pConnexion = new Panel();

    pConnexion.add(new Label("serveur"));
    pConnexion.add(textServeur);
    pConnexion.add(new Label("port"));
    pConnexion.add(textPort);   
    pConnexion.add(boutonConnexion);
    boutonConnexion.addActionListener(this);
    pConnexion.add(boutonDeconnexion);
    boutonDeconnexion.addActionListener(this);

    frame.add(pConnexion);

    // panel emission
    Panel pEmission = new Panel();

//     pEmission.add(new Label("message  envoyer"));
    pEmission.add(textEnvoi);
    pEmission.add(boutonSepCmd);
    boutonSepCmd.addActionListener(this);
    pEmission.add(boutonEffaceEnvoi);
    boutonEffaceEnvoi.addActionListener(this);
    pEmission.add(boutonEnvoi);
    boutonEnvoi.addActionListener(this);
    boutonEnvoi.setEnabled(false);

    frame.add(pEmission);

    // panel reception
    Panel pReception = new Panel();

    pReception.add(new Label("message recu"));
    textRecep.setEditable(false);
    pReception.add(textRecep);
    pReception.add(boutonEffaceRecep);
    boutonEffaceRecep.addActionListener(this);

    frame.add(pReception);
    
    frame.add(textStatus);
    textStatus.setEditable(false);

    frame.pack();
    frame.setVisible(true);
    frame.setSize(450, 240);
  }
  
  public void start() {
      showStatus("Non connect.");  
  }

  public void actionPerformed(ActionEvent event) { 
    Button button = (Button)event.getSource(); 
    
    if(button == boutonConnexion)  
      boutonConnexionActive(event);
    else if(button == boutonEnvoi)
      boutonEnvoiActive(event);
    else if(button == boutonDeconnexion)  
      boutonDeconnexionActive(event);
    else if(button == boutonEffaceEnvoi)
      boutonEffaceEnvoiActive(event);
    else if(button == boutonEffaceRecep)
      boutonEffaceRecepActive(event);
    else if(button == boutonSepCmd)
      boutonSepCmdActive(event);
  } 

  public void boutonSepCmdActive(ActionEvent event) { 
    textEnvoi.append("\n\r");
  }

  public void boutonDeconnexionActive(ActionEvent event) { 
    try { 
      if (s != null) {
	s.close(); 
	ecoute._stop();
      }
    }
    catch (IOException e) { showStatus(e.getMessage()); }

    boutonEnvoi.setEnabled(false);
    showStatus("Non connect.");
  }

  public void boutonConnexionActive(ActionEvent event) { 
    try { port = Integer.parseInt(textPort.getText()); }
    catch (NumberFormatException e) { showStatus(e.getMessage()); }

    try {
       // Cre un socket
       s = new Socket(textServeur.getText(), port);
       InputStream sin = s.getInputStream();
       fromServer = new BufferedReader(new InputStreamReader(sin));
       OutputStream sout = s.getOutputStream();
       toServer = new PrintWriter(new OutputStreamWriter(sout));
       showStatus("Connect  " + s.getInetAddress() + ":" + s.getPort());
       boutonEnvoi.setEnabled(true);
    } 
    catch (IOException e) { showStatus(e.getMessage()); }
    catch (AccessControlException e) { showStatus(e.getMessage()); }

    ecoute = new Ecoute(fromServer, textRecep);
    try { ecoute.start(); ecoute._run(); }
    catch (Exception e) { showStatus(e.getMessage()); }
  }

  public void boutonEnvoiActive(ActionEvent event) {
    // envoie la ligne au serveur
    toServer.print(textEnvoi.getText());
    toServer.flush();    
  }

  public void boutonEffaceEnvoiActive(ActionEvent event) {
    textEnvoi.setText("");
  }  

  public void boutonEffaceRecepActive(ActionEvent event) {
    textRecep.setText("");
  }  

  public void showStatus(String s) {
    textStatus.setText(s);
  }

  public void destroy() {
    try { if (s != null) s.close(); }
    catch (IOException e) { showStatus(e.getMessage()); }
    System.exit(0);
  }

  public String getAppletInfo() {
    return chaineInfo;
  }

  public static void main(String[] args) {
    Client2 c2 = new Client2();
    c2.init();
  }
}

