public class ObjUndo {
  private static final int MAX_UNDO = 8;
  
  private int nbNiveaux;

  private boolean modif;

  private Undoable reference[] = new Undoable[MAX_UNDO];

  private Object valeur[] = new Object[MAX_UNDO];

  public ObjUndo() {
    nbNiveaux = 0;
  }
  /*
   private void backup(Undoable undoable) {
     reference = undoable;
     valeur = undoable.getValue();
   }

   private void restore() {
     reference.setValue(valeur);
   }

   private ObjUndo copie() {
     ObjUndo objUndo2 = new ObjUndo(reference, valeur);
     return objUndo2; 
   }
*/
  public String getValeur(int i) {
    return (String)valeur[i];
  }

  public String getName(int i) {
    return reference[i].getName();
  }

  public void changement() {
    modif = true;
  }

  public void newObj(Undoable objet) {
    for (int i = MAX_UNDO-1; i > 0; i--) {
      reference[i] = reference[i-1];
      valeur[i] = valeur[i-1];
    }
    if (nbNiveaux < MAX_UNDO-1)
      nbNiveaux++;
    reference[0] = objet;
    valeur[0] = objet.getValue();
    modif = false;
  }

  public void lastObj() {
    if ( !modif ) {
      for (int i = 1; i < MAX_UNDO; i++) {
	reference[i-1] = reference[i];
	valeur[i-1] = valeur[i];
      }    
      if (nbNiveaux > 0)
	nbNiveaux--;
    }
  }

  public void undo() {
    if (nbNiveaux > 0) {
      reference[0].setValue(valeur[0]);
      modif = false;
      lastObj();
    }
  }

  public int getNbNiveaux() {
    return nbNiveaux;
  }
}
