// Client socket sous forme d'applet graphique avec undo

import java.applet.Applet; 
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.security.AccessControlException;

public class Client5 extends Applet implements ActionListener, TextListener, FocusListener {
  private static String chaineInfo = "Client v5.0 (C) Jrme Minec, 31-03-2000.\n";

  // Pour la fonction undo
  private ObjUndo objUndo = new ObjUndo();

  // Communication
  private Socket s;
  private Ecoute ecoute;
  // public static final String separateur = "\n\r";
  public static int port = 2222;
  public static String serveur_def = "persee";
  BufferedReader fromServer;
  PrintWriter toServer;

  // Interface graphique
  private Button boutonUndo = new Button("Undo");
  private Button boutonConnexion = new Button("Connexion");
  private Button boutonDeconnexion = new Button("Dconnexion");
  private Button boutonEnvoi = new Button("Envoi");
  private Button boutonEfface = new Button("Effacer");
  private TextField textUndo = new TextField(20);
  private TextFieldUndo textServeur = new TextFieldUndo(serveur_def, 12);
  private TextFieldUndo textPort = new TextFieldUndo(Integer.toString(port), 4);
  private TextAreaUndo textEnvoi = new TextAreaUndo(2, 30);
  private TextArea textRecep = new TextArea(3, 30);

  public void init() {
    this.setLayout(new FlowLayout(FlowLayout.CENTER));

    // panel undo
    Panel pUndo = new Panel();
    
    pUndo.add(new Label("dernire modification"));
    pUndo.add(textUndo);
    textUndo.setEditable(false);
    pUndo.add(boutonUndo);
    boutonUndo.addActionListener(this);

    this.add(pUndo);

    // panel connexion
    Panel pConnexion = new Panel();

    pConnexion.add(new Label("serveur"));
    pConnexion.add(textServeur);
    textServeur.addFocusListener(this);
    textServeur.addTextListener(this);
    textServeur.setName("serveur");

    pConnexion.add(new Label("port"));
    pConnexion.add(textPort);   
    textPort.addFocusListener(this);
    textPort.addTextListener(this);
    textPort.setName("port");

    pConnexion.add(boutonConnexion);
    boutonConnexion.addActionListener(this);

    pConnexion.add(boutonDeconnexion);
    boutonDeconnexion.addActionListener(this);

    this.add(pConnexion);

    // panel emission
    Panel pEmission = new Panel();

    pEmission.add(new Label("message  envoyer"));
    pEmission.add(textEnvoi);
    textEnvoi.addFocusListener(this);
    textEnvoi.addTextListener(this);
    textEnvoi.setName("message");

    pEmission.add(boutonEnvoi);
    boutonEnvoi.addActionListener(this);
    boutonEnvoi.setEnabled(false);

    this.add(pEmission);

    // panel reception
    Panel pReception = new Panel();

    pReception.add(new Label("message recu"));
    textRecep.setEditable(false);
    pReception.add(textRecep);
    pReception.add(boutonEfface);
    boutonEfface.addActionListener(this);

    this.add(pReception);
  }
  
  public void start() {
    showStatus("Non connect.");  
  }

  public void majTextUndo() {
    if (objUndo.getNbNiveaux() > 0)
      textUndo.setText(objUndo.getName(0) + ":" + objUndo.getValeur(0));
    else textUndo.setText(" : ");

  }

  // TextEnvent
  public void textValueChanged(TextEvent event) {
    objUndo.changement();
    majTextUndo();
  }
 
  // FocusEvent
  public void focusGained(FocusEvent event) {
    objUndo.newObj((Undoable)event.getSource());
  }
 
  public void focusLost(FocusEvent event) {
    objUndo.lastObj();
  }
 
  // ActionEvent
  public void actionPerformed(ActionEvent event) { 
    if (event.getSource() instanceof Button) {
      Button button = (Button)event.getSource();
      
      if(button == boutonUndo)  
	boutonUndoActive(event);
      else if(button == boutonConnexion)  
	boutonConnexionActive(event);
      else if(button == boutonEnvoi)
	boutonEnvoiActive(event);
      else if(button == boutonDeconnexion)  
	boutonDeconnexionActive(event);
      else if(button == boutonEfface)
	boutonEffaceActive(event);
    }
     else  {
       System.out.println("actionPerformed sur " + event.getSource() + " : " + event.getActionCommand());
      }
  } 

  public void boutonUndoActive(ActionEvent event) {
    objUndo.undo();
    majTextUndo();
  }

  public void boutonDeconnexionActive(ActionEvent event) { 
    try { 
      if (s != null) {
	s.close(); 
	ecoute._stop();
      }
    }
    catch (IOException e) { showStatus(e.getMessage()); }

    showStatus("Non connect.");
    boutonEnvoi.setEnabled(false);
  }

  public void boutonConnexionActive(ActionEvent event) { 
    try { port = Integer.parseInt(textPort.getText()); }
    catch (NumberFormatException e) { showStatus(e.getMessage()); }

    try {
       s = new Socket(textServeur.getText(), port);
       InputStream sin = s.getInputStream();
       fromServer = new BufferedReader(new InputStreamReader(sin));
       OutputStream sout = s.getOutputStream();
       toServer = new PrintWriter(new OutputStreamWriter(sout));
       showStatus("Connect  " + s.getInetAddress() + ":" + s.getPort());
       boutonEnvoi.setEnabled(true);
   } 
    catch (IOException e) { showStatus(e.getMessage()); }
    catch (AccessControlException e) { showStatus(e.getMessage()); }

    ecoute = new Ecoute(fromServer, textRecep, this);
    try { ecoute.start(); }
    catch (RuntimeException e) { showStatus(e.getMessage()); }
  }

  public void boutonEnvoiActive(ActionEvent event) {
    toServer.print(textEnvoi.getText());
    toServer.flush();    
  }

  public void boutonEffaceActive(ActionEvent event) {
    textRecep.setText("");
  }  

  // methodes diverses
  public void destroy() {
    try { if (s != null) s.close(); }
    catch (IOException e) { showStatus(e.getMessage()); }
  }

  public String getAppletInfo() {
    return chaineInfo;
  }
}

