// Client socket sous forme d'applet graphique avec internationalisation

import java.applet.Applet; 
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import Ecoute;

public class Client4 extends Applet implements ActionListener {
  private static String chaineInfo = "Client v4.0 (C) Jrme Minec, 22-03-2000.\n";

  private Socket s;
  private Ecoute ecoute;

  public static int port = 2222;
  public static String serveur_def = "persee";

  // public static final String separateur = "\n\r";

  private Choice choice = new Choice();

  private Label labelServeur = new Label();
  private Label labelPort = new Label();
  private Label labelEnvoyer = new Label();
  private Label labelRecep = new Label();
  private Button boutonLangue = new Button("Changer");
  private Button boutonConnexion = new Button("Connexion");
  private Button boutonDeconnexion = new Button("Dconnexion");
  private Button boutonEnvoi = new Button("Envoi");
  private Button boutonEfface = new Button("Effacer");
  private TextField textServeur = new TextField(serveur_def, 12);
  private TextField textPort = new TextField(Integer.toString(port), 4);
  private TextArea textEnvoi = new TextArea(2, 30);
  private TextArea textRecep = new TextArea(3, 30);

  BufferedReader fromServer;
  PrintWriter toServer;

  public void init() {

    // cree et positionne le gestionnaire de repartition BorderLayout
    this.setLayout(new FlowLayout(FlowLayout.CENTER));

    // choix de la langue
    Panel pLangue = new Panel();

    choice.add(Locale.FRENCH.getDisplayName());
    choice.add(Locale.ENGLISH.getDisplayName());
    pLangue.add(choice);
    pLangue.add(boutonLangue);
    boutonLangue.addActionListener(this);

    this.add(pLangue);

    // panel connexion
    Panel pConnexion = new Panel();

    pConnexion.add(labelServeur);
    pConnexion.add(textServeur);
    pConnexion.add(labelPort);
    pConnexion.add(textPort);   
    pConnexion.add(boutonConnexion);
    boutonConnexion.addActionListener(this);
    pConnexion.add(boutonDeconnexion);
    boutonDeconnexion.addActionListener(this);

    this.add(pConnexion);

    // panel emission
    Panel pEmission = new Panel();

    pEmission.add(labelEnvoyer);
    pEmission.add(textEnvoi);
    pEmission.add(boutonEnvoi);
    boutonEnvoi.addActionListener(this);

    this.add(pEmission);

    // panel reception
    Panel pReception = new Panel();

    pReception.add(labelRecep);
    textRecep.setEditable(false);
    pReception.add(textRecep);
    pReception.add(boutonEfface);
    boutonEfface.addActionListener(this);

    this.add(pReception);

    labelServeur.setLocale(Locale.FRENCH);
    labelPort.setLocale(Locale.FRENCH);
    labelEnvoyer.setLocale(Locale.FRENCH);
    labelRecep.setLocale(Locale.FRENCH);
    
    internationalize(labelServeur);
    internationalize(labelPort);
    internationalize(labelEnvoyer);
    internationalize(labelRecep);

  }
  
  public void start() {
      showStatus("Non connect.");  
  }

  public void actionPerformed(ActionEvent event) { 
    Button button = (Button)event.getSource(); 
    
    if(button == boutonConnexion)  
      boutonConnexionActive(event);
    else if(button == boutonLangue)  
      boutonLangueActive(event);
    else if(button == boutonEnvoi)
      boutonEnvoiActive(event);
    else if(button == boutonDeconnexion)  
      boutonDeconnexionActive(event);
    else if(button == boutonEfface)
      boutonEffaceActive(event);
  } 

  public void boutonLangueActive(ActionEvent event) {
    int index = choice.getSelectedIndex();
    if (index == 0) { 
      labelServeur.setLocale(Locale.FRENCH);
      labelPort.setLocale(Locale.FRENCH);
      labelEnvoyer.setLocale(Locale.FRENCH);
      labelRecep.setLocale(Locale.FRENCH);
    }
    else if (index == 1) {
      labelServeur.setLocale(Locale.ENGLISH);
      labelPort.setLocale(Locale.ENGLISH);
      labelEnvoyer.setLocale(Locale.ENGLISH);
      labelRecep.setLocale(Locale.ENGLISH);
    }
    internationalize(labelServeur);
    internationalize(labelPort);
    internationalize(labelEnvoyer);
    internationalize(labelRecep);
    validate();
  }  

  private void internationalize(Label label) {
    String s = getIdentifierString(label.getLocale());
    if(s != null) {
      label.setText(s);
      label.invalidate();
    }
  }

  private String getIdentifierString(Locale l) {
    ResourceBundle bundle = null;
    try{
      bundle = ResourceBundle.getBundle("LabelsBundle", l);
    }
    catch(MissingResourceException e) {
      e.printStackTrace();
    }
    if (bundle == null)
      return null;
    else
      return (String)bundle.getObject("Identifier");
  }

  public void boutonDeconnexionActive(ActionEvent event) { 
    try { 
      if (s != null) {
	s.close(); 
	ecoute._stop();
      }
    }
    catch (IOException e) { showStatus(e.getMessage()); }

    showStatus("Non connect.");
  }

  public void boutonConnexionActive(ActionEvent event) { 
    try { port = Integer.parseInt(textPort.getText()); }
    catch (NumberFormatException e) { showStatus(e.getMessage()); }

    try {
       // Cre un socket
       s = new Socket(textServeur.getText(), port);
       InputStream sin = s.getInputStream();
       fromServer = new BufferedReader(new InputStreamReader(sin));
       OutputStream sout = s.getOutputStream();
       toServer = new PrintWriter(new OutputStreamWriter(sout));
       showStatus("Connect  " + s.getInetAddress() + ":" + s.getPort());
    } 
    catch (IOException e) { showStatus(e.getMessage()); }

    ecoute = new Ecoute(fromServer, textRecep, this);
    ecoute.start();
  }

  public void boutonEnvoiActive(ActionEvent event) {
    // envoie la ligne au serveur
    toServer.print(textEnvoi.getText());
    toServer.flush();    
  }

  public void boutonEffaceActive(ActionEvent event) {
    textRecep.setText("");
  }  

  public void destroy() {
    try { if (s != null) s.close(); }
    catch (IOException e) { showStatus(e.getMessage()); }
  }

  public String getAppletInfo() {
    return chaineInfo;
  }

}
