// Client socket sous forme d'applet graphique avec internationalisation

import java.applet.Applet; 
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.security.AccessControlException;

public class Client4 extends Applet implements ActionListener {
  private static String chaineInfo = "Client v4.0 (C) Jrme Minec, 24-03-2000.\n";

  // communication
  private Socket s;
  private Ecoute ecoute;
  // public static final String separateur = "\n\r";
  public static int port = 2222;
  public static String serveur_def = "persee";
  BufferedReader fromServer;
  PrintWriter toServer;

  // i18n
  Locale[] supportedLocales = {
    Locale.FRENCH,
    Locale.ENGLISH,
    Locale.GERMAN,
    Locale.ITALIAN
  };
  Locale theLocale = new Locale(supportedLocales[0].getLanguage(), supportedLocales[0].getCountry());

  // composants graphiques
  private Choice choice = new Choice();
  private Label labelLangue = new Label();
  private Label labelServeur = new Label();
  private Label labelPort = new Label();
  private Label labelEnvoi = new Label();
  private Label labelRecep = new Label();
  private Button boutonLangue = new Button();
  private Button boutonConnexion = new Button();
  private Button boutonDeconnexion = new Button();
  private Button boutonEnvoi = new Button();
  private Button boutonEfface = new Button();
  private TextField textServeur = new TextField(serveur_def, 12);
  private TextField textPort = new TextField(Integer.toString(port), 4);
  private TextArea textEnvoi = new TextArea(2, 30);
  private TextArea textRecep = new TextArea(3, 30);
  private Panel pLangue = new Panel();
  private Panel pConnexion = new Panel();
  private Panel pEmission = new Panel();
  private Panel pReception = new Panel();

  public void init() {
    int i;

    // cree et positionne le gestionnaire de repartition BorderLayout
    this.setLayout(new FlowLayout(FlowLayout.CENTER));

    // choix de la langue
    pLangue.add(labelLangue);
    for(i = 0; i < supportedLocales.length; i++) 
      choice.add(supportedLocales[i].getDisplayName());

    pLangue.add(choice);
    pLangue.add(boutonLangue);
    boutonLangue.addActionListener(this);

    this.add(pLangue);

    // panel connexion
    pConnexion.add(labelServeur);
    pConnexion.add(textServeur);
    pConnexion.add(labelPort);
    pConnexion.add(textPort);   
    pConnexion.add(boutonConnexion);
    boutonConnexion.addActionListener(this);
    pConnexion.add(boutonDeconnexion);
    boutonDeconnexion.addActionListener(this);

    this.add(pConnexion);

    // panel emission
    pEmission.add(labelEnvoi);
    pEmission.add(textEnvoi);
    pEmission.add(boutonEnvoi);
    boutonEnvoi.addActionListener(this);

    this.add(pEmission);

    // panel reception
    pReception.add(labelRecep);
    pReception.add(textRecep);
    textRecep.setEditable(false);
    pReception.add(boutonEfface);
    boutonEfface.addActionListener(this);

    this.add(pReception);

    internationalize();
  }
  
  public void start() {
    showStatus("Non connect.");
  }

  public void actionPerformed(ActionEvent event) { 
    Button button = (Button)event.getSource(); 
    
    if(button == boutonConnexion)  
      boutonConnexionActive(event);
    else if(button == boutonLangue)  
      boutonLangueActive(event);
    else if(button == boutonEnvoi)
      boutonEnvoiActive(event);
    else if(button == boutonDeconnexion)  
      boutonDeconnexionActive(event);
    else if(button == boutonEfface)
      boutonEffaceActive(event);
  } 

  public void internationalize() {
    pLangue.setLocale(theLocale);
    pConnexion.setLocale(theLocale);
    pEmission.setLocale(theLocale);
    pReception.setLocale(theLocale);

    int_Label(labelLangue, "labelLangue");
    int_Label(labelServeur, "labelServeur");
    int_Label(labelPort, "labelPort");
    int_Label(labelEnvoi, "labelEnvoi");
    int_Label(labelRecep, "labelRecep");
    int_Button(boutonLangue, "boutonLangue");
    int_Button(boutonConnexion, "boutonConnexion");
    int_Button(boutonDeconnexion, "boutonDeconnexion");
    int_Button(boutonEnvoi, "boutonEnvoi");
    int_Button(boutonEfface, "boutonEfface");

    validate();
  }

  public void boutonLangueActive(ActionEvent event) {
    int index = choice.getSelectedIndex();

    theLocale = supportedLocales[index];

    internationalize();
  }  

  private void int_Label(Label label, String identifier) {
    String s = getIdentifierString(label.getLocale(), identifier);
    if(s != null) {
      label.setText(s);
      label.invalidate();
    }
  }

  private void int_Button(Button button, String identifier) {
    String s = getIdentifierString(button.getLocale(), identifier);
    if(s != null) {
      button.setLabel(s);
      button.invalidate();
    }
  }

  private String getIdentifierString(Locale l, String identifier) {
    ResourceBundle bundle = null;

    try{
      bundle = ResourceBundle.getBundle("LabelsBundle", l);
    }
    catch(MissingResourceException e) {
      e.printStackTrace();
    }

    if (bundle == null)
      return null;
    else
      return (String)bundle.getObject(identifier);
  }

  public void boutonDeconnexionActive(ActionEvent event) { 
    try { 
      if (s != null) {
	s.close(); 
	ecoute._stop();
      }
    }
    catch (IOException e) { showStatus(e.getMessage()); }

    showStatus("Non connect.");
  }

  public void boutonConnexionActive(ActionEvent event) { 
    try { port = Integer.parseInt(textPort.getText()); }
    catch (NumberFormatException e) { showStatus(e.getMessage()); }

    try {
      // Cre un socket
      s = new Socket(textServeur.getText(), port);
      InputStream sin = s.getInputStream();
      fromServer = new BufferedReader(new InputStreamReader(sin));
      OutputStream sout = s.getOutputStream();
      toServer = new PrintWriter(new OutputStreamWriter(sout));
      showStatus("Connect  " + s.getInetAddress() + ":" + s.getPort());
    } 
    catch (IOException e) { showStatus(e.getMessage()); }
    catch (AccessControlException e) { showStatus(e.getMessage()); }

    ecoute = new Ecoute(fromServer, textRecep, this);
    try { ecoute.start(); }
    catch (RuntimeException e) { showStatus(e.getMessage()); }
  }

  public void boutonEnvoiActive(ActionEvent event) {
    // envoie la ligne au serveur
    toServer.print(textEnvoi.getText());
    toServer.flush();    
  }

  public void boutonEffaceActive(ActionEvent event) {
    textRecep.setText("");
  }  

  public void destroy() {
    try { if (s != null) s.close(); }
    catch (IOException e) { showStatus(e.getMessage()); }
  }

  public String getAppletInfo() {
    return chaineInfo;
  }

}
