import java.awt.*;
import java.awt.event.*;

public class LanceurClient extends Frame {
  private MenuBar barreMenu;
  private MenuItem resetItem, quitterItem, aideItem;
  private MenuItemListener menuItemListener = new MenuItemListener();

  private static Client3 client3;

  public static void main(String args[]) {
    client3 = new Client3();
    LanceurClient app = new LanceurClient("Client3");
    app.setSize(480, 260);
    app.show();
  }

  public LanceurClient(String titre) {
    // titre
    super(titre);

    // barre de menu
    barreMenu = new MenuBar();

    Menu fichierMenu = new Menu("Divers", true);
    fichierMenu.add(resetItem = new MenuItem("Reset"));
    fichierMenu.addSeparator();
    fichierMenu.add(aideItem = new MenuItem("Aide"));
    fichierMenu.addSeparator();
    fichierMenu.add(quitterItem = new MenuItem("Quitter"));

    barreMenu.add(fichierMenu);
    this.setMenuBar(barreMenu);

    resetItem.addActionListener(menuItemListener);
    aideItem.addActionListener(menuItemListener);
    quitterItem.addActionListener(menuItemListener);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent event) {
	dispose();
	System.exit(0);
      }
    });

    // applet Client3
    this.add("Center", client3);
    client3.init();
    client3.start();

  }

  public void lanceAide() {
    final Dialog aideDialog = new Dialog(this, "Commandes disponibles");

    TextArea aideTexte = new TextArea(client3.chaineCommandes, 40, 40);
    aideTexte.setEditable(false);
    aideDialog.add(aideTexte);

    aideDialog.pack();
    aideDialog.show();

    aideDialog.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent event) {
	aideDialog.dispose();
      }
    });
  }

  class MenuItemListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      MenuItem item = (MenuItem)event.getSource();

      if (item == resetItem) {
 	client3.reset();
      }
      else if (item == aideItem) {
	lanceAide();
      }
      else if (item == quitterItem) {
 	dispose();
 	System.exit(0);
      }
    }
  }

}
