// Client socket sous forme d'applet graphique

import java.applet.Applet; 
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.security.AccessControlException;

public class Client3 extends Applet implements ActionListener {
  public static String chaineInfo = "Client v3.0 (C) Jrme Minec, 04-05-2000.\n";
  public static String chaineCommandes = 
  "\n	pour tous :\n" +
  "$INFO : test de connexion\n" +
  "$ECOM : fin de connexion\n" +
  "\n	pour le VME :\n" +
  "$TINC : tout_init_cam()\n" +
  "$IACQ : init_acquisition()\n" + 
  "$AMEM : alloc_mem(&taille_data)\n" +
  "$ATBP : adresse_tb_point()\n" + 
  "$LMEM : libere_mem()\n" +
  "$EACQ : exit_acquisition()\n" +
  "$IINI : intf_init()\n" +
  "$IWRT(a,b) : intf_wr_timer(timer_num,val)\n" +
  "$TLEC : time_lect(&temps)\n" +
  "$LOBT(a) : lect_obt(num,@flag)\n" +
  "$COBT(a,b) : cmde_obt(num,flag)\n" +
  "$AOBT(a,b) : affect_obt(num_cam,num_obt)\n" +
  "$ATHE(a,b) : affect_theta(num_cam,theta)\n" +
  "$LSTC(a) : lect_stat_cam(num_cam,@etat)\n" +
  "$TACQ(a) : start_acq(bool)\n" +
  "$PACQ : stop_acq()\n" +
  "$SLEC : start_lect()\n" +
  "$ICAM(a) : init_cam(no)\n" +
  "$IBUF(a,b,c) : init_buf(num_cam,num_plan,valeur)\n" +
  "$WBUF(a,b,c,d,e,f,g) : wr_buf(nom_fichier,lig_deb,col-deb,nb_lig,nb_col,num_cam,num_plan)\n" +
  "$INDE(a,b) : index(seq_ind, ind_reg)\n" +
  "$LAMB(a) : lambda(indlambd)\n" +
  "$STEP : step()\n" +
  "$IANA(a) : ana(stokes)\n" +
  "$PPOU(a,b,c,d,e,f,g,h,i,j,k,l) : ppou(alpha,delta,polarang,svector,longitud,latitud,dist_ew,dist_ns,prefente,posrot,eleva,azimuth,longcarr)\n" +
  "$PLAM(a,b) : plam(posqwp1,posqwp2)\n" +
  "$WACQ : wacq()\n" +
  "$ACQI : acqui()\n" +
  "\n	pour la Sun :\n" +
  "$RAOE : rao_enrg()\n" +
  "$RAOS : rao_stop()\n" +
  "$DECO : decode()\n" +
  "$OBSE : obs_enrg()\n" +
  "$OBSS : obs_stop()\n" +
  "$CPAR : check_param(Pt_acq,Pt_enrg,Pt_cam,Pt_visu)\n" +
  "$ITBA : init_tb_acq(Pt_acq, OK)\n" +
  "$ITBE : init_tb_enrg(Pt_enrg, OK)\n" +
  "$ITBC : init_tb_ctrl_cam(Pt_cam)\n" +
  "$ITBV : init_tb_visu(Pt_visu)\n" +
  "$MCLE(a) : criture sur paracq.don des n lignes de mots-cls suivants + decode()\n" +
  "_XXXXX n=... : excution du mot-cl\n";

  private Socket s;
  private Ecoute ecoute;

  public static int port = 2222;
  public static String serveur_def = "themis";

  // public static final String separateur = "\n\r";

  private Button boutonConnexion = new Button("Connexion");
  private Button boutonDeconnexion = new Button("Dconnexion");
  private Button boutonSepCmd = new Button("Ajouter \\n\\r");
  private Button boutonEffaceEnvoi = new Button("Effacer");
  private Button boutonEnvoi = new Button("Envoi");
  private Button boutonEffaceRecep = new Button("Effacer");
  private TextField textServeur = new TextField(serveur_def, 12);
  private TextField textPort = new TextField(Integer.toString(port), 4);
  private TextArea textEnvoi = new TextArea(2, 30);
  private TextArea textRecep = new TextArea(3, 30);

  BufferedReader fromServer;
  PrintWriter toServer;

  public void init() {

    // cree et positionne le gestionnaire de repartition BorderLayout
    this.setLayout(new FlowLayout(FlowLayout.CENTER));

    // panel connexion
    Panel pConnexion = new Panel();

    pConnexion.add(new Label("serveur"));
    pConnexion.add(textServeur);
    pConnexion.add(new Label("port"));
    pConnexion.add(textPort);   
    pConnexion.add(boutonConnexion);
    boutonConnexion.addActionListener(this);
    pConnexion.add(boutonDeconnexion);
    boutonDeconnexion.addActionListener(this);

    this.add(pConnexion);

    // panel emission
    Panel pEmission = new Panel();

//     pEmission.add(new Label("message  envoyer"));
    pEmission.add(textEnvoi);
    pEmission.add(boutonSepCmd);
    boutonSepCmd.addActionListener(this);
    pEmission.add(boutonEffaceEnvoi);
    boutonEffaceEnvoi.addActionListener(this);
    pEmission.add(boutonEnvoi);
    boutonEnvoi.addActionListener(this);
    boutonEnvoi.setEnabled(false);

    this.add(pEmission);

    // panel reception
    Panel pReception = new Panel();

    pReception.add(new Label("message recu"));
    textRecep.setEditable(false);
    pReception.add(textRecep);
    pReception.add(boutonEffaceRecep);
    boutonEffaceRecep.addActionListener(this);

    this.add(pReception);
  }
  
  public void start() {
      showStatus("Non connect.");  
  }

  public void actionPerformed(ActionEvent event) { 
    Button button = (Button)event.getSource(); 
    
    if(button == boutonConnexion)  
      boutonConnexionActive();
    else if(button == boutonEnvoi)
      boutonEnvoiActive();
    else if(button == boutonDeconnexion)  
//       boutonDeconnexionActive(event);
      deconnexion();
    else if(button == boutonEffaceEnvoi)
      effaceEnvoi();
    else if(button == boutonEffaceRecep)
      effaceRecep();
    else if(button == boutonSepCmd)
      boutonSepCmdActive();
  } 

  public void boutonSepCmdActive() { 
    textEnvoi.insert("\n\r", textEnvoi.getCaretPosition());
  }

  public void deconnexion() { 
//   public void boutonDeconnexionActive(ActionEvent event) { 
    try { 
      if (s != null) {
	s.close(); 
	ecoute._stop();
      }
    }
    catch (IOException e) { showStatus(e.getMessage()); }

    boutonEnvoi.setEnabled(false);
    showStatus("Non connect.");
  }

  public void boutonConnexionActive() { 
    try { port = Integer.parseInt(textPort.getText()); }
    catch (NumberFormatException e) { showStatus(e.getMessage()); }

    try {
       // Cre un socket
       s = new Socket(textServeur.getText(), port);
       InputStream sin = s.getInputStream();
       fromServer = new BufferedReader(new InputStreamReader(sin));
       OutputStream sout = s.getOutputStream();
       toServer = new PrintWriter(new OutputStreamWriter(sout));
       showStatus("Connect  " + s.getInetAddress() + ":" + s.getPort());
       boutonEnvoi.setEnabled(true);
    } 
    catch (IOException e) { showStatus(e.getMessage()); }
    catch (AccessControlException e) { showStatus(e.getMessage()); }

    ecoute = new Ecoute(fromServer, textRecep, this);
    try { ecoute.start(); }
    catch (RuntimeException e) { showStatus(e.getMessage()); }
  }

  public void boutonEnvoiActive() {
    // envoie la ligne au serveur
    toServer.print(textEnvoi.getText());
    toServer.flush();    
  }

  public void effaceEnvoi() {
    textEnvoi.setText("");
  }  

  public void effaceRecep() {
    textRecep.setText("");
  }  

  public void destroy() {
    deconnexion();
  }
  
  public void reset() {
    deconnexion();
    effaceEnvoi();
    effaceRecep();
  }

  public String getAppletInfo() {
    return chaineInfo;
  }
  public void showStatus(String msg) {
    System.out.println(msg);
  }

}

