// Client socket sous forme d'applet graphique

import java.applet.Applet; 
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.security.AccessControlException;

public class Client2 extends Applet implements ActionListener {
  private static String chaineInfo = "Client v2.0 (C) Jrme Minec, 07-04-2000.\n";

  private Socket s;
  private Ecoute ecoute;

  public static int port = 2222;
  public static String serveur_def = "persee";

  // public static final String separateur = "\n\r";

  private Button boutonConnexion = new Button("Connexion");
  private Button boutonDeconnexion = new Button("Dconnexion");
  private Button boutonSepCmd = new Button("Ajouter \\n\\r");
  private Button boutonEffaceEnvoi = new Button("Effacer");
  private Button boutonEnvoi = new Button("Envoi");
  private Button boutonEffaceRecep = new Button("Effacer");
  private TextField textServeur = new TextField(serveur_def, 12);
  private TextField textPort = new TextField(Integer.toString(port), 4);
  private TextArea textEnvoi = new TextArea(2, 30);
  private TextArea textRecep = new TextArea(3, 30);

  BufferedReader fromServer;
  PrintWriter toServer;

  public void init() {

    // cree et positionne le gestionnaire de repartition BorderLayout
    this.setLayout(new FlowLayout(FlowLayout.CENTER));

    // panel connexion
    Panel pConnexion = new Panel();

    pConnexion.add(new Label("serveur"));
    pConnexion.add(textServeur);
    pConnexion.add(new Label("port"));
    pConnexion.add(textPort);   
    pConnexion.add(boutonConnexion);
    boutonConnexion.addActionListener(this);
    pConnexion.add(boutonDeconnexion);
    boutonDeconnexion.addActionListener(this);

    this.add(pConnexion);

    // panel emission
    Panel pEmission = new Panel();

//     pEmission.add(new Label("message  envoyer"));
    pEmission.add(textEnvoi);
    pEmission.add(boutonSepCmd);
    boutonSepCmd.addActionListener(this);
    pEmission.add(boutonEffaceEnvoi);
    boutonEffaceEnvoi.addActionListener(this);
    pEmission.add(boutonEnvoi);
    boutonEnvoi.addActionListener(this);
    boutonEnvoi.setEnabled(false);

    this.add(pEmission);

    // panel reception
    Panel pReception = new Panel();

    pReception.add(new Label("message recu"));
    textRecep.setEditable(false);
    pReception.add(textRecep);
    pReception.add(boutonEffaceRecep);
    boutonEffaceRecep.addActionListener(this);

    this.add(pReception);
  }
  
  public void start() {
      showStatus("Non connect.");  
  }

  public void actionPerformed(ActionEvent event) { 
    Button button = (Button)event.getSource(); 
    
    if(button == boutonConnexion)  
      boutonConnexionActive(event);
    else if(button == boutonEnvoi)
      boutonEnvoiActive(event);
    else if(button == boutonDeconnexion)  
      boutonDeconnexionActive(event);
    else if(button == boutonEffaceEnvoi)
      boutonEffaceEnvoiActive(event);
    else if(button == boutonEffaceRecep)
      boutonEffaceRecepActive(event);
    else if(button == boutonSepCmd)
      boutonSepCmdActive(event);
  } 

  public void boutonSepCmdActive(ActionEvent event) { 
    textEnvoi.append("\n\r");
  }

  public void boutonDeconnexionActive(ActionEvent event) { 
    try { 
      if (s != null) {
	s.close(); 
	ecoute._stop();
      }
    }
    catch (IOException e) { showStatus(e.getMessage()); }

    boutonEnvoi.setEnabled(false);
    showStatus("Non connect.");
  }

  public void boutonConnexionActive(ActionEvent event) { 
    try { port = Integer.parseInt(textPort.getText()); }
    catch (NumberFormatException e) { showStatus(e.getMessage()); }

    try {
       // Cre un socket
       s = new Socket(textServeur.getText(), port);
       InputStream sin = s.getInputStream();
       fromServer = new BufferedReader(new InputStreamReader(sin));
       OutputStream sout = s.getOutputStream();
       toServer = new PrintWriter(new OutputStreamWriter(sout));
       showStatus("Connect  " + s.getInetAddress() + ":" + s.getPort());
       boutonEnvoi.setEnabled(true);
    } 
    catch (IOException e) { showStatus(e.getMessage()); }
    catch (AccessControlException e) { showStatus(e.getMessage()); }

    ecoute = new Ecoute(fromServer, textRecep, this);
    try { ecoute.start(); }
    catch (RuntimeException e) { showStatus(e.getMessage()); }
  }

  public void boutonEnvoiActive(ActionEvent event) {
    // envoie la ligne au serveur
    toServer.print(textEnvoi.getText());
    toServer.flush();    
  }

  public void boutonEffaceEnvoiActive(ActionEvent event) {
    textEnvoi.setText("");
  }  

  public void boutonEffaceRecepActive(ActionEvent event) {
    textRecep.setText("");
  }  

  public void destroy() {
    try { if (s != null) s.close(); }
    catch (IOException e) { showStatus(e.getMessage()); }
  }

  public String getAppletInfo() {
    return chaineInfo;
  }

}

