import java.io.*;
import java.net.*;

public class Client {
  public static final int DEFAULT_PORT = 2222;

  public static final String separateur = "\n\r";

  public static void usage() {
    System.out.println("Usage : java Client <hostname> [<port>]");
    System.exit(0);
  }
  
  public static void main(String[] args) {
    int port = DEFAULT_PORT;
    Socket s = null;
    
    // Analyse la spcification du port
    if ((args.length != 1) && (args.length != 2)) usage();
    if(args.length == 1) port = DEFAULT_PORT;
    else {
      try { port = Integer.parseInt(args[1]); }
      catch (NumberFormatException e) { usage(); }
    }
    try {

      // Cre un socket
      s = new Socket(args[0], port);

      // Cre des flots pour lire et crire des lignes de texte  partir de et vers le socket

      // DataInputStream sin = new DataInputStream(s.getInputStream());
      // The method readLine() in class java.io.DataInputStream has been deprecated.
      InputStream sin = s.getInputStream();
      BufferedReader fromServer = new BufferedReader(new InputStreamReader(sin));
      // idem
      // PrintStream sout = new PrintStream(s.getOutputStream());
      OutputStream sout = s.getOutputStream();
      PrintWriter toServer = new PrintWriter(new OutputStreamWriter(sout));

      // Cre un flot pour lire des lignes de texte  partir de la console
      // DataInputStream in = new DataInputStream(System.in);
      // The method readLine() in class java.io.DataInputStream has been deprecated.
      BufferedReader console = new BufferedReader(new InputStreamReader(System.in));   

      // avertit l'utilisateur de la connexion
      System.out.println("Connect  " + s.getInetAddress() + " : " + s.getPort());
      String line;
      
      // affiche un message d'invite
      System.out.print("> ");
      System.out.flush();
      
      // lit une ligne sur la console
      line = console.readLine();
      //line += separateur;
      
      // envoie la ligne au serveur
      toServer.print(line);
      toServer.flush();
      
      while ((line = fromServer.readLine()) != null) {
	
	// crit la ligne sur la console
	System.out.println(line);
      }
      System.out.println("Connexion ferme par le serveur.");
    }
    
    catch (IOException e) { System.err.println(e); }

    // toujours fermer la connexion (le socket)
    finally {
      try { if (s != null) s.close(); } catch (IOException e2) {}
    }
  }
}
