
static char *SccsId="%W% %G%";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:Sun-serv.c
-----------------
-Auteur(s):
	Christian Miguel
-Role:
	
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		rao_enrg
		rao_stop
		decode
		obs_enrg
		obs_stop
	 
-Commentaires:

********************************************************************;-*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/wait.h>

#include <sun.h>
#include <process.h>
#include <the_time.h>
#include <errno.h>
#include <the_errno.h>

extern Erreur the_errno;
static int	time_out=0;

long	pid_stk[NB_PROC+1]={NOTH,NOTH};

long	*Pt_sem;             /* semaphores */
FILE     *fd_err;


FILE *fd_spy=NULL;


int nb_err_serv;

/*++********************************************************************
------------------
ENTETE DE FONCTION	:rao_enrg
------------------


-Commentaires:
********************************************************************--*/


int rao_enrg()
{

  char         message[TAILLE_MES];
  sigset_t	ens;
  sigemptyset(&ens);
  sigaddset(&ens,SIGINT);
  sigaddset(&ens,SIGSEGV);
  sigaddset(&ens,SIGBUS);
  sigaddset(&ens,SIGUSR1);

  sigprocmask(SIG_BLOCK,&ens,NULL);	

#ifdef _test
  if(fd_spy == NULL)   
    fd_spy=fopen(FILE_SPY,"a");

  if(fd_spy == NULL)
    {
      printf("\n erreur ouverture fichier spy %d",errno);
      printf("\n chemin de merde : %s");
    }

  sprintf(message,"\n Demarage de rao enrg");
  message_spy(fd_spy,message);
#endif    	
      
  if(Pt_sem == NULL )
    {
      if(install_serv()==ERROR)
	{
	  nb_err_serv=1;
	  strcpy(the_errno.time,heure_err());
	  write_histo(&the_errno,&nb_err_serv,fd_err);
	  return(ERROR);
	}
      else
	{
	  strcpy(message,"\nL'install du serveur est ok");
	  message_spy(fd_spy,message);
	}
    }
  if(Pt_sem[ENRG_PID]== NOTH)
    {
      if(pid_stk[CTRL]==NOTH)
	{
	  pid_stk[CTRL]=fork();
      
	  switch(pid_stk[CTRL])
	    {
	    case ERROR:
	      the_errno.code=errno;
	      the_errno.ctxt=PROC_SERV;
	      strcpy(the_errno.time,heure_err());
	      write_histo(&the_errno,&nb_err_serv,fd_err);
	      return(ERROR);
	      break;

	    case OK:
	      message_spy(fd_spy,"\nSERV Lancement du programme");
	      process_ctrl();
	      break;

	    default:
	      if(OK!=demarage())
		{
		  message_spy(fd_spy,"\nSERV retour erreur de demarage");
		  nb_err_serv=1;
		  strcpy(the_errno.time,heure_err());
		  write_histo(&the_errno,&nb_err_serv,fd_err);
		  return(ERROR);
		}
	      message_spy(fd_spy,"\nSERV serveur sorti du demarage");
	      break;
	    }
	}
    }    

  message_spy(fd_spy,"\nSERV: commande RAO ENRG\n");

  if(Pt_sem == NULL )
printf("[global/Sun-serv.c:rao_enrg] Pt_sem==NULL ************\n");
else
printf("[global/Sun-serv.c:rao_enrg] Pt_sem=%ld\n", *Pt_sem);


  return(OK);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:rao_stop
------------------

-Role:

-Commentaires:
********************************************************************--*/


int rao_stop()
{
  int time_out=0;
  int status;
  sigset_t	ens;



  sigemptyset(&ens);
  sigaddset(&ens,SIGINT);
  sigaddset(&ens,SIGSEGV);
  sigaddset(&ens,SIGBUS);
  sigaddset(&ens,SIGUSR1);
  sigprocmask(SIG_BLOCK,&ens,NULL);	

  
  if(Pt_sem != NULL)
    {

      Pt_sem[CTRL_ACTION]=ACTION_DIE;
      message_spy(fd_spy,"\n vient de mettre le sem a action_die");

      while (((Pt_sem[CTRL]!=SYNCHRO)||
	      (Pt_sem[ENRG_ETAT]!=ETAT_DEAD))&&
	     (time_out != TIME_OUT_STOP))
	{
	  micro_sleep(0,TIME_SLEEP_SERV);
	  time_out++;
	}


      message_spy(fd_spy,"\n serveur: apres l'attente de la fin des fils");

      if(time_out == 2*TIME_OUT_STOP)
	{
	  message_spy(fd_spy,"\n ca repond pas: time out");
	  message_spy(fd_spy,"\nNOOONNN... le kill brutal...");
	  kill_brutal();
	  message_spy(fd_spy,"\n apres kill_brutal");

	}
      
      message_spy(fd_spy,"\n serveur: apres verification du time out");

      pid_stk[ENRG]=NOTH;
      Pt_sem[ENRG_PID]=NOTH;
      pid_stk[CTRL]=NOTH;
      Pt_sem[CTRL_ACTION]=ACTION_RIEN;
  
    }



  message_spy(fd_spy,"\n commande RAO STOP\n");

 
  return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:decode
------------------

-Role:
-Commentaires:
must be done in less than 2 sec, if it is not done, it's too late
********************************************************************--*/



int decode()
{
  int time_out=0;
  int retour;
  char         message[TAILLE_MES];

  if(Pt_sem!=NULL)
    {

      if(Pt_sem[ENRG_PID]!=NOTH)
	{
	  message_spy(fd_spy,"\nSERV: vient de mettre le sem du decode");
	  Pt_sem[CTRL_ACTION]=ACTION_DECODE;
	  message_spy(fd_spy,"\nSERV: NOW !!!");
	  
	  while( (Pt_sem[CTRL_ACTION]==ACTION_DECODE) &&
		 (time_out != TIME_OUT_DECODE) )
	    {	
	      micro_sleep(0,TIME_SLEEP_SERV);

	      time_out++;
	    }
	  
	  message_spy(fd_spy,"\nSERV: apres temps du decode");

	  if(time_out == TIME_OUT_DECODE)
	    {
	      message_spy(fd_spy,"\nSERV: time out du decode");
	      the_errno.code=E_TIME_OUT;
	      the_errno.ctxt=PROC_SERV;
	      strcpy(the_errno.time,heure_err());
	      nb_err_serv=1;
	      write_histo(&the_errno,nb_err_serv,fd_err);
	      return(ERROR);
	    }
	  else
	    {
	      message_spy(fd_spy,"\nSERV: Pas de time out");
	      if(Pt_sem[ENRG_COD_ERR]!=OK)
		{
		  retour=Pt_sem[ENRG_COD_ERR];
		  Pt_sem[ENRG_COD_ERR]=0;
		  return(retour);
		}
	    }
	}
      else
	{
	  sprintf(message, "Pt_sem=%ld, Pt_sem[ENRG_PID]=%ld\n", Pt_sem, Pt_sem[ENRG_PID]);
	  message_spy(fd_spy, message);
	  return(ERROR);
	}
    }
  else
    {
      message_spy(fd_spy,"\nSERV: Pt_sem==NULL\n");
      return(ERROR);
    }

  message_spy(fd_spy,"\nSERV commande RAO DECO\n");
  return(OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:decode2
------------------

-Role:
decode 1 seul fichier paracq.don au lieu des 4 fichiers (comme decode())
-Commentaires:
must be done in less than 2 sec, if it is not done, it's too late
********************************************************************--*/

int decode2()
{
  int time_out=0;
  int retour;
  char         message[TAILLE_MES];

  message_spy(fd_spy,"\nSERV:decode2:debut de la fonction");
  printf("\nSERV:decode2:debut de la fonction, fd_spy=%d\n", (int)fd_spy);
  if(Pt_sem!=NULL)
    {
      message_spy(fd_spy,"\nSERV:decode2: Pt_sem!=NULL");
      if(Pt_sem[ENRG_PID]!=NOTH)
	{
	  message_spy(fd_spy,"\nSERV: vient de mettre le sem du decode2");
	  Pt_sem[CTRL_ACTION]=ACTION_DECODE2;
	  message_spy(fd_spy,"\nSERV: NOW !!!");
	  
	  while( (Pt_sem[CTRL_ACTION]==ACTION_DECODE2) &&
		 (time_out != TIME_OUT_DECODE) )
	    {	
	      micro_sleep(0,TIME_SLEEP_SERV);

	      time_out++;
	    }
	  
	  message_spy(fd_spy,"\nSERV: apres temps du decode2");

	  if(time_out == TIME_OUT_DECODE)
	    {
	      message_spy(fd_spy,"\nSERV: time out du decode2");
	      the_errno.code=E_TIME_OUT;
	      the_errno.ctxt=PROC_SERV;
	      strcpy(the_errno.time,heure_err());
	      nb_err_serv=1;
	      write_histo(&the_errno,nb_err_serv,fd_err);
	      return(ERROR);
	    }
	  else
	    {
	      message_spy(fd_spy,"\nSERV: Pas de time out");
	      if(Pt_sem[ENRG_COD_ERR]!=OK)
		{
		  retour=Pt_sem[ENRG_COD_ERR];
		  Pt_sem[ENRG_COD_ERR]=0;
		  return(retour);
		}
	    }
	}
      else
	{
	  sprintf(message, "Pt_sem=%ld, Pt_sem[ENRG_PID]=%ld\n", Pt_sem, Pt_sem[ENRG_PID]);
	  message_spy(fd_spy, message);
	  return(ERROR);
	}
    }
  else
    {
      message_spy(fd_spy,"\nSERV: Pt_sem==NULL\n");
      return(ERROR);
    }

  message_spy(fd_spy,"\nSERV commande RAO DECO2\n");
  return(OK);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:obs_enrg
------------------

-Role:
	nothing's done 

-Commentaires:
********************************************************************--*/


int obs_enrg()
{

  message_spy(fd_spy,"\nSERV commande 4");
  return(10);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:obs_stop
------------------

-Role:

-Commentaires:
nothing's done
********************************************************************--*/


int obs_stop()
{
  
	printf("\n Ne fait rien");
	
}





