

static char *SccsId="@(#)brut2fits.c	1.4 03/11/98";


#include 	<stdio.h>

 
#include	<sun.h>
#include	<acq.h>
#include	<enrg.h>
#include        <errno.h>
#include        <the_errno.h>


#define	PATH_FILE	"/the/pc/acquis.don"
#define	PATH_DIR        "/the/pc/efrun/fits/"
#define NB_FITS		10
#define	TAILLE_LIG	80
#define	SIMPLE		0
#define BITPIX		1
#define NAXIS		2
#define NAXIS1		3
#define NAXIS2		4
#define END		5
#define RIEN 6

#define ENTETE_FITS 80

#define ERR_FENE 1
#define ERR_FIND 2
#define ERR_LECT 3
#define ERR_NUMA 4
#define ERR_OUVE 5
#define ERR_RECU 6
#define ERR_VALF 7
#define ERR_MALO 8
#define ERR_ECRI 10
#define ERR_SEEK 11


typedef struct fenetre
{
  int nblig;
  int nbcol;
  int indice;
  char src_file[50];
  char dst_file[50];
} Fenetre;

extern int errno;

char gram_fits[NB_FITS][TAILLE_LIG] ={
/*234567890123456789012345678901234567890*/
"SIMPLE  =                    T      ",
"BITPIX  =                   16      ",
"NAXIS   =                    2      ",
"NAXIS1  =                           ",
"NAXIS2  =                           ",
"END     =                           "};

Datum   *tab_fen=NULL; 






/*********************************************/


void fin(mess)
{
  switch(mess)
    {
    case ERR_FENE:
      printf("\n mauvais numero de fenetre");
      break;
    case ERR_FIND:
      printf("\n fichier acquis.don introuvable");
      break;
    case ERR_LECT:
      printf("\n Probleme Lecture du fichier");
      break;
    case ERR_NUMA:
      printf("\n mauvais numero d'acquisition");
      break;
    case ERR_OUVE:
      printf("\n Impossible de recuperer l'image");
      break;
    case ERR_RECU:
      printf("\n Impossible d'ouvrir fichier fits");
      break;
    case ERR_VALF:
      printf("\n la taille ligne ou colonne < 100 ");
      break;
    case ERR_SEEK:
      printf("\n PB seek ");
      break;
    case ERR_MALO:
      printf("\n Probleme de malloc");
      break;
    case ERR_ECRI:
      printf("\n probleme d'ecriture");
      break;
    default:
      break;
			
    }



  exit(0);
}


/*********************************************/

void init_gram()
{
int i,j;

  for(i=0;i<NB_FITS;i++)
    {
      for(j=36;j<TAILLE_LIG;j++)
	{
	  gram_fits[i][j]='\0';
	}
    }

  
  for(i=0;i<TAILLE_LIG;i++)
    gram_fits[RIEN][i]=' ';

}


/*********************************************/

int write_gram(fen,fd_fits)
Fenetre *fen;
FILE	*fd_fits;
{
  int i;
  int nbligne_vide=ENTETE_FITS;
  char ligne[4];
  char colone[4];

  init_gram();

/* les 3 lignes oblgatoires */

  for(i=0;i<3;i++)
    {

      fwrite(gram_fits[i],sizeof(char)*TAILLE_LIG,1,fd_fits);
    }
  nbligne_vide=nbligne_vide-3;

/* le nombre de lignes et de colonnes de l'image */

  if(fen->nblig>=100)
    {
	
      sprintf(ligne,"%d",fen->nblig);
      gram_fits[NAXIS2][27]=ligne[0];
      gram_fits[NAXIS2][28]=ligne[1];
      gram_fits[NAXIS2][29]=ligne[2];
    }
  else
    fin(ERR_VALF);
		
  if(fen->nbcol>=100)
    {
	
      sprintf(colone,"%d",fen->nbcol);
      gram_fits[NAXIS1][27]=colone[0];
      gram_fits[NAXIS1][28]=colone[1];
      gram_fits[NAXIS1][29]=colone[2];
    }
  else
    fin(ERR_VALF);

  fwrite(gram_fits[NAXIS1],sizeof(char)*TAILLE_LIG,1,fd_fits);
  fwrite(gram_fits[NAXIS2],sizeof(char)*TAILLE_LIG,1,fd_fits);
  fwrite(gram_fits[END],sizeof(char)*TAILLE_LIG,1,fd_fits);


  for(i=0;i<nbligne_vide;i++)
    {
      fwrite(gram_fits[RIEN],sizeof(char)*TAILLE_LIG,1,fd_fits);
    }

  nbligne_vide=nbligne_vide-3;
  
  if(fseek(fd_fits,2880,0)<0)
    fin(ERR_SEEK);

     
}

/*********************************************/

void write_data(fen,tab_fen,fd_fits)
Fenetre *fen;
Datum   *tab_fen;
FILE    *fd_fits;
{
  long size;
  int i;

  size=fen->nblig*fen->nbcol;
 
 

  if(0 == fwrite(tab_fen,sizeof(Datum)*size,1,fd_fits))
    {
      printf("\n erreur %i",errno);
      fin(ERR_ECRI);
    }

}

/*********************************************/

int  menu(fen)
Fenetre *fen;
{
  int ok=0;


 	
  printf("\n Entrez l'indice de la fenetre dans le fichier (0-n)  : ");
  scanf("%i",&(fen->indice));

  printf("\n Entrez le nombre de lignes : ");
  scanf("%i",&(fen->nblig));

  printf("\n Entrez le nombre de colonnes : ");
  scanf("%i",&(fen->nbcol));
		
  printf("\n Entrez le nom du fichier source (ex /the/pc/images.don): ");
  scanf("%s",&(fen->src_file));

  printf("\n Entrez le nom du fichier destination (ex images.fits): ");
  scanf("%s",&(fen->dst_file));
		
  printf("\n l'indice de la fenetre est        : %d",fen->indice);
  printf("\n le nom du fichier source est      : %s",fen->src_file);
  printf("\n le nom du fichier destination est : %s",fen->dst_file);

  printf("\n\n ok ?  (1 pour ok, 0 pour corriger) : ");
  scanf("%i",&ok);
	
  return(ok);
}

/*********************************************/

void lecture_donnees(fen,tab_fen)
Fenetre *fen;
Datum   *tab_fen; 
{
  
  long size_fen;
  FILE *fdacq;


  size_fen=fen->nbcol*fen->nblig;

  fdacq = fopen(fen->src_file,"rb");
  
  if(fdacq == NULL)
    fin(ERR_OUVE); 

  if(fseek(fdacq,(fen->indice)*size_fen,0)!=0)
    fin(ERR_SEEK);


  if(0 == fread(tab_fen,sizeof(short),size_fen,fdacq))
    fin(ERR_LECT);

  fclose(fdacq);
}

/*********************************************/

void main()
{

  FILE	*fd_fits;
  
  Fenetre Fen;
  int i;
  long size_fen;

  printf("\nConversion d'image brut THEMIS en image au format fits");
 
 
  
  while(menu(&Fen)==0)
    {}
  
  
  size_fen=Fen.nbcol*Fen.nblig;

  tab_fen=(Datum *)malloc(sizeof(Datum)*size_fen);

  if(tab_fen == NULL)
    fin(ERR_MALO);

 
  lecture_donnees(&Fen,tab_fen);

  
  
  

  fd_fits=fopen(Fen.dst_file,"wb");
  if(fd_fits == NULL)
      fin(ERR_OUVE);


  write_gram(&Fen,fd_fits);



 
  write_data(&Fen,tab_fen,fd_fits);
  printf("\n apres wr data");

  free(tab_fen);
  fclose(fd_fits);

  printf("\n Conversion termine\n");

  fin(0);
	

}



























