h23085
s 00000/00000/00559
d D 1.5 98/03/11 17:28:17 chris 6 5
c 
e
s 00000/00000/00559
d D 1.4 97/08/27 22:36:20 chris 5 4
c fst
e
s 00000/00000/00559
d D 1.3 96/12/10 18:05:23 chris 4 3
c modif mineure du makefile
e
s 00003/00001/00556
d D 1.2 96/11/28 18:42:16 devel 3 1
c Introduction de SID pour sccs et mise a jour concernant
c le nouveau repertoire /export/home/devel/
e
s 00000/00000/00000
d R 1.2 96/11/28 11:56:19 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/fich_acq/util_facq.c
e
s 00557/00000/00000
d D 1.1 96/11/28 11:56:18 devel 1 0
c date and time created 96/11/28 11:56:18 by devel
e
u
U
f e 0
t
T
I 1
D 3
  static char *SccsId="%w% %g%";
E 3
I 3

static char *SccsId="%W% %G%";

E 3
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:util_facq.c
-----------------
-Auteur(s): Monique Savinelli
-Rle:
	Regroupe les fonctions permettant l'accs au fichier d'acquisition.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		get_enfen
		get_fen
		skip_fen
		get_fen_num_droite
		get_fen_num_gauche
		total_avant_fen
		total_apres_fen
		change_fen
		total_seq
	 
-Commentaires:
	Terminologie: le terme fichier d'acquisition reprsente le fichier
	rsultat de l'observation contenant des images numrises.
********************************************************************;-*/

#include	<stdio.h>
#include	<errno.h>

#include	<sun.h>
#include 	<acq.h>
#include	<enrg.h>
#include 	<the_errno.h>

extern Tb_acq *Pt_acq;
extern Erreur the_errno;
long numseq_cur;
long numfen_cur;

/*++********************************************************************
------------------
ENTETE DE FONCTION	:get_fen
------------------

-Rle:
	Cette fonction permet d'extraire une zone de donnes (fentre) du fichier
	d'acquisition
-inclure:
-Prototype:
	Datum *get_fen(fdesc,Pt_enfen)
-Paramtres:
	FILE *fdesc; pointeur sur le fichier d'acquisition.
	Ent_fen *Pt_enfen; pointeur sur une entte de fentre. (passage par valeur)
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	Le pointeur sur la zone de donnes lues (ie la fentre).
	NULL en cas d'erreur.
-Description:
	Cette fonction puise les informations ncessaires dans l'entte de
	fentre pour allouer une zone de donnes et y mettre la bonne quantit
	de donnes lues dans le fichier  partir de la position courante.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/
int get_fen(fdesc,Pt_enfen,tab_fen)

FILE 	*fdesc;
Ent_fen *Pt_enfen;
Datum	*tab_fen;
{
  long nval_fen = Pt_enfen->nval;
  int res;

	
  if(tab_fen == NULL)
    return(NULL);

  res=fread(tab_fen,sizeof(Datum),nval_fen,fdesc);

    if(res != nval_fen)
      {
	printf("\n fread probleme %d lu %d sur %d",errno,res,nval_fen);
	return(ERROR);		
      }
	

  return(OK);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:get_enfen
------------------

-Rle:
	La fonction get_enfen remplit une structure d'entte de fentre
	 partir des donnes rencontres dans le fichier d'acquisition 
	la position courante du pointeur de fichier.
-inclure:
-Prototype:
	int get_enfen(fdesc,Pt_enfen)
-Paramtres:
	FILE *fdesc; le pointeur sur le fichier d'acquisition.
	Ent_fen	*Pt_enfen; le pointeur sur une structure entte de fichier.	
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	OK si tout se passe bien.
	ERROR si problme.
-Description:
	le paramtre Pt_enfen est pass par rsultat.	
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/
int get_enfen(fdesc,Pt_enfen)

FILE *fdesc;
Ent_fen *Pt_enfen;
{


  if(fread(Pt_enfen,sizeof(Ent_fen),1,fdesc) != 1)
    return(ERROR);		
  return(OK);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:skip_fen
------------------

-Rle:
	Saute une fentre dans le fichier d'acquisition et 
	se positionne sur l'entte suivant la fentre saute.
-inclure:
-Prototype:
	int skip_fen(fdesc,Pt_enfen)
-Paramtres:
	FILE *fdesc; pointeur sur le fichier d'acquisition.
	Ent_fen *Pt_enfen; pointeur sur une entte de fentre(passage par valeur)
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	OK si tout se passe bien.
	ERROR si problme.
-Description:
	Le saut de fentre se fait vers la droite( sens dbut fichier -> fin fichier).
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/
int skip_fen(fdesc,Pt_enfen)

FILE *fdesc;
Ent_fen *Pt_enfen;
{
long nval_fen = Pt_enfen->nval;	 

	if(fseek(fdesc,sizeof(Datum)*nval_fen,SEEK_CUR) != 0)
	{
		the_errno.code = errno;
		return(ERROR);
	}	
	return(OK);

}
/*++********************************************************************
------------------
ENTETE DE FONCTION	:total_seq
------------------

-Rle:
	Cette fonction  calcul la taille en nombre de short d'une sequence
-inclure:
	acq.h
	th_form.h
-Prototype:
	long entre_fen_droite(fdesc,fen,numseq,numfen)
-Paramtres:
		
-Variables globales utilises
	Internes au fichier:
		numseq_cur;numero de squence courante
		numfen_cur;numro de fentre courante.
-Retour:
	OK ou ERROR.
-Description:
	Cette fonction recherche vers la droite une fentre
	dans une mme squence ou dans une squence diffrente.
-Constantes utilises
	Internes au fichier:
	Importes:-Description:
		
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
************************************************************************--*/



long total_seq(Pt_acq,Pt_enrg)
Tb_acq  *Pt_acq;
Tb_enrg *Pt_enrg;
{
  long i;
  u_long total=0;

  if((Pt_acq->nbfen>NB_MAX_FEN)||(Pt_acq->nbfen<0))
    return(-1);
  else
    {

      for(i=0;i<NB_MAX_FEN;i++)
	{
	  if(Pt_enrg->numfen[i]==1)
	    total += Pt_acq->enfen+((Pt_acq->tab_fen[i]).nblig)
	      *((Pt_acq->tab_fen[i]).nbcol);
	}

      return(total);
    }
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:skip_seq
------------------

-Rle:
	Saute une acquisition 
-inclure:
-Prototype:
	int skip_fen(fdesc,nb_seq)
-Paramtres:
	FILE *fdesc; pointeur sur le fichier d'acquisition.
	int	nb_Sec
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	OK si tout se passe bien.
	ERROR si problme.
-Description:

-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/

int skip_seq(fdesc,num_seq,pt_acq,pt_enrg)

FILE *fdesc;
int  num_seq;
Tb_acq	*pt_acq;
Tb_enrg *pt_enrg;
{
size_t deplac;
	deplac=sizeof(Datum)*total_seq(pt_acq,pt_enrg)*(num_seq -1);
	
 if(num_seq!=1)
 {
	
	if(fseek(fdesc,deplac,SEEK_CUR) != 0)
			return(ERROR);
 }
	return(OK);

}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:get_fen_num_droite
------------------

-Rle:
	Cette fonction retourne la fentre dont le numro est pass en
	paramtre.
-inclure:
-Prototype:
	Datum *get_fen_num_droite(fdesc,numfen)
-Paramtres:
	FILE *fdesc; pointeur sur le fichier d'acquisition.
	long numfen; numro de la fentre  trouver.
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	Le pointeur sur la zone de donnes lues dans la fentre.
	NULL si numero de fentre non trouv (fin de fichier).
-Description:
	Cette fonction recherche vers la droite dans le fichier(sens dbut -> 
	fin fichier).

-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
****************************************************************************--*/
Datum *get_fen_num_droite(fdesc,numfen,tab_fen)

FILE *fdesc;
long numfen;
Datum *tab_fen;
{
  Ent_fen *Pt_entete;

  Pt_entete=(Ent_fen *)malloc(sizeof(Ent_fen));
  if(Pt_entete == NULL)
    {
      the_errno.code = errno;
      return(NULL);	
    }

  do
    {
      if(get_enfen(fdesc,Pt_entete) == ERROR)
	return(NULL);		
	
      if(feof(fdesc)) return(NULL); 
				
      if(Pt_entete->num == numfen)
	{
	 		  
	  get_fen(fdesc,Pt_entete,tab_fen);
	  free(Pt_entete);
	  return(tab_fen);
	}
      else
	if(skip_fen(fdesc,Pt_entete) == ERROR)
	  return(NULL);	

    }while (Pt_entete->num != numfen);		

	
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:get_fen_num_gauche
------------------

-Rle:
	Cette fonction retourne la fentre dont le numro est pass en 
	paramtre
-inclure:
-Prototype:
	Datum *get_fen_num_gauche(fdesc,numfen)
-Paramtres:
	FILE *fdesc; pointeur sur le fichier d'acquisition.
	long numfen; numro de la fentre  trouver. 	
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	Le pointeur sur la zone de donnes lues dans la fentre
	NULL si numro de fentre non trouv (fin de fichier). 
-Description:
	Cette fonction recherche vers l'arrire (vers la gauche) ou dbut du fichier
	la fentre dont le numro est pass en paramtre. Elle repositionne le fichier au 
	dbut et recherche vers la droite la fentre.
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
************************************************************************--*/
Datum *get_fen_num_gauche(fdesc,numfen)

FILE *fdesc;
long numfen;
{
Datum *tabfen = NULL;
Datum *retourfen = NULL;
fpos_t position; 
long pos;

	if((pos = ftell(fdesc)) < 0)
		{
			the_errno.code = errno;
			return(NULL);
		}

	rewind(fdesc);
	do
	{
		retourfen = tabfen;

		if(fgetpos(fdesc, &position) != 0)
		{
			the_errno.code = errno;
			return(NULL);
		}		
		tabfen = get_fen_num_droite(fdesc,numfen);
		
		if(tabfen == NULL) 
			return(NULL);

	}while (ftell(fdesc) != pos);

	if(fsetpos(fdesc, &position) != 0)
		return(NULL); 		

	return(retourfen);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:total_avant_fen
------------------

-Rle: 	Calcule le nombre de donnes en short avant une fentre recherche
	depuis le dbut de la squence.
-inclure:
	acq.h
-Prototype:
	long total_avant_fen(numfen)

-Paramtres:
	numfen		numro de fentre dont on recherche la place.

-Retour:
	La quantit de donnes  sauter ou ERROR.

-Exemple:
-Commentaires:
********************************************************************--*/
long total_avant_fen(numfen)

long numfen;
{
long fen = 0;
long total =0;

	
	do
	{
		if((((Pt_acq->tab_fen[fen]).nblig) != 0) &&
			(((Pt_acq->tab_fen[fen]).nbcol) != 0))
		{ 
		   total +=	Pt_acq->enfen + ((Pt_acq->tab_fen[fen]).nblig)
			  	*((Pt_acq->tab_fen[fen]).nbcol);
		   fen++;
		}
	}while(fen < numfen);
 	
	return(total);
}

/*++****************************************************************************
------------------
ENTETE DE FONCTION	:total_apres_fen
------------------

-Rle: 	Calcule le nombre de donnes en short  sauter dans la zone rserve
	de mmoire commune de puis la fin de la fentre courante jusqu' 
	la fin de la squence
-inclure:
	acq.h
-Prototype:
	long total_apres_fen(numfen)

-Paramtres:
	numfen		numro de fentre dont on recherche la place.
-Variables globales utilises
	Internes au fichier:	numfen_cur:numro de fentre courante.
-Retour:
	La quantit de donnes  sauter ou ERROR.

-Constantes utilises
	Importes:
		NB_MAX_FEN		(th_form.h)

-Exemple:
-Commentaires:
******************************************************************--*/
long total_apres_fen(numfen)

long numfen;
{
long fen = numfen_cur + 1;
long total =0;

 	do
	{
		if((((Pt_acq->tab_fen[fen]).nblig) != 0) &&
			(((Pt_acq->tab_fen[fen]).nbcol) != 0))
		{ 
			total +=
			Pt_acq->enfen + ((Pt_acq->tab_fen[fen]).nblig)
			*((Pt_acq->tab_fen[fen]).nbcol);
			fen++;
		}
	}while(fen < NB_MAX_FEN);
	 	
	return(total);
}
E 1
