static char *SccsId="@(#)util_err.c	1.2 21 Aug 1997";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE: util_err.c
-----------------
-Authors:Christian Miguel

-Library: erreurs.a

-Purpose:

This file contains the errors handling functions for the recording program.The function init_ctrl_err prepare the process which launches it for error traitment.  The function add_err_histo is used by the "error traitment" functions defined in fonc_trt.c.
-Variables:
Erreur		*historique_err;

-Functions:
		message_spy
		init_ctrl_err
		fin_ctrl_err
		add_err_histo
		member_err_histo
		print_histo
	 
-Keywords:
error.
	
;;#h#<*********************************************************************/


#include 	<stdio.h>
#include        <time.h>
#include	<sys/time.h>
#include 	<sys/types.h>
#include 	<sys/socket.h>
#include 	<sys/un.h>
#include	<sys/signal.h>
#include	<fcntl.h>
#include 	<errno.h>

#include	<sun.h>
#include	<the_errno.h>
#include        <the_time.h>


Erreur 		the_errno;
int 		the_nb_err;
Erreur		*historique_err=NULL;


extern FILE *fd_spy;



  
/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: message_spy
------------------

-Purpose:
Write a message on a file
-Prototype:
int message_spy(fd,message);
-Parameters:
 FILE *fd: file handle
 message: string containing the message to print in the file.
-Return:
ERROR if writting is impossible. Else OK.	
;;#f#<*********************************************************************/

#ifdef _test

int message_spy(fd,message)
FILE *fd;
char message[TAILLE_MES];
{
/* pour imprimer le pid apres le message */
  /*  char chpid[8];
      sprintf(chpid, "-(%6d)", getpid());
  */

/* pour imprimer le message a l'ecran */
/*  printf(message);*/
  if(fd != NULL)
    {
      fwrite(message,1,strlen(message)+1,fd);
/*       fwrite(chpid,1,strlen(chpid)+1,fd); */
      fflush(fd);
      return(OK);
    }
  else
    return(ERROR);
}

#endif  

#ifndef _test

int message_spy(fd,message)
FILE *fd;
char message[TAILLE_MES];
{
  return(OK);
}

#endif

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:init_ctrl_err
------------------

-Purpose:
Prepare the process which launches this function for error traitment.	
-Prototype:
	int init_ctrl_err(sock_enrg);
-Parameters:
 int sock_enrg[2]: socket.
-UsesVariables:
historique_err The error history table.
-UsesFunctions:
init_mess_err     (see messages.c)
init_mess_err_vme  (see messages_vme.c)
-Comments:
Here are initialized the table historique_err, the table message_err (thanks
to init_mess_err() and init_mess_err_vme() ) and a socket to communicate 
with the "control process".
-Return:
OK or ERROR. In the last case the variable 'the_errno' is set to the error
code. 
;;#f#<*********************************************************************/

int init_ctrl_err(sock_enrg)

int sock_enrg[2];
{
  historique_err=(Erreur *)malloc(NB_MAX_ERR*sizeof(Erreur));
  the_nb_err=0;
  the_errno.code=OK;


  init_mess_err();
  /*
  init_mess_err_vme();
  */

  if(OK==socketpair(AF_UNIX,SOCK_DGRAM,0,sock_enrg))
	    
    {

      if((OK==fcntl(sock_enrg[0],F_SETFL,O_NDELAY|
		    fcntl(sock_enrg[0],F_GETFL,0)))&&
	 (OK==fcntl(sock_enrg[1],F_SETFL,O_NDELAY|
		    fcntl(sock_enrg[1],F_GETFL,0))))
	{
	  return(OK);
	}
      else
	{	
	  the_errno.code=errno;
	  return(ERROR);
	}
    }
  else
    {
      the_errno.code=errno;
      return(ERROR);
    }
}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:fin_ctrl_err
------------------

-Purpose:
      Close everything to terminate.
-Prototype:
	in fin_ctrl_err();

-UsesVariables:
historique_err The history table.
 
-Return:
 OK or ERROR if the history has not been allocated.

;;#f#<*********************************************************************/

int fin_ctrl_err()
{
	if(historique_err!=NULL)
	{
		free(historique_err);
		historique_err=NULL;
		return(OK);
	}
	return(ERROR);
}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: add_err_histo
------------------

-Purpose:
	
Add an error to the error history.
-Prototype:
	int add_err_histo(nboccu,err)
-Parameters:
	int nboccu: Maximum number of occurence of this error in the history.
	If nboccu = 0, the function systematically adds this error, else it 
	adds it while this number of occurence is not passed.

	Erreur *err: the error to put in the history.
-UsesVariables:
historique_err The error history table.
-Return:
OK ou ERROR if there are too many errors.

-Comments:
	
	Currently, it is not possible to put more errors than the available
	size in the history. To solve this, one solution can consist in
	cleaning the history when it is full. A better solution is to increase
	the size of the history and clean it when the CPU load is not too high.
        
;;#f#<*********************************************************************/

char *heure_err()
{
  struct timeval time1;
  struct tm *errtime;
  time_t cl;
  int year,month,day,hr,mn,sc;
  char heure_char[TAILLE_DATEFICH];

  if((errtime=(struct tm*)malloc(sizeof(struct tm))) == NULL)
    {
      the_errno.code=errno;
      return(NULL);
    }
   
  gettimeofday(&time1,NULL);
  cl=time1.tv_sec;
  errtime = gmtime(&cl);

  year=errtime->tm_year;
  if(year < 20)
    {
      year+=SIECLE+100;
    }
  else
    {
      year+=SIECLE;
    }
  month=errtime->tm_mon+1;
  day=errtime->tm_mday;
  hr=errtime->tm_hour;
  mn=errtime->tm_min;
  sc=errtime->tm_sec;


  sprintf(heure_char,"%i-%.2i-%.2iT%.2i:%.2i:%.2i\0",year,month,day,hr,mn,sc);
  message_spy(fd_spy,"dans heure_err :");
  message_spy(fd_spy,heure_char);
  free(errtime);
  return(heure_char);
}

int add_erreur_histo(nboccu,err)

int 	nboccu;
Erreur *err;
{


  if(the_nb_err!=NB_MAX_ERR)
    {
      if(the_nb_err!=NB_MAX_ERR-2)
	{
	  if(nboccu==0)
	    {
	      historique_err[the_nb_err]=*err;

	      strcpy(historique_err[the_nb_err].time,heure_err());
	      the_nb_err++;
	      return(OK);
	    }
	  else
	    {
	      if(member_err_histo(err)<nboccu)
		{
		  historique_err[the_nb_err]=*err;
		  strcpy(historique_err[the_nb_err].time,heure_err());
		  the_nb_err++;
		  return(OK);
		}
	      else
		return(OK);
	    }
	}
      else
	{
	  historique_err[the_nb_err]=*err;
	  the_errno.code=E_TOOMANY_ERR;
	  the_errno.ctxt=0;
	  historique_err[++the_nb_err]=the_errno;
	  the_nb_err++;
	  return(ERROR);
	}
    }
  else
    {
      the_errno.code=E_TOOMANY_ERR;
      the_errno.ctxt=0;
      return(ERROR);
    }
}

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:member_err_histo
------------------

-Purpose:
Check if an error is already in the history.
-Prototype:
	int member_err_histo(err)
-Parameters:
	Erreur *err: the error code.
-UsesVariables:
historique_err The error history table.
-Return:
The number of occurence of the error in the history.	

;;#f#<*********************************************************************/


int member_err_histo(err)

Erreur *err;
{
  int i;
  int compte=0;

  for(i=0;i<the_nb_err;i++)
    {
      if(historique_err[i].code==err->code)
	compte++;
    }
  return(compte);
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:print_histo
------------------

-Purpose:

Print the error history in a file.

-Prototype:
void print_histo();

-Comments:

This function assume that the file where the error history has to be copied
is described by the file handler "fd_spy".

;;#f#<*********************************************************************/



void print_histo()
{
  int i;
  char message[TAILLE_MES];

#ifdef _test

  if(fd_spy != NULL)
    {

      strcpy(message,"\nHistorique Erreur\n");
      fwrite(message,sizeof(message),1,fd_spy);

      for(i=0;i<the_nb_err;i++)
	{
	  sprintf(message,"Err code %d",historique_err[i].code);
	  fwrite(message,sizeof(message),1,fd_spy);
	}
    }	

#endif
}


void clean_erreur()
{
  the_errno.code=OK;
  the_errno.where=OK;
  the_errno.ctxt=OK;
  the_errno.numero=NOTH;
}
