static char *SccsId="%w% %g%";
/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE: trt_err.c
-----------------
-Authors:Christian Miguel

-Library: erreurs.a
-Purpose:

Contains the functions for the error management. In particular, it contains the function which write the errors in the history file.

 	
-Functions:
     
		init_trt_err
		fin_trt_err
		write_histo
-Variables:
Fonc_trt	aiguillage_err[NB_ERR] (table containing the error handling function associated to an error.)
FILE		*fd_fich_err (file handler associated to FILE_HISTO.)	 
-Comments:
If the error management results in an error....then the program is stopped and the error (history) file is written with the message corresponding to an error on error management. clear ;-)
-Keywords:
error.

;;#h#<*********************************************************************/

#include	<stdio.h>
#include	<fcntl.h>
#include	<errno.h>

#include	<time.h>
#include	<sys/timeb.h>


#include	<sun.h>
#include	<enrg.h>
#include	<process.h>
#include	<the_errno.h>



extern 		int	the_nb_err;
extern		Erreur	*historique_err;
extern 		Erreur	the_errno;



#ifdef _test
extern FILE *fd_spy;
#endif

FILE		*fd_fich_err;

Fonc_trt	aiguillage_err[NB_ERR];


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: init_trt_err
------------------
-Purpose:
This function initialize the table "aiguillage_err" and open FILE_HISTO.

-Prototype:
        int init_trt_err()
-Parameters:
        FILE *fd_fich_err: by result.
-UsesVariables:
aiguillage_err table containing the error handling functions (see next field). 

-UsesFunctions:
warn_default
trt_err_defaut
warn_decode_enrg
trt_err_init
-Return:
OK or ERROR. If ERROR is return , it isn't useful to continue so exit the program.

;;#f#<*********************************************************************/

int init_trt_err()
{
  int i;

  printf("\n init_trt: Remplissage avec warn_defaut");
  for(i=0;i<NB_ERR;i++)
    aiguillage_err[i]=warn_defaut;

  
  for(i=0;i<ERR_CRIT_SUN;i++)
    aiguillage_err[i]=trt_err_defaut;

  for(i=ERR_CRIT_SUN;i<ERR_WARNINGS;i++)
    aiguillage_err[i]=trt_err_defaut;

  for(i=ERR_BASE_VME-ERR_BASE_STK;i<NB_ERR;i++)
    aiguillage_err[i]=trt_err_defaut;

  aiguillage_err[E_BAD_DINTG-ERR_BASE_STK]=warn_decode_enrg;
  aiguillage_err[EWOULDBLOCK-ERR_BASE_STK]=trt_err_init;
  aiguillage_err[E_ALLOC_VME]=trt_err_init;

 
  fd_fich_err=fopen(FILE_HISTO,"a");
  if(NULL==fd_fich_err)
    {
      the_errno.code=errno;
      the_errno.where=FICH_ERR;
      return(ERROR);
    }

  return(OK);


}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: fin_trt_err
------------------

-Purpose:
This function terminates the error management.	

-Prototype:
	int fin_trt_err(fd_ficherr)
-Parameters:
 FILE *fd_fichierr:
-Comments:
Currently, this function just close a file (history).

;;#f#<*********************************************************************/


int fin_trt_err(fd_ficherr)

FILE *fd_ficherr;
{
	return(fclose(fd_ficherr));
}




/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: write_histo
------------------

-Purpose:
Write the history (i.e. the list of the error messages) in a file. This allows the users of the rao PC to know what is going on with the SUN workstation.

-Prototype:
	int write_histo(lerreur,nb_err,fd)

-UsesFunctions:
mess_err (messages.c)
mess_local (messages.c)
-Return:
	OK ou ERROR

-Comments:

Note that, here, the time require a code review because it only gives seconds for the moment. It is possible to use other functions than the one currentkly used in order to have a more accurate clock. Currently, the time field of the error structure is not used.

;;#f#<*********************************************************************/

int write_histo(lerreur,nb_err,fd)
Erreur *lerreur;
int    *nb_err;
FILE   *fd;

{
  char message[TAILLE_MES],mess[TAILLE_MES];

  char ch_code[4];
  int	i=0;

  while(*nb_err!=0)
    {

      sprintf(message,"\n%s",lerreur[i].time);
      sprintf(mess," Erreur %d: ",lerreur[i].code);
      strcpy(message,strcat(message,mess));
      strcpy(message,strcat(message,mess_err(lerreur[i].code)));
      strcpy(message,strcat(message,mess_local(lerreur[i])));
      

      if(strlen(message)==fwrite(message,sizeof(char),strlen(message),fd))
	{
	  (*nb_err)--;
	  i++;
	}
      else
	{
	  the_errno.code=errno;
	  return(ERROR);
	}
      
    }
  fflush(fd);

  
  return(OK);
}




















