
static char *SccsId="@(#)test_err.c	1.6 04/14/98";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE: test_err.c
-----------------
-Authors: Christian Miguel
-Purpose:
Test the error traitment library (erreurs.a)
-Functions:
essai_test_mess
essai_test_vme
essai_write_histo
essai_trt_local
main (of course!)
-Keywords:
error, test.

;;#h#<*********************************************************************/


#include	<stdio.h>
#include        <fcntl.h>
#include	<errno.h>

#include	<sun.h>
#include	<the_errno.h>
#include	<process.h>


extern Erreur the_errno;
extern Erreur *historique_err;
extern FILE   *fd_fich_err;
extern int    the_nb_err;
long Pt_synchro[NB_SH_SEG];

int sock_enrg[2],sock_visu[2];

/*fd_spy must be defined for testing*/
FILE *fd_spy=NULL;

/********************************************************************;;#f#>
HEAD_OF_FUNCTION: essai_test_mess
-Purpose:
Test the value of the string returned by mess_err for few errors.
-Prototype:
void essai_test_mess()
-UsesFunctions:
mess_err (messages.c)
;;#f#<********************************************************************/

void essai_test_mess()
{
	printf("\n Essai de quelques messages...\n");

	printf("\nE_IDL_WIN: %d %s",E_IDL_WIN,mess_err(E_IDL_WIN));
	printf("\nE_BAD_DINTG: %d %s",E_BAD_DINTG,mess_err(E_BAD_DINTG));
	printf("\nNO_SUCH: 2 %s",mess_err(2));
	printf("\nPROCESS: 3 %s",mess_err(3));


}
/********************************************************************;;#f#>
HEAD_OF_FUNCTION: essai_test_vme
-Purpose:
Test the communication between the VME and the workstation for the error managment.
-Prototype:
void essai_test_void()
-UsesFunctions:
init_err_vme (Sun-client.c)
init_servme_err (sock_serv.c)
mess_err (messages.c)
fin_err_vme (Sun-client.c)

;;#f#<********************************************************************/
void essai_test_vme()
{
  int 	sock;
  int     pid;
  int i=1;
  
  
  pid = fork();
  
  if(pid==0)
    {
      printf("\n processus fils en attente");
      sleep(1);
      printf("\n Lancement de l'init du traitement des erreurs par RPC");
     
      init_err_vme();
      
      _exit(0);
    }
  else
    {
  
      printf("\n processus pere, tentative de connexion");
      sock=init_servme_err();
      
      if(sock!=ERROR)
	{
	  printf("\n connexion ok de la SUN");
	  printf("\n Reste les tests de reception emission");
	  fcntl(sock,F_SETFL,O_NDELAY|fcntl(sock,F_GETFL,0));
	}
      else
	printf("\n Connexion rate, erreur %s",strerror(the_errno.code));
      
      while(i==1)
	{
	  i=2;
	  if(read(sock,&the_errno,sizeof(Erreur))>0)
	    {	
	      printf("Recu erreur no %d : %s",the_errno.code
		     ,mess_err(the_errno.code));
	      
	    }
	  else
	    printf("Rien Recu");
	  
	  printf("\n\n Checking socket ? Yes (1) No (2) ");
	  scanf("%d",&i);
	}
      fin_err_vme();
      printf("\n Fermeture de la socket %d", close(sock));

    }

}

/****************************************************************;;#f#>
HEAD_OF_FUNCTION: essai_write_histo
-Purpose:
test the functions add_erreur_histo and write_histo which write the history table and file.
-Prototype:
void essai_write_histo();
-UsesFunctions:
add_erreur_histo
write_histo
;;#f#<*****************************************************************/

void essai_write_histo()
{
  the_errno.code=E_NO_IDL;
  the_errno.where=PONT_BUS;
  add_erreur_histo(0,&the_errno);
  the_errno.code=E_PONT_BUSY;
  add_erreur_histo(0,&the_errno);
  
  write_histo(historique_err,&the_nb_err,fd_fich_err);
}

/****************************************************************;;#f#>
HEAD_OF_FUNCTION: essai_trt_local
-Purpose:
Test the error managment. (local to the SUN workstation)
-Prototype:
void essai_trt_local()
-UsesFunctions:
init_ctrl_err (util_err.c)
init_trt_err (trt_err.c)
fin_trt_err (trt_err.c)
fin_ctrl_err (util_err.c)
-Comments:
Here a child process is launched which will send the error to its father which will manage it.

;;#f#<*****************************************************************/

void essai_trt_local()
{	
int pid;

	init_ctrl_err(sock_enrg,sock_visu);

	printf("\n Initialisation du traitement des erreurs");
	init_trt_err();

	pid=fork();

	if(pid==0)
	{
		sleep(4);
		printf("\n Processus fils");
		the_errno.code=125;
		write(sock_visu[1],&the_errno,sizeof(Erreur));
		_exit(0);
	}	
	else
	{
		sleep(4);
		printf("\n Processus pere");
		sleep(4);
		if(read(sock_visu[0],&the_errno,sizeof(Erreur))>0)
		{
			printf("\nRecu erreur %d",the_errno.code);
		}
		fin_ctrl_err();
		fin_trt_err();
		/* close(sock); */

	}

}

/*******************************************************************;;#f#>
HEAD_OF_FUNCTION: main
-Purpose:
Starts the test functions.
-Prototype:
void main()
-UsesFunctions:
init_mess_err
init_mess_err_vme
essai_test_vme
essai_trt_local
;;#f#<*******************************************************************/
void main()
{


	printf("\n Initialisation des messages d'erreurs dans le tableau");
	init_mess_err();
	printf("\n Initialisation des messages d'erreurs du VME");
	init_mess_err_vme();

	printf("\n ATTENTION,lancement de la connexion");
	essai_test_vme();	


	essai_trt_local();
}


