static char *SccsId="@(#)sock_serv.c	1.2 21 Aug 1997";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE:sock_serv.c
-----------------
-Authors:Christian Miguel

-Library: erreurs.a
-Purpose:
Contains the basic socket manipulation functions for the error management by the SUN workstation of the VME errors. This file contains the server part, i.e. for the SUN workstation which is listening to the errors arriving from the VME.

-Functions:
		init_servme_err
-Keywords:
error.	 

;;#h#<*********************************************************************/

#include 	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include	<fcntl.h>
#include	<errno.h>

#include	<sun.h>
#include	<the_errno.h>




extern	Erreur	the_errno;
extern  FILE    *fd_spy;

/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:init_servme_err
------------------

-Purpose:
Build the communication between the VME and the SUN workstation for the VME error management. The SUN workstation centralises all the errors and manages them.

-Prototype:
	int init_vme_err()

-Return:
ERROR or the socket descriptor. In case of error, the_errno contains the code.

-Comments:
The communication uses TCP sockets (with connected mode). Read and write an error is done thanks to the read and write functions taking as parameter the the_errmo variable which contains the informations relatives to the error.

;;#f#<*********************************************************************/


int init_servme_err()

{
int sock_vme,sock_con;
struct sockaddr_in	myaddr;


        myaddr.sin_family= AF_INET;
	myaddr.sin_port = htons (PORT_SERV_ERR);
	myaddr.sin_addr.s_addr= htonl (INADDR_ANY);



	sock_vme=socket(AF_INET, SOCK_STREAM, 0);
	if(sock_vme==ERROR)
	{
		the_errno.code=errno;
		return(ERROR);
	}

       if(bind(sock_vme,(struct sockaddr *)&myaddr,sizeof(struct sockaddr))<0)
	{
		the_errno.code=errno;
		close(sock_vme);
		
		return(ERROR);
		
	}

	if(listen(sock_vme,2)==ERROR)
	{
		the_errno.code=errno;
		close(sock_vme);
		return(ERROR);
	}

	sock_con=accept(sock_vme,NULL,NULL);
	if(sock_con==ERROR)
	{
	        the_errno.code=errno;
		close(sock_vme);
		return(ERROR);
	}

        if(ERROR==fcntl(sock_con,F_SETFL,O_NDELAY|fcntl(sock_con,F_GETFL,0)))
	  {
	    the_errno.code=errno;
	    return(ERROR);
	  }
	close(sock_vme);
	return(sock_con);
}





