static char *SccsId="@(#)messages.c	1.2 21 Aug 1997";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE: messages.c
-----------------
-Authors:Christian Miguel (le 7/8/95)
-Library: erreurs.a
-Purpose:
Contains the functions for creation of the error messages. Thanks to these functions, an error code will be translated in a complete understandible message.

-Variables:
char message_local[TAILLE_MES][NB_LOC]: contains the error localisation messages
char message_err[TAILLE_MES][NB_ERR]: contains the error messages
char message_type[NB_LOC][TAILLE_MES]:
-Functions:
		init_mess_err
		print_in_mes
		mess_err
		mess_local
-Keywords:
error.

;;#h#<*********************************************************************/


#include	<stdio.h>
#include	<errno.h>

#include	<sun.h>
#include	<the_errno.h>

extern  char            Liste_mcle[NB_MCLE][TAILLE_MCLE];

char message_local[NB_LOC][TAILLE_MES]={\
		"",
		"dans le fichier paracq.don ",
		"dans le fichier paracq.fix ",
		"dans le fichier paracq.phy ",
		"dans le fichier paracq.sem ",
		"dans le fichier de donnees reglage ",
		"dans le fichier des erreurs ",
		"dans le fichier de donnees d'observation ",
		"dans Le fichier config de SBS915 ",
		"dans le fichier de la visu "};


char message_type[NB_TYPE][TAILLE_MES]={\
                "",
		"pour le pont de bus ",
		"pour serv-acq ",
		"pour l'initialisation ",
		"pour la fenetre ",
		"pour la camera ",
		"pour l'obturateur ",
                "a la ligne ",
                "numero ",
                "pour le formatage ",
		"manque le mot cle "};

char message_err[NB_ERR][TAILLE_MES];

extern FILE *fd_spy;


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:print_in_mes
------------------

-Purpose:
Add an error message in the error messages table.
-Prototype:
	void print_in_mes(indice,message)
-Parameters:
	int	indice: index of the error
	char	*message: the error message
-UsesVariables:
        message_err: the message error table.
-Example:
print_in_mess(E_DECODE_SYNT,"mot cle inconnu ");

;;#f#<*********************************************************************/


void print_in_mess(indice,message)
int indice;
char *message;
{
int i=indice-ERR_BASE_STK;

	strcpy(message_err[i],message);
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: init_mess_err
------------------

-Purpose:
Fill in the error messages table with the corresponding string.
-Prototype:
	void init_mess_err()

-UsesVariables:
       message_err: the error messages table.
-UsesFunctions:
       print_in_mess  
-Example:
Calling sequence: init_mess_err();

;;#f#<*********************************************************************/



void init_mess_err()
{
  int i;
   

    for(i=NB_ERR_SYS;i<NB_ERR+NB_ERR_SYS;i++)
      print_in_mess(i,"Code d'erreur inconnu ? ");

  print_in_mess(E_PONT_BUSY,"probleme pont de bus ");
  print_in_mess(E_ALLOC_VME,"pas d'allocation mem in VME ");
  print_in_mess(E_PROC_CREAT,"pb de creation de processus ");
  print_in_mess(E_ALLOC_SUN,"pas d'allocation mem in SUN ");
  print_in_mess(E_NO_IDL,"idl serveur introuvable ");
  print_in_mess(E_BAD_ARG_CONF,"trop peu mauvais arguments ");
  print_in_mess(E_BAD_FST_CHAR,"mauvais premier caractre ");
  print_in_mess(E_BAD_OPERATOR,"mauvais oprateur ");
  print_in_mess(E_T_OUT_SOCK,"time out sock err SUN-VME ");

  /* Erreurs de decodage */

  print_in_mess(E_DECODE_SYNT,"mot cle inconnu ");
  print_in_mess(E_DECODE_SEM,"mauvaise valeur de parametre ");
  print_in_mess(E_BAD_CAM_NB,"mauvais nombre de cameras ");
  print_in_mess(E_BAD_FEN_NUM,"mauvais nombre de fenetres ");
  print_in_mess(E_BAD_FENCOOR,"mauvaise definition d'une fenetre ");
  print_in_mess(E_BAD_FENVISU,"fenetre a visualiser non definie ");
  print_in_mess(E_BAD_FENENRG,"fenetre a enregistrer non definie ");
  print_in_mess(E_BAD_DINTG,"mauvais temps d'intergration ");
  print_in_mess(E_BAD_OBTUR,"mauvaise affectation d'obturateur ");
  print_in_mess(E_DECODE_REDUN,"information deja existante ");
  print_in_mess(E_FICH_NO_END,"pb fichier paracq, pas de end ");
  print_in_mess(E_TOOMANY_VISU,"trop de fenetres a visualiser ");
  print_in_mess(E_BADCAM_NUM,"mauvais numero de camera ");
  print_in_mess(E_NO_MODOB,"pas de mode d'observation ");
  print_in_mess(E_NO_CAD,"cadence mal definie ");
  print_in_mess(E_NO_VALUE,"pas de valeur ");


  /*Erreurs visu*/

  print_in_mess(E_UNK_HEAD,"header inconnu ");
  print_in_mess(E_UNK_KEYTYPE,"type de mot cle inconnu ");
  print_in_mess(E_BAD_BUF," mauvais buffer ");
  print_in_mess(E_BAD_ENRGNUM,"nombre de fenetre a enregistrer ");
  print_in_mess(E_BAD_NAXIS,"incoherence NAXISn ");
  print_in_mess(E_BAD_WAVE,"mauvaise longueur d'onde ");
  print_in_mess(E_BASS2000,"manque mot cle bass 2000 ");
  print_in_mess(E_IDL_WDEL,"commande idl wdelete non effectuee ");
  print_in_mess(E_IDL_VFILL,"remplissage foiree de variable idl ");
  print_in_mess(E_IDL_SETVAR,"affectation foiree de variable idl ");

	
  /*Erreurs serveur communication...*/

  print_in_mess(E_TIME_OUT,"time out ");
  print_in_mess(E_BRUT_ENRG,"kill brutal de l'enregistrement ");
  print_in_mess(E_BRUT_VISU,"kill brutal de la visulisation ");
  print_in_mess(E_BRUT_CTRL,"kill brutal du controle ");

}
 


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: mess_err
------------------

-Purpose:
Returns the error message corresponding to the error code given as parameter.

-Prototype:
	char *mess_err(err)
-Parameters:
	int err: the error code.

-UsesVariables:
		message_err: error messages table.
	
;;#f#<*********************************************************************/


char *mess_err(err)

int err;
{
  int type;
  char mess[TAILLE_MES];

  if(err<ERR_BASE_STK)
    {
      strcpy(mess,strerror(err));
      return(mess);
    }
  else
    {
      return(message_err[err-ERR_BASE_STK]);
    }
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION:mess_local
------------------

-Purposee:
Return the message associated to the localisation code.

-Prototype:
	char *mess_local(erreur)
-Parameters:
	int where: indice of the localisation
-UsesVariables:
	message_local: messages localisation table.
	message_type:

-Return:
The string!

;;#f#<*********************************************************************/


char *mess_local(err)

Erreur err;
{
  char 	message[TAILLE_MES],mess[TAILLE_MES];
  char  mess2[TAILLE_MES];
  char	ch_number[4];

  message_spy(fd_spy,"\ndans mess_local");
  if(err.where !=OK)
    {
      sprintf(message,"%s",message_local[err.where]);
      sprintf(mess2,"\n where %i",err.where);
      message_spy(fd_spy,mess2);
      message_spy(fd_spy,message);
    }

  if(err.ctxt !=OK)
    {
      strcpy(message,strcat(message,message_type[err.ctxt]));
      sprintf(mess2,"\n ctxt %i",err.ctxt);
      message_spy(fd_spy,"\n ctxt ");
      message_spy(fd_spy,message);
    }

  if(err.numero != NOTH)
    {
      if(err.ctxt == MMOTCLE)
	{	  
	  strcpy(message,strcat(message,Liste_mcle[err.numero]));
	}
      else
	{
	  sprintf(mess,"%i",err.numero);
	  strcpy(message,strcat(message,mess));
	}
    }

  message_spy(fd_spy,message);
  return(message);
}






















