static char *SccsId="@(#)fonc_trt.c	1.2 21 Aug 1997";

/*********************************************************************;;#h#>
-----------------
HEAD_OF_FILE: fonc_trt.c
-----------------
-Authors:Christian miguel (10/8/95)

-Library: erreurs.a

-Purpose:

Here are defined all the functions which will be used to resolve an error. They  will be stored in the table aiguillage_err[NB_ERR] (defined in trt_err.c).


-Functions:
		trt_err_defaut
		trt_err_init
		warn_decode_enrg
		warn_defaut
-Keywords:
error.
;;#h#<*********************************************************************/

#include	<stdio.h>
#include	<sys/signal.h>
#include	<sys/types.h>
#include	<unistd.h>

#include	<sun.h>
#include	<enrg.h>
#include	<process.h>
#include	<the_errno.h>

extern		long	*Pt_synchro;
extern 		int	the_nb_err;
extern		Erreur	*historique_err;
extern 		Erreur	the_errno;
extern int	tab_pid[NB_PROC];
extern FILE     *fd_fich_err;
extern FILE     *fd_spy;



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: trt_err_defaut
------------------

-Purpose:
This function launches the recording of the error in the history (via an other function) and write the containt of the history in the error file. 
-Prototype:
int trt_err_defaut(err);
-Parameters:
Erreur *err: error .
-UsesVariables:
historique_err The error history table.
Pt_synchro
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
-Return:
OK or ERROR.

;;#f#<*********************************************************************/

int trt_err_defaut(err)

Erreur *err;
{

  if(OK==add_erreur_histo(0,err))
    {
      if(err->code<=ERR_CRIT_SUN) 
	{
	  message_spy(fd_spy,"\nCTRL ----> Erreur Critique");
	  write_histo(historique_err,&the_nb_err,fd_fich_err);
	  if(Pt_synchro!=NULL)
	    Pt_synchro[CTRL_ACTION]=ACTION_DIE;
	}
      if(err->code>ERR_CRIT_SUN)
	{
	  message_spy(fd_spy,"\nCTRL ----> Erreur non critique");
	  if(ERROR==write_histo(historique_err,&the_nb_err,fd_fich_err))
	    Pt_synchro[CTRL_ACTION]=ACTION_DIE; 
	}
      return(OK);
    }
  else
    return(ERROR);
}



/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: trt_err_init
------------------
-Purpose:
This function launches the recording of the error in the history (via an other function) and write the containt of the history in the error file. The difference with the previous function (trt_err_default) is that here Pt_synchro is not used. 
-Prototype:
int trt_err_init(err);

-Parameters:
Erreur	*err: error .
-UsesVariables:
historique_err The error history table.
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
-Return:
OK or ERROR.

;;#f#<*********************************************************************/

int trt_err_init(err)

Erreur	*err;
{

  if(OK==add_erreur_histo(0,err))
    {
      write_histo(historique_err,&the_nb_err,fd_fich_err);
      kill(getpgrp,SIGUSR1);
      _exit(0);
    }
  else
    return(ERROR);

  return(OK);
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: warn_decode_enrg
------------------

-Purpose:
Alert the user and start the decoding of the acquisition parameters file.

-Prototype:
	int warn_decode_enrg(err)
-Parameters:
	Erreur *err: error.
-UsesVariables:
historique_err The error history table.
Pt_synchro
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
-Comments:
Write in the history.
-Return:
OK or ERROR.

;;#f#<*********************************************************************/

int warn_decode_enrg(err)

Erreur *err;
{
  if(OK==add_erreur_histo(0,err))
    {
      if(ERROR==write_histo(historique_err,&the_nb_err,fd_fich_err))
	return(ERROR);
      
      Pt_synchro[VISU_ACTION]=ACTION_DECODE;
      Pt_synchro[ENRG_ACTION]=ACTION_ENRG;
    }
  else
    return(ERROR);
  
  return(OK);
}


/*********************************************************************;;#f#>
------------------
HEAD_OF_FUNCTION: warn_defaut
------------------

-Purpose:
Just Warn the user. The only difference with the previous function (warn_decode_enrg) is that her Pt_synchro is not used.

-Prototype:
	int warn_defaut(err);
-Parameters:
	Erreur *err: error.
-UsesVariables:
historique_err The error history table.
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
-Comments:
Write in the history.
-Return:
OK or ERROR.

;;#f#<*********************************************************************/

int warn_defaut(err)

Erreur *err;
{
  if(OK==add_erreur_histo(0,err))
    {
      if(ERROR==write_histo(historique_err,&the_nb_err,fd_fich_err))
	return(ERROR);
    }
  else
    return(ERROR);
  
  return(OK);
}
