h13591
s 00004/00005/00211
d D 1.9 98/07/24 17:09:26 chris 10 9
c correction du bug qui provoquait le plantage lors
c de 2 cmdsun 3 successifs qui retournait une erreur
e
s 00000/00000/00216
d D 1.8 98/03/12 16:55:26 chris 9 8
c version 41
e
s 00039/00005/00177
d D 1.7 98/02/19 12:02:52 tof 8 7
c mise a jour des commentaires et "copie"
e
s 00046/00062/00136
d D 1.6 98/01/13 13:24:12 tof 7 6
c mise a jour des comments.
e
s 00016/00062/00182
d D 1.5 98/01/12 17:07:01 chris 6 5
c rien de particulier...
e
s 00000/00000/00244
d D 1.4 97/08/21 15:42:20 chris 5 4
c avant modif version 3
e
s 00000/00000/00244
d D 1.3 96/12/10 17:28:57 chris 4 3
c modif du makefile nulle
e
s 00002/00001/00242
d D 1.2 96/11/28 18:37:29 devel 3 1
c Introduction de SID pour sccs et mise a jour concernant
c le nouveau repertoire /export/home/devel/
e
s 00000/00000/00000
d R 1.2 96/11/28 11:51:22 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/erreurs/fonc_trt.c
e
s 00243/00000/00000
d D 1.1 96/11/28 11:51:21 devel 1 0
c date and time created 96/11/28 11:51:21 by devel
e
u
U
f e 0
t
T
I 1
D 3
static char *SccsId="%w% %g%";
E 3
I 3
D 6
static char *SccsId="%W% %G%";
E 6
I 6
static char *SccsId="@(#)fonc_trt.c	1.2 21 Aug 1997";
E 6

E 3
D 7
/*;+********************************************************************
E 7
I 7
/*********************************************************************;;#h#>
E 7
-----------------
D 7
ENTETE DE FICHIER	:fonc_trt.c
E 7
I 7
HEAD_OF_FILE: fonc_trt.c
E 7
-----------------
D 7
-Auteur(s):Christian miguel (10/8/95)
E 7
I 7
-Authors:Christian miguel (10/8/95)
E 7
D 6
-Rle:
Ce fichier regroupe les fonctions de traitement des erreurs pour le mode d'acquisition Stockesmtre. Lorsqu'une erreur apparat, elle est redige vers sa fonction de traitement qui lance les action ncessaires.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
E 6
I 6

I 8
-Library: erreurs.a

-Purpose:

Here are defined all the functions which will be used to resolve an error. They  will be stored in the table aiguillage_err[NB_ERR] (defined in trt_err.c).


E 8
I 7
-Functions:
E 7
E 6
		trt_err_defaut
		trt_err_init
		warn_decode_enrg
		warn_defaut
D 7
-Commentaires:
E 7
D 8

E 8
I 8
-Keywords:
error.
E 8
D 7
********************************************************************;-*/
E 7
I 7
;;#h#<*********************************************************************/
E 7

#include	<stdio.h>
#include	<sys/signal.h>
#include	<sys/types.h>
#include	<unistd.h>

#include	<sun.h>
#include	<enrg.h>
#include	<process.h>
#include	<the_errno.h>

extern		long	*Pt_synchro;
extern 		int	the_nb_err;
extern		Erreur	*historique_err;
extern 		Erreur	the_errno;
extern int	tab_pid[NB_PROC];
extern FILE     *fd_fich_err;
I 10
extern FILE     *fd_spy;
E 10

D 8
Fonc_trt	aiguillage_err[NB_ERR];
E 8


D 7
/*++********************************************************************
E 7
I 7
/*********************************************************************;;#f#>
E 7
------------------
D 7
ENTETE DE FONCTION	:trt_err_defaut
E 7
I 7
HEAD_OF_FUNCTION: trt_err_defaut
E 7
------------------

D 7
-Rle:
Cette fonction lance la fonction d'enregistrement dans l'historique, et crit dans le fichier d'erreurs le contenu de l'historique.
E 7
I 7
-Purpose:
D 8
This function launches the recording of the history (via an other function) and write the containt of the history in the error file. 
E 8
I 8
This function launches the recording of the error in the history (via an other function) and write the containt of the history in the error file. 
E 8
-Prototype:
int trt_err_defaut(err);
-Parameters:
Erreur *err: error .
I 8
-UsesVariables:
historique_err The error history table.
Pt_synchro
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
E 8
-Return:
OK or ERROR.
E 7
D 6
-inclure:
-Prototype:
	int trt_err_defaut(err);
-Paramtres:
	Erreur *err;
-Variables globales utilises
	Internes au fichier:
	Importes:
E 6

D 6
-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

E 6
D 7
-Exemple:
-Commentaires:
********************************************************************--*/
E 7
I 7
;;#f#<*********************************************************************/
E 7

int trt_err_defaut(err)

Erreur *err;
{

  if(OK==add_erreur_histo(0,err))
    {
      if(err->code<=ERR_CRIT_SUN) 
	{
I 10
	  message_spy(fd_spy,"\nCTRL ----> Erreur Critique");
E 10
	  write_histo(historique_err,&the_nb_err,fd_fich_err);
	  if(Pt_synchro!=NULL)
	    Pt_synchro[CTRL_ACTION]=ACTION_DIE;
	}
      if(err->code>ERR_CRIT_SUN)
	{
I 10
	  message_spy(fd_spy,"\nCTRL ----> Erreur non critique");
E 10
	  if(ERROR==write_histo(historique_err,&the_nb_err,fd_fich_err))
D 10
	    Pt_synchro[CTRL_ACTION]=ACTION_DIE;
	  
D 6
	  Pt_synchro[ENRG_ACTION]=ACTION_WAIT;
E 6
I 6
/*	  Pt_synchro[ENRG_ACTION]=ACTION_WAIT;
E 6
	  Pt_synchro[VISU_ACTION]=ACTION_WAIT;
I 6
*/
E 10
I 10
	    Pt_synchro[CTRL_ACTION]=ACTION_DIE; 
E 10
E 6
	}
      return(OK);
    }
  else
    return(ERROR);
}



D 7
/*++********************************************************************
E 7
I 7
/*********************************************************************;;#f#>
E 7
------------------
D 7
ENTETE DE FONCTION	:trt_err_init
E 7
I 7
HEAD_OF_FUNCTION: trt_err_init
E 7
------------------
I 8
-Purpose:
This function launches the recording of the error in the history (via an other function) and write the containt of the history in the error file. The difference with the previous function (trt_err_default) is that here Pt_synchro is not used. 
E 8
I 7
-Prototype:
E 7
D 8

E 8
I 7
int trt_err_init(err);
E 7
D 6
-Rle:
-inclure:
-Prototype:
	int trt_err_init(err)
-Paramtres:
	Erreur *err;
-Variables globales utilises
	Internes au fichier:
	Importes:
E 6

I 7
-Parameters:
Erreur	*err: error .
I 8
-UsesVariables:
historique_err The error history table.
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
E 8
-Return:
OK or ERROR.
E 7
D 6
-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:
E 6

D 6
-Exemple:
-Commentaires:
E 6
D 7
********************************************************************--*/
E 7
I 7
;;#f#<*********************************************************************/
E 7

int trt_err_init(err)

D 6
     Erreur	*err;
E 6
I 6
Erreur	*err;
E 6
{

D 6
	if(OK==add_erreur_histo(0,err))
	{
		write_histo(historique_err,&the_nb_err,fd_fich_err);
		kill(getpgrp,SIGUSR1);
		_exit(0);
	}
	else
		return(ERROR);
E 6
I 6
  if(OK==add_erreur_histo(0,err))
    {
      write_histo(historique_err,&the_nb_err,fd_fich_err);
      kill(getpgrp,SIGUSR1);
      _exit(0);
    }
  else
    return(ERROR);
E 6

D 6
	return(OK);
E 6
I 6
  return(OK);
E 6
}


D 7
/*++********************************************************************
E 7
I 7
/*********************************************************************;;#f#>
E 7
------------------
D 7
ENTETE DE FONCTION	:warn_decode_enrg
E 7
I 7
HEAD_OF_FUNCTION: warn_decode_enrg
E 7
------------------

D 7
-Rle:
Effectue un traitement qui consiste juste  prvenir l'utilisateur et lance le dcodage du fichier de paramtres d'acquisition.
-inclure:
E 7
I 7
-Purpose:
Alert the user and start the decoding of the acquisition parameters file.

E 7
-Prototype:
	int warn_decode_enrg(err)
D 7
-Paramtres:
	Erreur *err;
-Variables globales utilises
	Internes au fichier:
	Importes:
E 7
I 7
-Parameters:
	Erreur *err: error.
I 8
-UsesVariables:
historique_err The error history table.
Pt_synchro
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
-Comments:
Write in the history.
E 8
-Return:
OK or ERROR.
E 7

D 7
-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:
E 7
I 7
;;#f#<*********************************************************************/
E 7

D 7
-Exemple:
-Commentaires:
********************************************************************--*/

E 7
int warn_decode_enrg(err)

D 6
     Erreur *err;
E 6
I 6
Erreur *err;
E 6
{
  if(OK==add_erreur_histo(0,err))
    {
      if(ERROR==write_histo(historique_err,&the_nb_err,fd_fich_err))
	return(ERROR);
      
      Pt_synchro[VISU_ACTION]=ACTION_DECODE;
      Pt_synchro[ENRG_ACTION]=ACTION_ENRG;
    }
  else
    return(ERROR);
  
  return(OK);
}


D 7
/*++********************************************************************
E 7
I 7
/*********************************************************************;;#f#>
E 7
------------------
D 7
ENTETE DE FONCTION	:warn_defaut
E 7
I 7
HEAD_OF_FUNCTION: warn_defaut
E 7
------------------

D 7
-Rle:
Effectue un traitement qui consiste juste  prvenir l'utilisateur.
-inclure:
E 7
I 7
-Purpose:
D 8
Just Warn the user.
E 8
I 8
Just Warn the user. The only difference with the previous function (warn_decode_enrg) is that her Pt_synchro is not used.
E 8

E 7
-Prototype:
D 7
	int warn_defaut(err)
-Paramtres:
	Erreur *err;
-Variables globales utilises
	Internes au fichier:
	Importes:
E 7
I 7
	int warn_defaut(err);
-Parameters:
	Erreur *err: error.
I 8
-UsesVariables:
historique_err The error history table.
-UsesFunctions:
write_histo (trt_err.c)
add_erreur_histo (util_err.c)
-Comments:
Write in the history.
E 8
-Return:
OK or ERROR.
E 7

D 7
-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/
E 7
I 7
;;#f#<*********************************************************************/
E 7

int warn_defaut(err)

D 6
     Erreur *err;
E 6
I 6
Erreur *err;
E 6
{
  if(OK==add_erreur_histo(0,err))
    {
      if(ERROR==write_histo(historique_err,&the_nb_err,fd_fich_err))
	return(ERROR);
    }
  else
    return(ERROR);
  
  return(OK);
}
E 1
