
static char *SccsId="@(#)Sun-client.c	1.5 03/11/98";

/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:Sun-client.c
-----------------
-Auteur(s):
	Christian Miguel
-Rle:
	Ce fichier regroupe les fonctions rseau SUN lorsqu'il est client
	du VME serveur. Les fonctions sont faites par rpcgen.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		alloc_mem
		adresse_tb_point
		libere_mem
		init_acq
		exit_acq
	 
-Commentaires:
	Les fonctions dfinies ici appellent leur homologue par rseau 
	dans le VME. Les couples de fonctions qu'elles forment portent des
	noms identiques pour faciliter l'utilisation.
********************************************************************;-*/


#include <stdio.h>

#include <sys/types.h>
#include <sys/file.h>
#include <rpc/rpc.h>

#include	<sun.h>
#include	<acq.h>
#include	<Vme-serv.h>
#include	<Sun-client.h>
#include	<the_errno.h>

/*++********************************************************************
------------------
ENTETE DE FONCTION	:alloc_mem
------------------

-Rle:
	alloue la mmoire du VME comme celle-ci faisait partie de la mmoire
	de la SUN.

-inclure:
	Vme-alloc.h pour les tailles mmoire prdfinies de zone de donnes
-Prototype:
	int alloc_vme(u_long taille_data)
-Paramtres:
	taille_data: la taille  rserver pour les donnes dans la mmoire VME.
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	Le code d'erreur 0 si tout va bien.

-Constantes utilises
	Internes au fichier:
	Importes:
		MACHINE_VME		(Sun-client.h)
		SERV_INIT		(Vme-serv.h)
		VERS_SERV_INIT		(Vme-serv.h)
		
	
-Fonctions utilises
	Internes au fichier:
	Importes:
		alloc_mem_1	(Vme-serv_clnt.c)

-Exemple:
-Commentaires:
********************************************************************--*/

int alloc_mem(taille_data)
u_long taille_data;
{
CLIENT *clnt;
int *rep;

	clnt=clnt_create(MACHINE_VME,SERV_INIT,VERS_SERV_INIT,"tcp");

	if(clnt==NULL)
	{
		clnt_pcreateerror(MACHINE_VME);
		return(ERROR);
	}
 	
	rep=alloc_mem_1(&taille_data,clnt);

	if(*rep==0)
		return(-2);	
	
	clnt_destroy(clnt);
	return(*rep);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:adresse_tb_point
------------------

-Rle:
-inclure:
-Prototype:
	u_long adresse_tb_point()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
	retourne l'adresse de la table des pointeurs dans la VME.
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		MACHINE_VME		(Sun-client.h)
		SERV_INIT		(Vme-serv.h)
		VERS_SERV_INIT		(Vme-serv.h)

	
-Fonctions utilises
	Internes au fichier:
	Importes:
		adresse_tb_point_1	(Vme-serv_clnt.c)

-Exemple:
-Commentaires:
********************************************************************--*/



u_long adresse_tb_point()
{
CLIENT *clnt;
u_long	*adresse;


	clnt=clnt_create(MACHINE_VME,SERV_INIT,VERS_SERV_INIT,"tcp");

	if(clnt==NULL)
	{
		clnt_pcreateerror(MACHINE_VME);
		return(-1);
	}
 	
	adresse=adresse_tb_point_1(NULL,clnt);

	if(*adresse==0)
		return(-2);	
	
	clnt_destroy(clnt);
	return(*adresse);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:libere_mem
------------------

-Rle:
	Cette fonction libre la mmoire du VME par un appel rseau.
-inclure:
-Prototype:
	int libere_mem()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		MACHINE_VME		(Sun-client.h)
		SERV_INIT		(Vme-serv.h)
		VERS_SERV_INIT		(Vme-serv.h)

-Fonctions utilises
	Internes au fichier:
	Importes:
		libere_mem_1

-Exemple:
-Commentaires:
********************************************************************--*/



int libere_mem()
{
CLIENT *clnt;
int *rep;

	clnt=clnt_create(MACHINE_VME,SERV_INIT,VERS_SERV_INIT,"tcp");

	if(clnt==NULL)
	{
		clnt_pcreateerror(MACHINE_VME);
		return(-1);
	}
 	
	rep=libere_mem_1(NULL,clnt);

	if(*rep==0)
		return(-2);	
	
	clnt_destroy(clnt);
	return(*rep);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:init_acq
------------------

-Rle:
	Cette fonction libre la mmoire du VME par un appel rseau.
-inclure:
	Sun-client.h
	Vme-serv.h
-Prototype:
	int init_acq()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		MACHINE_VME		(Sun-client.h)
		SERV_INIT		(Vme-serv.h)
		VERS_SERV_INIT		(Vme-serv.h)

-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/



int init_acq()
{
CLIENT *clnt;
int *rep;
int desc_pont;

	desc_pont=open_driver_pont();

	if (flock(desc_pont,LOCK_EX|LOCK_NB)==-1)
	{
		close_driver_pont();
		return(-2);
	}
	else
	{
		flock(desc_pont,LOCK_UN);
		close_driver_pont();
	}

	clnt=clnt_create(MACHINE_VME,SERV_INIT,VERS_SERV_INIT,"tcp");

	if(clnt==NULL)
	{
		clnt_pcreateerror(MACHINE_VME);
		return(-1);
	}
 	
	rep=init_acq_1(NULL,clnt);

	if(*rep==0)
		return(-2);	
	
	clnt_destroy(clnt);
	return(*rep);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:exit_acq
------------------

-Rle:
	Cette fonction place le VME dans son tat initial par un appel rseau.
	On libre la mmoire etc...
-inclure:
	Sun-client.h
	Vme-serv.h
-Prototype:
	int exit_acq()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
		MACHINE_VME		(Sun-client.h)
		SERV_INIT		(Vme-serv.h)
		VERS_SERV_INIT		(Vme-serv.h)

-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/



int exit_acq()
{
CLIENT *clnt;
int *rep;

	clnt=clnt_create(MACHINE_VME,SERV_INIT,VERS_SERV_INIT,"tcp");

	if(clnt==NULL)
	{
		clnt_pcreateerror(MACHINE_VME);
		return(-1);
	}
 	
	rep=exit_acq_1(NULL,clnt);

	if(*rep==0)
		return(-2);	
	
	clnt_destroy(clnt);
	return(*rep);
}

