/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "def.h"
#include <stdio.h>
#include <stdlib.h> /* getenv, exit */
#include <signal.h>
#include <sys/types.h>
#include <memory.h>
#include <stropts.h>
#include <netconfig.h>
#include <sys/resource.h> /* rlimit */
#include <syslog.h>

#ifdef DEBUG
#define	RPC_SVC_FG
#endif

#define	_RPCSVC_CLOSEDOWN 120
static int _rpcpmstart;		/* Started by a port monitor ? */

/* States a server can be in wrt request */

#define	_IDLE 0
#define	_SERVED 1

static int _rpcsvcstate = _IDLE;	/* Set when a request is serviced */
static int _rpcsvccount = 0;		/* Number of requests being serviced */

static
void _msgout(msg)
	char *msg;
{
#ifdef RPC_SVC_FG
	if (_rpcpmstart)
		syslog(LOG_ERR, msg);
	else
		(void) fprintf(stderr, "%s\n", msg);
#else
	syslog(LOG_ERR, msg);
#endif
}

static void
closedown(sig)
	int sig;
{
	if (_rpcsvcstate == _IDLE && _rpcsvccount == 0) {
		extern fd_set svc_fdset;
		static int size;
		int i, openfd;
		struct t_info tinfo;

		if (!t_getinfo(0, &tinfo) && (tinfo.servtype == T_CLTS))
			exit(0);
		if (size == 0) {
			struct rlimit rl;

			rl.rlim_max = 0;
			getrlimit(RLIMIT_NOFILE, &rl);
			if ((size = rl.rlim_max) == 0) {
				return;
			}
		}
		for (i = 0, openfd = 0; i < size && openfd < 2; i++)
			if (FD_ISSET(i, &svc_fdset))
				openfd++;
		if (openfd <= 1)
			exit(0);
	} else
		_rpcsvcstate = _IDLE;

	(void) signal(SIGALRM, (void(*)()) closedown);
	(void) alarm(_RPCSVC_CLOSEDOWN/2);
}

static void
prog_vme_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		INTERFACE_2 intf_wr_timer_1_arg;
		INTERFACE_3 time_lect_1_arg;
		INTERFACE_4 lect_obt_1_arg;
		INTERFACE_5 cmde_obt_1_arg;
		INTERFACE_6 affect_obt_1_arg;
		INTERFACE_7 affect_theta_1_arg;
		INTERFACE_8 lect_stat_cam_1_arg;
		INTERFACE_9 start_acq_1_arg;
		INTERFACE_12 init_cam_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	_rpcsvccount++;
	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void,
			(char *)NULL);
		_rpcsvccount--;
		_rpcsvcstate = _SERVED;
		return;

	case INTF_INIT:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) intf_init_1;
		break;

	case INTF_WR_TIMER:
		xdr_argument = xdr_INTERFACE_2;
		xdr_result = xdr_int;
		local = (char *(*)()) intf_wr_timer_1;
		break;

	case TIME_LECT:
		xdr_argument = xdr_INTERFACE_3;
		xdr_result = xdr_INTERFACE_3_OUT;
		local = (char *(*)()) time_lect_1;
		break;

	case LECT_OBT:
		xdr_argument = xdr_INTERFACE_4;
		xdr_result = xdr_INTERFACE_4_OUT;
		local = (char *(*)()) lect_obt_1;
		break;

	case CMDE_OBT:
		xdr_argument = xdr_INTERFACE_5;
		xdr_result = xdr_int;
		local = (char *(*)()) cmde_obt_1;
		break;

	case AFFECT_OBT:
		xdr_argument = xdr_INTERFACE_6;
		xdr_result = xdr_int;
		local = (char *(*)()) affect_obt_1;
		break;

	case AFFECT_THETA:
		xdr_argument = xdr_INTERFACE_7;
		xdr_result = xdr_int;
		local = (char *(*)()) affect_theta_1;
		break;

	case LECT_STAT_CAM:
		xdr_argument = xdr_INTERFACE_8;
		xdr_result = xdr_INTERFACE_8_OUT;
		local = (char *(*)()) lect_stat_cam_1;
		break;

	case START_ACQ:
		xdr_argument = xdr_INTERFACE_9;
		xdr_result = xdr_int;
		local = (char *(*)()) start_acq_1;
		break;

	case STOP_ACQ:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) stop_acq_1;
		break;

	case START_LECT:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) start_lect_1;
		break;

	case INIT_CAM:
		xdr_argument = xdr_INTERFACE_12;
		xdr_result = xdr_int;
		local = (char *(*)()) init_cam_1;
		break;

	default:
		svcerr_noproc(transp);
		_rpcsvccount--;
		_rpcsvcstate = _SERVED;
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		_rpcsvccount--;
		_rpcsvcstate = _SERVED;
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		_msgout("unable to free arguments");
		exit(1);
	}
	_rpcsvccount--;
	_rpcsvcstate = _SERVED;
	return;
}

main()
{
	pid_t pid;
	int i;
	char mname[FMNAMESZ + 1];

	(void) sigset(SIGPIPE, SIG_IGN);

	if (!ioctl(0, I_LOOK, mname) &&
		(!strcmp(mname, "sockmod") || !strcmp(mname, "timod"))) {
		char *netid;
		struct netconfig *nconf = NULL;
		SVCXPRT *transp;
		int pmclose;

		_rpcpmstart = 1;
		openlog("def", LOG_PID, LOG_DAEMON);

		if ((netid = getenv("NLSPROVIDER")) == NULL) {
		/* started from inetd */
			pmclose = 1;
		} else {
			if ((nconf = getnetconfigent(netid)) == NULL)
				_msgout("cannot get transport info");

			pmclose = (t_getstate(0) != T_DATAXFER);
		}
		if (strcmp(mname, "sockmod") == 0) {
			if (ioctl(0, I_POP, 0) || ioctl(0, I_PUSH, "timod")) {
				_msgout("could not get the right module");
				exit(1);
			}
		}
		if ((transp = svc_tli_create(0, nconf, NULL, 0, 0)) == NULL) {
			_msgout("cannot create server handle");
			exit(1);
		}
		if (nconf)
			freenetconfigent(nconf);
		if (!svc_reg(transp, PROG_VME, VERS_VME, prog_vme_1, 0)) {
			_msgout("unable to register (PROG_VME, VERS_VME).");
			exit(1);
		}
		if (pmclose) {
			(void) signal(SIGALRM, (void(*)()) closedown);
			(void) alarm(_RPCSVC_CLOSEDOWN/2);
		}
		svc_run();
		exit(1);
		/* NOTREACHED */
	}	else {
#ifndef RPC_SVC_FG
		int size;
		struct rlimit rl;
		pid = fork();
		if (pid < 0) {
			perror("cannot fork");
			exit(1);
		}
		if (pid)
			exit(0);
		rl.rlim_max = 0;
		getrlimit(RLIMIT_NOFILE, &rl);
		if ((size = rl.rlim_max) == 0)
			exit(1);
		for (i = 0; i < size; i++)
			(void) close(i);
		i = open("/dev/console", 2);
		(void) dup2(i, 1);
		(void) dup2(i, 2);
		setsid();
		openlog("def", LOG_PID, LOG_DAEMON);
#endif
	}
	if (!svc_create(prog_vme_1, PROG_VME, VERS_VME, "netpath")) {
		_msgout("unable to create (PROG_VME, VERS_VME) for netpath.");
		exit(1);
	}

	svc_run();
	_msgout("svc_run returned");
	exit(1);
	/* NOTREACHED */
}
