h36775
s 00000/00000/00881
d D 1.7 98/03/11 17:26:54 chris 8 7
c 
e
s 00000/00000/00881
d D 1.6 98/03/11 17:25:50 tof 7 6
c 
e
s 00000/00000/00881
d D 1.5 98/03/11 17:24:07 chris 6 5
c 
e
s 00000/00000/00881
d D 1.4 97/08/27 22:35:08 chris 5 4
c fst
e
s 00000/00000/00881
d D 1.3 96/12/10 16:30:04 chris 4 3
c modif de rien du tout 
e
s 00002/00001/00879
d D 1.2 96/11/28 18:29:10 devel 3 1
c Introduction de SID pour sccs et mise a jour concernant
c le nouveau repertoire /export/home/devel
e
s 00000/00000/00000
d R 1.2 96/11/28 11:41:58 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 1 0 sun/src/client-rao/lclient.c
e
s 00880/00000/00000
d D 1.1 96/11/28 11:41:57 devel 1 0
c date and time created 96/11/28 11:41:57 by devel
e
u
U
f e 0
t
T
I 1

D 3
static char *SccsId="%w% %g%";
E 3
I 3
static char *SccsId="%W% %G%";

E 3
/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:lclient.c
-----------------
-Auteur(s):Christian Miguel, Stagiaires Efrei
-Rle:
Regroupe des fonctions permettant d'utiliser les fonctions VME  partir de la station SUN THEMIS.
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
		intf_init
		intf_wr_timer
		time_lect
		init_cam
		lect_obt
		cmde_obt
		affect_obt
		affect_theta
		lect_stat_cam
		start_acq
		stop_acq
		start_lect
	 
-Commentaires:
Toutes ces fonctions existent sur le VME, celles-ci pour une transparence dans l'utilisation portent le m. L'utilisation d'une fonction de ce fichier fait appel  d'autres fonctions (rseau plus bas niveau) pour enfin appeler la fonction de mme nom sur le VME.
********************************************************************;-*/


#include <rpc/rpc.h>
#include <sun.h> 
#include "def.h"
#include <Sun-clt.h>
#include <the_errno.h>


#define SERVEUR MACHINE_VME 

void _clnt_perror(clnt, str)
	CLIENT         *clnt;
	char           *str;
{

}
 
extern	Erreur the_errno;

/*++********************************************************************
------------------
ENTETE DE FONCTION	:intf_init
------------------

-Rle:
	Initialise la carte interface des cartes camra
-inclure:
-Prototype:
	int intf_init()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int intf_init()
{
	CLIENT         *c1;		/* Appel RPC */
	INTERFACE_1     interface;	/* Resultat  */
	int            *ret;

	/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;

	/* On Cree un client pour le serveur VME */
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}

	/* mise en forme des donnees pour appel RPC */
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */

	interface.empty_slot = 0;
	ret = (int *) intf_init_1(&interface, c1);
	if (ret == NULL) {
		_clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}

	/* destruction du handle */
	clnt_destroy(c1);
	return (*ret);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:intf_wr_timer
------------------

-Rle:
	Sais pas
-inclure:
-Prototype:
	int intf_wr_timer(timer_num, valeur)
-Paramtres:
	Byte            timer_num;
	U16             valeur;

-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
	C'est pas trs serieux ce commentaire
********************************************************************--*/


int intf_wr_timer(timer_num, valeur)
	Byte            timer_num;
	U16             valeur;
{
	CLIENT         *c1;		/* appel rpc */
	INTERFACE_2     interface;	/* resultat appel RPC */
	int            *ret;		/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;			/* Hera ? */

	/* Creation du client pour le serveur VME */
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}

	/* mise en forme des donnees pour appel RPC */
	interface.timer_num = timer_num;
	interface.valeur = valeur;

	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */
	ret = (int *) intf_wr_timer_1(&interface, c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}
	/* destruction du handle */
	clnt_destroy(c1);
	/* mise en forme des donnees recues en retour de RPC */

	return (*ret);
}

 
/*++********************************************************************
------------------
ENTETE DE FONCTION	:time_lect
------------------

-Rle:
-inclure:
-Prototype:
	int time_lect(temps)
-Paramtres:
	long           *temps;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int time_lect(temps)

long           *temps;
{
	CLIENT         *c1;
	/* appel rpc */
	INTERFACE_3     interface;
	/* resultat appel RPC */
	INTERFACE_3_OUT *ret;
	/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}
	/* mise en forme des donnees pour appel RPC */
	interface.temps = *temps;
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */
	ret = (INTERFACE_3_OUT *) time_lect_1(&interface, c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}
	/* destruction du handle */
	clnt_destroy(c1);
	/* mise en forme des donnees recues en retour de RPC */
	*temps = ret->temps;
	return (ret->out);

}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:init_cam
------------------

-Rle:
	initialise une carte de camra
-inclure:
-Prototype:
	int init_cam(no)
-Paramtres:
	Byte           no;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/



int init_cam(no)

Byte           no;
{
	CLIENT         *c1;
	/* appel rpc */
	INTERFACE_12     interface;
	/* mise en relation avec serveur */
	char           *host;
	int *ret;

	host = SERVEUR;
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}
	/* mise en forme des donnees pour appel RPC */
	interface.num = no;
	/* appel procedure distante par RPC */
	ret = (int *) init_cam_1(&interface,c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}
	/* destruction du handle */
	clnt_destroy(c1);
	/* mise en forme des donnees recues en retour de RPC */
	return (*ret);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:lect_obt
------------------

-Rle:
	sais pas
-inclure:
-Prototype:
	int lect_obt(num, flag)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int lect_obt(num, flag)

Byte            num;
Byte           *flag;
{
	CLIENT         *c1;
	/* appel rpc */
	INTERFACE_4     interface;
	/* resultat appel RPC */
	INTERFACE_4_OUT *ret;
	/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}
	/* mise en forme des donnees pour appel RPC */
	interface.num = num;
	interface.flag = *flag;
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */
	ret = (INTERFACE_4_OUT *) lect_obt_1(&interface, c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}
	/* destruction du handle */
	clnt_destroy(c1);
	/* mise en forme des donnees recues en retour de RPC */
	*flag = ret->flag;
	return (ret->out);

}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:cmde_obt
------------------

-Rle:
-inclure:
-Prototype:
	int cmde_obt(num, flag)
-Paramtres:
Byte            num;
Byte            flag;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int cmde_obt(num, flag)

Byte            num;
Byte            flag;
{
	CLIENT         *c1;
	/* appel rpc */
	INTERFACE_5     interface;
	/* resultat appel RPC */
	int            *ret;
	/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}
	/* mise en forme des donnees pour appel RPC */
	interface.num = num;
	interface.flag = flag;
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */
	ret = (int *) cmde_obt_1(&interface, c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}
	/* destruction du handle */
	clnt_destroy(c1);
	/* mise en forme des donnees recues en retour de RPC */
	return (*ret);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:affect_obt
------------------

-Rle:
-inclure:
-Prototype:
	int affect_obt(num_cam, num_obt)
-Paramtres:
	Byte            num_cam;
	Byte            num_obt;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int affect_obt(num_cam, num_obt)
	Byte            num_cam;
	Byte            num_obt;
{
	CLIENT         *c1;		/* appel rpc */
	INTERFACE_6     interface;	/* resultat appel RPC */
	int            *ret;		/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}

	/* mise en forme des donnees pour appel RPC */
	interface.num_cam = num_cam;
	interface.num_obt = num_obt;

	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */
	ret = (int *) affect_obt_1(&interface, c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}

	/* destruction du handle */
	clnt_destroy(c1);
	return (*ret);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:affect_theta
------------------

-Rle:
	Affecte une temprature  une camra
-inclure:
-Prototype:
	int affect_theta(num_cam, theta)
-Paramtres:
Byte            num_cam;
Byte            theta;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int affect_theta(num_cam, theta)
	
Byte            num_cam;
Byte            theta;
{
	CLIENT         *c1;		/* appel rpc */
	INTERFACE_7     interface;	/* resultat appel RPC */
	int            *ret;		/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}

	/* mise en forme des donnees pour appel RPC */
	interface.num_cam = num_cam;
	interface.theta = theta;

	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */
	ret = (int *) affect_theta_1(&interface, c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}

	/* destruction du handle */
	clnt_destroy(c1);
	return (*ret);
}

/*++********************************************************************
------------------
ENTETE DE FONCTION	:lect_stat_cam
------------------

-Rle:
-inclure:
-Prototype:
	int lect_stat_cam(num_cam, etat)
-Paramtres:
	Byte            num_cam;
	U16            *etat;
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int lect_stat_cam(num_cam, etat)
	Byte            num_cam;
	U16            *etat;
{
	CLIENT         *c1;		/* appel rpc */
	INTERFACE_8     interface;	/* resultat appel RPC */
	INTERFACE_8_OUT *ret;		/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}
	/* mise en forme des donnees pour appel RPC */
	interface.num_cam = num_cam;
	interface.etat = *etat;
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */
	ret = (INTERFACE_8_OUT *) lect_stat_cam_1(&interface, c1);
	if (ret == NULL) {
		clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}
	/* destruction du handle */
	clnt_destroy(c1);
	/* mise en forme des donnees recues en retour de RPC */
	*etat = ret->etat;
	return (ret->out);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:start_acq
------------------

-Rle:
	Lance une acquisition sur le vme
-inclure:
-Prototype:
	int start_acq(Bool)
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int start_acq(Bool)

int Bool;
{
	CLIENT         *c1;		/* Appel RPC */
	INTERFACE_9    interface;	/* Resultat  */
	int            *ret;

	/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;

	/* On Cree un client pour le serveur VME */
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}

	/* mise en forme des donnees pour appel RPC */
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */

	interface.Bool = Bool;
	ret = (int *) start_acq_1(&interface, c1);
	if (ret == NULL) {
		_clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}

	/* destruction du handle */
	clnt_destroy(c1);
	return (*ret);
}


/*++********************************************************************
------------------
ENTETE DE FONCTION	:stop_acq
------------------

-Rle:
-inclure:
-Prototype:
	int stop_acq()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int stop_acq()
{
	CLIENT         *c1;		/* Appel RPC */
	INTERFACE_10   interface;	/* Resultat  */
	int            *ret;

	/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;

	/* On Cree un client pour le serveur VME */
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}

	/* mise en forme des donnees pour appel RPC */
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */

	interface.empty_slot = 0;
	ret = (int *) stop_acq_1(&interface, c1);
	if (ret == NULL) {
		_clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}

	/* destruction du handle */
	clnt_destroy(c1);
	return (*ret);
}



/*++********************************************************************
------------------
ENTETE DE FONCTION	:start_lect
------------------

-Rle:
	lance la lecture des buffers des camras.
-inclure:
-Prototype:
	int start_lect()
-Paramtres:
-Variables globales utilises
	Internes au fichier:
	Importes:

-Retour:
-Description:
-Constantes utilises
	Internes au fichier:
	Importes:
	
-Fonctions utilises
	Internes au fichier:
	Importes:

-Exemple:
-Commentaires:
********************************************************************--*/


int start_lect()
{
	CLIENT         *c1;		/* Appel RPC */
	INTERFACE_11   interface;	/* Resultat  */
	int            *ret;

	/* mise en relation avec serveur */
	char           *host;

	host = SERVEUR;

	/* On Cree un client pour le serveur VME */
	c1 = clnt_create(SERVEUR, PROG_VME, VERS_VME, "tcp");
	
	if (c1 == NULL) {
		clnt_pcreateerror(host);
		return (ERROR);
	}

	/* mise en forme des donnees pour appel RPC */
	/* appel procedure distante par RPC */
	/*
	 * noter : on renvoie un pointeur; on passe une structure qui
	 * contient la liste des params et un descripteur RPC
	 */

	interface.empty_slot = 0;
	ret = (int *) start_lect_1(&interface, c1);
	if (ret == NULL) {
		_clnt_perror(c1, "erreur appel procedure distante");
		return (ERROR);
	}

	/* destruction du handle */
	clnt_destroy(c1);
	return (*ret);
}
E 1
