/*
 *			envoi_sock.c
 *
 * objet :	envoi d'une commande par socket a un serveur
 * auteur :	Jrome Minec
 * date :       24-03-2000
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#include "../sock2/comm.h"

/* extern int sock_vme; */

int lance_socket(serveur, port)
char * serveur;
int port;
{
  int sock;
  struct sockaddr_in adr;
  struct hostent *hp;

  if ( (hp = gethostbyname( serveur )) == NULL ) {
    perror("nom de machine inconnu"); exit(3);
  }

  memset(&adr, 0, sizeof(adr));
  if((sock = socket( AF_INET, SOCK_STREAM, 0)) == -1) {
    perror("cration de la socket"); exit(2);
  }
  adr.sin_family = AF_INET;
  adr.sin_port = htons(port);
  memcpy( &adr.sin_addr, hp->h_addr, hp->h_length);
  
  if(connect(sock, (struct sockaddr *)&adr, sizeof(adr)) == -1) {
    perror("connect"); exit(4);
  }

  return sock;
}

u_long envoi_sock(cmde, serveur, port)
char * cmde;
char * serveur;
int port;
{
  int sock_vme;  
  int n;
  u_long res;
  char rep[LGREP] = "", msg[LGMSG] = "";

  /* initialisation de la socket */
  sock_vme = lance_socket(serveur, port); 

  /* envoi de la commande */
  sprintf(rep, "$%s\n\r", cmde);
  envoi(sock_vme, rep);

  /* reception : ack_cmd - attention : pas portable ("<" au lieu de ack_cmd) */
  rep[0] = 0;
  n = getnext(sock_vme, rep, msg); 
  while ( strncmp(msg, "<", 1) )
    {
      n = getnext(sock_vme, rep, msg);
    } 
  printf("(accus de reception)\n");

  /* reception : resultat ou ?ERR=... */
  n = getnext(sock_vme, rep, msg); 
  /* attention ici, on recupere un long seulement, pas un unsigned long */
  res = atol(msg);
  printf("rsultat='%s'=%ldd\n", msg, res);

  /* reception : fin_cmd - attention : pas portable (">" au lieu de fin_cmd) */
  while ( strncmp(msg, ">", 1) )
    {
      n = getnext(sock_vme, rep, msg);
    } 
  printf("(fin de commande)\n");
  
  envoi(sock_vme, fin_comm); 
  close(sock_vme); 

  return res;
}
