/*
 * xdr_supp.h - XDR routines for IDL internal structures.
 *
 *	$Id: xdr_supp.h,v 1.10 1995/01/03 04:04:27 ali Exp $
 */

/*
  Copyright (c) 1989-1995, Research Systems Inc.  All rights reserved.
  This software includes information which is proprietary to and a
  trade secret of Research Systems, Inc.  It is not to be disclosed
  to anyone outside of this organization. Reproduction by any means
  whatsoever is  prohibited without express written permission.
  */


#ifndef xdr_supp_IDL_DEF
#define xdr_supp_IDL_DEF


#ifdef VMS			/* Actually, this should be ANSI C, not VMS */
#include "sysvars.h"
#endif

#ifdef ultrix			/* This routine isnt defined in ultrix
				 but it's present in the library. */
bool_t xdr_u_char();
#endif

#ifdef MAC
#include "::xdr:xdr.h"
#endif

/*
 * Some (DEC) machines have problems with their XDR floating point
 * processing. Here we define the routines to use when xdr_float()
 * and xdr_double() would normally be appropriate.
 *
 * 4 August 1992 (Ali)
 * Amazingly, AUX 3.1 has problems with XDR float and double. This
 * is amazing because the Mac uses big endian IEEE floating point, which
 * is the XDR representation. The DE3100 solution is also appropriate for
 * the Mac.
*/


/* Mips Ultrix screws up float and double data */
#if defined(mips) || defined(AUX)
#define XDR_MIPS_HACK
#define XDR_FLOAT xdr_long
typedef long XDR_FLOAT_TYPE;
#define XDR_DOUBLE IDL_xdr_mips_double
#else
typedef float XDR_FLOAT_TYPE;
#endif


/* Vax Ultrix screws up floating 0.0 */
#if defined(vax) && defined(ultrix)
#define XDR_FLOAT IDL_xdr_vax_ultrix_float
#endif


#ifndef XDR_FLOAT		/* Machines with correct xdr_float() */
#define XDR_FLOAT xdr_float
#endif

#ifndef XDR_DOUBLE		/* Machines with correct xdr_double() */
#define XDR_DOUBLE xdr_double
#endif

/* On 64-bit systems, use xdr_int() instead of xdr_long() */
#ifdef LONG_NOT_32
#define XDR_LONG xdr_int
#else
#define XDR_LONG xdr_long
#endif


#endif				/* xdr_supp_IDL_DEF */
