
#ifndef _prec_visu_h
#define _prec_visu_h

#define NB_MAX_FEN_VISU		12

#define FILE_VISU "/tmp/visu.don"
#define FILE_UNIT_IDL           1

#ifndef _prec_acq_h
#include <acq.h>
#endif 

#define		IDL_PORT_STK	0x20500000
 
#define 	IDL_MAX_COL	4		/*nombre de caracteres max*/
#define		IDL_MAX_LIG	4
#define		IDL_MAX_FEN	2
#define		IDL_MAX_DATUM	8	  	/*min max dans les fenetres*/


#define 	WIN_TITLE	"camera "	/*titre d'un fenetre idl*/
#define 	MAX_CHAR_CMD	80		/*de char sur une commande idl*/
#define		WIN_COL_DFT	384
#define		WIN_LIG_DFT	288
#define         WIN_COL_SOL_E   512
#define         WIN_LIG_SOL_E   512



#define         IDL_IMAGE         1
#define         IDL_LIGNE         2
#define         IDL_COLONNE       3
#define         IDL_SOLEIL_ENTIER 4


#define         XSCR_SIZE       1024
#define         YSCR_SIZE       768

#define         XSCR_DELTA1     10
#define         XSCR_DELTA2     20
#define         YSCR_DELTA1     45


typedef struct tb_visu
{
long	 nbfen;		        /*nombre de fenetres a visualiser*/
long	 numfen[NB_MAX_FEN ];	/*numero des fenetres a visualiser*/
Coor_fen tab_fen[NB_MAX_FEN ];	/*taille et position des fen de donnees */ 

long     numcam_de_donnee[NB_MAX_FEN]; 
                                /*numero de camera dont provient la donnee*/

long     numcam_de_fenvisu[NB_MAX_FEN_VISU];
                                /*numero de camera associee a la fenetre
				  de visualisation*/

long     status_de_fenvisu[NB_MAX_FEN_VISU];
                                /*status de la fenetre de visualisation
				    0 fenetre fermee
				    1 fenetre ouverte pour donnee image
				    2 fenetre ouverte pour donnee ligne
				    3 fenetre ouverte pour donnee colonne
				    4 fenetre ouverte pour soleil entier*/

long     modob;                         /* mode d'observation */   

long     color[NB_MAX_FEN_VISU];        /* couleur du dernier trace idl */

long	 minvi[NB_MAX_FEN_VISU];	/*niveau minimum dans fenetre visu*/
long	 maxvi[NB_MAX_FEN_VISU];	/*niveau maximum dans fenetre visu*/
}   Tb_visu;



#endif
