/*
	Ce fichier regroupe les codes d'erreurs du programme d'acquisition 
	de donnes THEMIS
	
	ATTENTION !!!
	Les codes erreurs du programme Stokesmtre sont dans erreur/err_stk.h
	Les codes du programme sur le VME dans erreur/err_vme.h
*/
/*
 *	06 JUIN 1996	Denis ZIG	
 *		Ajout de la constante PORT_ERR_SOL
 *		Ajout de la structure Err_sol
 */




#ifndef _prec_sun_h
#include <systime.h>
#endif

#ifdef _prec_sun_h
#include <sys/time.h>
#endif				

#ifndef _prec_acq_h
#include <acq.h>
#endif

#ifndef TAILLE_DATEFICH
#define TAILLE_DATEFICH 30
#endif



#ifndef _prec_th_errno_h
#define _prec_th_errno_h


/* struct d'un element de l'historique */

typedef struct erreur
{
int		code;		/*code de l'erreur*/
int		where;		/*provenance de l'erreur*/
char	        time[TAILLE_DATEFICH];
int		ctxt;		/* contexte */
int             numero;         /* ligne, fenetre, obtu... */
} Erreur;

typedef struct err_sol
{
  int	code;			/* code de l'erreur */
  int param_1;			/* parametre associe , eventuellement */
} Err_sol;

typedef int (* Fonc_trt)();





/******************** valeurs generales */

#ifdef _prec_sun_h		/* pour la sun */

#define	ERROR		-1
#define OK		0

int	trt_err_defaut();
int	trt_err_init();
int	warn_decode_enrg();
int	warn_defaut();

#endif				/* pour la sun */

#define PORT_ERR_SOL	5101
#define PORT_SERV_ERR	5103
#define ADR_SERV_ERR	"192.168.2.69"

#define NB_MAX_ERR	100
#define	NB_ERR_SYS	200
#define NB_ERR		300
#define TAILLE_MES	120

#ifdef _test

#define FILE_HISTO      "/data/pc/histo.err"
#define FILE_SPY        "/data/pc/multiraies.spy"

#endif


#ifndef _test
#define FILE_HISTO	"/data/pc/histo.err"
#endif

/*******************************************************************/
/* localisation des erreurs */

#define TAILLE_LOC	50

#define FIRST_GRP	4

#define NB_LOC		10

#define FICH_PARA	1
#define FICH_PAR_FIX    2
#define FICH_PAR_PHY    3
#define FICH_PAR_SEM    4
#define FICH_DON	5
#define FICH_ERR	6
#define FICH_OBS	7
#define FICH_CONF	8
#define FICH_VISU       9

#define NB_TYPE         11

#define PONT_BUS	1
#define PROC_SERV	2
#define INIT            3
#define FENETRES	4
#define CAMERAS		5
#define OBTURAT		6
#define ALALIGNE        7
#define NUMERO          8
#define FORMATAGE       9
#define MMOTCLE         10

/********************** Erreurs du VME */

#define ERR_SYS_VME	300
#define ERR_BASE_VME 	400		 /* debut des codes d'erreurs */
#define ERR_CRIT_VME	120+ERR_BASE_VME /*les premieres erreurs sont graves */

#include <erreur/err_vme.h>


/********************** Erreurs du SUN programme STK*/

#define ERR_BASE_STK	200	/* debut des codes d'erreurs */
 
#define ERR_CRIT_SUN	20+ERR_BASE_STK
#define ERR_WARNINGS	50+ERR_CRIT_SUN


#ifdef _prec_sun_h
#include <erreur/err_stk.h>
#endif





#endif	/*prec_the_errno_h */



