/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	TB_CTRL_CAM.H
-----------------
-Auteur(s): Denis Ziegler
-Role:	Definitions de la structure de controle de l'interface et des cameras
	tb_ctrl_cam placee en memoire commune VME-SUN
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
	 
-Commentaires:

********************************************************************;-*/


#ifndef _prec_tb_ctrl_cam_h
#define _prec_tb_ctrl_cam_h

#ifndef NB_MAX_CAM
#define NB_MAX_CAM 32
#endif

#define NO_FREEZE 255

/*
 * 		LA STRUCTURE CAM_REG
 * Image des registres de controle et etats de chaque camera THEMIS
 */
typedef struct cam_reg {
	long etat; /* registre d'etat des cameras */
	long n_obt; /* numero de l'obturateur affecte a la camera */
	long theta; /* consigne de temperature */
} Reg_cam;
/*
 * 		LA STRUCTURE TB_CTRL_CAM
 * Image des registres, timers de l'interface et registres des cameras 
 */
typedef struct tb_ctrl_cam {
	long cam_num; /* Numero de la camera selectionnee */
	long plan_num;/* Numero du plan memoire dans la camera*/
	long controle;/* registre de controle de l'interface*/
	long etat;    /* registre d'etat de l'interface*/
	long obturateur; /* registre de commande des obturateurs*/
	long go;/* registre de lancement des acquisitions (mode \
		automatique) */
	long integration; /* registre integrations (mode manuel) */
	long horloge; /* horloge de base des integrations */
	long watchdog; /* chien de garde des obturateurs */
	Reg_cam tab_reg_cam[NB_MAX_CAM]; /* Infos de chaque camera */
} Tb_ctrl_cam;

#endif /* _prec_tb_ctrl_cam_h */
