/*#include "../commun/str_blk.h"*/

/************entete necessaire pour les parties 3 et 4 ************/

/* Nombre de bandes  			*/
#define NOMBRE_BANDE 10

/* Hauteur en points d'une bande 	*/
#define HAUTEUR_BANDE 512

/* Pourcentage maximum de recouvrement 	*/
#define RECOUVREMENT 10

/* Deplacement maximum en X d'une bande (en points) */
#define DEPLACEMENTX 20

/* Deplacement maximum en Y d'une bande (en points) autour des RECOUVREMENT%*/
#define DEPLACEMENTY 20

/* Determine l'adresse d'un point de coordonees (X,Y) */
#define ad_point(bande,x,y) (bande.ADR+(bande.NCOL*(y)+(x)))

/* Definition : Module de definition des structures et constantes	     */
/* Historique : creation Sept 93, G & B                                      */

/* Type de codage des images THEMIS */
typedef short INT2;

typedef long INT4;

typedef double REEL;

/******************** Structure d'entete de bloc ********************/
struct STR_BLK 
	{
	 INT4 NIB;
	 INT4 NIF;
	 INT4 IDEN;
	 INT4 NFEN;
	};

/******************** Structure d'entete de fenetre ********************/
struct STR_FEN
	{
	 INT4 NUFEN;
	 INT4 NLI;
	 INT4 NCOL;
	 INT4 NVAL;
	};



/******les 2 structures suivantes sont utilisees pour lire les donnees de l'image **/


/******* Structure definissant la position d'un point en coordonnees cartesiennes *****/ 
struct POINT 
	{
	INT4 x,y;
	};

/******************** Structure definissant la position d'un rectangle  ***************/
struct RECT
	{
	struct POINT haut;	/* Point en haut a gauche	*/
	struct POINT bas;	/* Point en bas a droite	*/
	};



/**********structure uniquement utilisee dans la partie 3 *************/
/*********** Structure decrivant le recouvrement et le deplacement en X de chaque bande ***********/ 
struct DECOUP
	{
	INT4 dep[NOMBRE_BANDE];
	INT4 rec[NOMBRE_BANDE]; 
	};
/*************structure de bande************************************/
struct BANDE
	{
	INT4 NLI;	/* Nombre de lignes par bande	*/
	INT4 NCOL;	/* Nombre de colonnes par bande	*/
	INT2 *ADR;	/* Tableau contenant la bande	*/
	};
