

#ifndef _prec_param_h

#define _prec_param_h

#define	TAILLE_MCLE 		9

#define DECODE_FIN		1
#define TAILLE_LIGNE		80  
#define	TAILLE_INDIC		3
#define	TAILLE_VALU		21  /* longeur de la chaine pour un int etc..*/
#define TAILLE_SEPA             1   /* signe = */

#define NB_MCLE_SPE		29
#define NB_MCLE_SOL		50
#define NB_MCLE_FIX             15
#define NB_MCLE_PHY             65
#define NB_MCLE_SEM             10
#define NB_MCLE_DEPEND_FEN      15
#define NB_MCLE_TOUT		NB_MCLE_SPE+NB_MCLE_FIX+NB_MCLE_PHY+NB_MCLE_SEM-3	/* 4 fois 'END' */

#define DEBUT_VAL		 9
#define POS_CHAR                29

#define EMPTY                   "EMP\0"



#define SENS_LIG		1	/* sens de lecture de la camera */
#define SENS_COL		0


#define SIMPLE 0     /*definition des modes du cadenceur */
#define CADENCEUR 2
#define CONTINU 4

#define		MODE_RAO	0
#define		MODE_SOL	1
#define		MODE_STK	2
#define		MODE_TRT	3
#define		MODE_REGL_SE	4
#define         MODE_OBSCU      5

#define         FITS0           0
#define         FITS1           1
#define         FITS2           2
#define         FITS3           3

#define         NAXIS_MAX       6


#ifndef _test
#define FILE_RAO_PAR	"/the/pc/paracq.don"
#define FILE_RAO_PHY    "/the/pc/paracq.phy"
#define FILE_RAO_SEM    "/the/pc/paracq.sem"
#define FILE_RAO_FIX    "/the/pc/paracq.fix"
#endif

#ifdef _test
#define FILE_RAO_PAR	"/the/pc/paracq.don"
#define FILE_RAO_PHY    "/the/pc/paracq.phy"
#define FILE_RAO_SEM    "/the/pc/paracq.sem"
#define FILE_RAO_FIX    "/the/pc/paracq.fix"
#endif


#define FILE_RAO_DFT	"/data/pc/paracq.dft"


/* temperature maximales et minimales des camras (valeurs approximatives) */

#define TEMP_MIN		0
#define TEMP_MAX		255
 
int action_enfen();
int action_end();
int action_modob();
int action_dintg();
int action_rien();
int action_ctrac();
int action_cadac();

int action_nbfen();
int action_nbcam();
int action_obtur();
int action_tpcam();

int action_nocam();
int action_nobuf();
int action_nblig();
int action_nbcol();
int action_ligdb();
int action_coldb();

int action_enreg();
int action_visuf();
int action_sensl();
int action_nbacq();

int action_themisff();
int action_cmp_desc();
int action_binning();

int action_simple();
int action_bitpix();
int action_extend();
int action_telescop();
int action_origin();
int action_bscale();
int action_bzero();
int action_blank();
int action_bunit();
int action_dimpix();
int action_grechel();
int action_xtension();
int action_pcount();
int action_gcount();

int action_naxis();

int action_naxis3();
int action_ctype1();
int action_ctype2();
int action_ctype3();
int action_obs_type();
int action_physpara();
int action_email();
int action_author();
int action_prog_id();
int action_obs_prog();
int action_sci_obj();
int action_contact();
int action_institut();
int action_cmp_name();
int action_cmp_no();
int action_cmp_type();
int action_waveunit();
int action_analys();
int action_instrume();
int action_observer();
int action_rescient();
int action_object();
int action_obj_id();
int action_obs_mode();
int action_prog_num();
int action_detector();
int action_timestep();
int action_fielview();
int action_ixwidth();
int action_iywidth();
int action_actifmir();
int action_xscale();
int action_yscale();
int action_count();
int action_wavlt();
int action_angle();
int action_nomask();
int action_offname();
int action_offsets();
int action_fileacq();
int action_nbreg();
int action_lngstart();
int action_latstart();
int action_syscoord();
int action_stepx();
int action_stepy();
int action_nbstep();
int action_nbstepx();
int action_nbstepy();
int action_latirc();
int action_longtrc();
int action_tcycle();
int action_tregion();
int action_grpred();
int action_spats();
int action_specs();
int action_scalfac();
int action_slit();
int action_filterch();
int action_filterfe();
int action_filtersp();
int action_seq_stok();
int action_nblambd();
int action_lambd();
int action_beamex();
int action_comment();
int action_nrbuf();

int action_solrot_n();
int action_solar_r();
int action_solar_p0();
int action_solar_b0();
int action_predang();
int action_predres();
int action_echelang();

int action_tempqwp1();
int action_tempqwp2();
int action_tempbmsp();




typedef enum ind_instrume
        {
	  FULLDISK,
	  MSDP,
	  SPECTRA,
	  IPM,
	  F1,
	  F2,
	  NB_INSTRUME
	}       Ind_instrume;

typedef enum ind_obs_mode
        {
	  FULLSUN,
	  SINGLE,
	  SCAN,
	  SERIES,
	  PATROL,
	  MFLAT,
	  RFLAT,
	  MDARK,
	  RDARK,
	  RFSTOP,
	  MFSTOP,
	  CALIB,
	  ENGINEERING,
	  TEST,
	  NB_OBS_MODE
	}     Ind_obs_mode;


typedef enum ind_instituts
{
  THEMIS,
  IAC,
  PICDUMIDI,
  OAC,
  MEUDON,
  ARCETRI,
  PARISOBS,
  UTRECHT,
  NANCAY,
  OMP,
  OCA,
  UNIFIRENZE,
  UNITORVERGATA,
  IFSI_CNR,
  UNILAQUILA,
  UNICALABRIA,
  UNINAPOLI,
  NB_INSTITUTS
} Ind_ibstituts;
 

typedef enum ind_mcle
        {
	  _SIMPLE,
	  _BITPIX,
	  _EXTEND,
	  _XTENSION,
	  _PCOUNT,
	  _GCOUNT,
	  _TELESCOP,
	  _ORIGIN,
	  _BSCALE,
	  _BZERO,
	  _BLANK,
	  _BUNIT,
	  _END,
	  _DIMPIX,
	  _GRECHEL,
	  _SOLROT_N,
	  _SOLAR_R,
	  _SOLAR_P0,
	  _SOLAR_B0,
	  _PREDANG,
	  _ECHELANG,
	  _LONGCARR,
	  _TEMPQWP1,
	  _TEMPQWP2,
	  _TEMPBMSP,
	  _NBCAM,
	  _NBWIN,
	  _NOWIN,
	  _NOBUF,
	  _NOCAM,
	  _NSHUTTER,
          _EXPTIME,
	  _THEMISFF,
	  _ROWSTART,
	  _COLSTART,
	  _TEMPCAM,
	  _NAXIS,
	  _NAXIS1,
	  _NAXIS2,
	  _NAXIS3,
	  _CTYPE1,
	  _CTYPE2,
	  _CTYPE3,
	  _OBS_TYPE,
	  _PHYSPARA,
	  _EMAIL,
	  _AUTHOR,
	  _PROG_ID,
	  _OBS_PROG,
	  _SCI_OBJ,
	  _CONTACT,
	  _INSTITUT,
	  _CMP_NAME,
	  _CMP_NO,
	  _CMP_TYPE,
	  _WAVEUNIT,
	  _ANALYS,
	  _DATE,
	  _INSTRUME,
	  _OBSERVER,
	  _RESCIENT,
	  _OBJECT,
	  _OBJ_ID,
	  _OBS_MODE,
	  _PROG_NUM,
	  _FILENAME,
	  _FILEORIG,
	  _DETECTOR,
	  _TIMESTEP,
	  _FIELVIEW,
	  _IXWIDTH,
	  _IYWIDTH,
	  _ACTIFMIR,
	  _XSCALE,
	  _YSCALE,
	  _COUNT,
	  _WAVELNTH,
	  _ANGLE,
	  _NOMASK,
	  _OFFNAME,
	  _OFFSETS,
	  _FILEACQ,
	  _NBREG,
	  _LNGSTART,
	  _LATSTART,
	  _SYSCOORD,
	  _STEP_X,
	  _STEP_Y,
	  _NBSTEP,
	  _NBSTEP_X,
	  _NBSTEP_Y,
	  _LATIRC,
	  _LONGTRC,
	  _TCYCLE,
	  _TREGION,
	  _GRPRED,
	  _SPATS,
	  _SPECS,
	  _SPATSCAL,
	  _SPECSCAL,
	  _SCALFAC,
	  _SLIT,
	  _FILTERCH,
	  _FILTERFE,
	  _FILTERSP,
	  _SEQ_STOK,
	  _NBLAMBD,
	  _DATE_END,
	  _PREFENTE,
	  _POSROT,
	  _ELEVA,
	  _AZIMUT,
	  _ALPHA,
	  _DELTA,
	  _POLARANG,
	  _SVECTOR,
	  _LONGITUD,
	  _LATITUD,
	  _DATE_OBS,
	  _SEQ_IND,
	  _INDREG,
	  _INDSTEPX,
	  _INDSTEPY,
	  _INDSTEP,
	  _LAMBD,
	  _INDLAMBD,
	  _STOKES,
	  _BEAMEX,
	  _COMMENT,
	  _DIST_NS,
	  _DIST_EW,
	  _NRBUF,
	  _CMP_DESC,
	  _BINNING,
	  _POSQWP1,
	  _POSQWP2,
	  NB_MCLE
	}       Ind_mcle;



typedef struct source_mcle
	{
	char	mot_cle[TAILLE_MCLE];
	int	(*fonction)();
        }	Source_mcle;

#endif



