/* ipic.h - IndustryPack Interface Controller (IPIC) */

/*
modification history
--------------------
01a,29nov93,sr	written 
*/

/*
 * This file contains constants for the IndustryPack Interface Controller (IPIC)
 * The macro IPIC_BASE_ADRS must be defined when including this header.
 */

#ifdef	_ASMLANGUAGE
#define CAST
#define	CASTINT
#else
#define CAST (char *)
#define	CASTINT (int *)
#endif	/* _ASMLANGUAGE */

/* on-board access, register definitions */

#define IPIC_BASE_ADRS   (0xfffbc000)     /* IPIC registers base address */

#define	IPIC_REG_INTERVAL	1

#ifndef IPIC_ADRS	/* to permit alternative board addressing */
#define IPIC_ADRS(reg)   (CAST (IPIC_BASE_ADRS + (reg * IPIC_REG_INTERVAL)))
#endif	/* IPIC_ADRS */

#define IPIC_ID			IPIC_ADRS(0x00)	/* Chip ID 		      */
#define	IPIC_REVISION		IPIC_ADRS(0x01)	/* Chip Revision 	      */
#define	IPIC_IPA_MEM_BASE_UP	IPIC_ADRS(0x04)	/* IPa Mem Base Addr (hi)     */
#define	IPIC_IPA_MEM_BASE_LOW	IPIC_ADRS(0x05)	/* IPa Mem Base Addr (low)    */
#define	IPIC_IPB_MEM_BASE_UP	IPIC_ADRS(0x06)	/* IPb Mem Base Addr (hi)     */
#define	IPIC_IPB_MEM_BASE_LOW	IPIC_ADRS(0x07)	/* IPb Mem Base Addr (low)    */
#define	IPIC_IPC_MEM_BASE_UP	IPIC_ADRS(0x08)	/* IPc Mem Base Addr (hi)     */
#define	IPIC_IPC_MEM_BASE_LOW	IPIC_ADRS(0x09)	/* IPc Mem Base Addr (low)    */
#define	IPIC_IPD_MEM_BASE_UP	IPIC_ADRS(0x0a)	/* IPd Mem Base Addr (hi)     */
#define	IPIC_IPD_MEM_BASE_LOW	IPIC_ADRS(0x0b)	/* IPd Mem Base Addr (low)    */
#define	IPIC_IPA_MEM_SIZE	IPIC_ADRS(0x0c)	/* IPa Mem size               */
#define	IPIC_IPB_MEM_SIZE	IPIC_ADRS(0x0d)	/* IPb Mem size               */
#define	IPIC_IPC_MEM_SIZE	IPIC_ADRS(0x0e)	/* IPc Mem size               */
#define	IPIC_IPD_MEM_SIZE	IPIC_ADRS(0x0f)	/* IPd Mem size               */
#define	IPIC_IPA_INT0_CTL	IPIC_ADRS(0x10)	/* IPa Int0 control           */
#define	IPIC_IPA_INT1_CTL	IPIC_ADRS(0x11)	/* IPa Int1 control           */
#define	IPIC_IPB_INT0_CTL	IPIC_ADRS(0x12)	/* IPb Int0 control           */
#define	IPIC_IPB_INT1_CTL	IPIC_ADRS(0x13)	/* IPb Int1 control           */
#define	IPIC_IPC_INT0_CTL	IPIC_ADRS(0x14)	/* IPc Int0 control           */
#define	IPIC_IPC_INT1_CTL	IPIC_ADRS(0x15)	/* IPc Int1 control           */
#define	IPIC_IPD_INT0_CTL	IPIC_ADRS(0x16)	/* IPd Int0 control           */
#define	IPIC_IPD_INT1_CTL	IPIC_ADRS(0x17)	/* IPd Int1 control           */
#define	IPIC_IPA_GCR		IPIC_ADRS(0x18)	/* IPa General Control Reg.   */
#define	IPIC_IPB_GCR		IPIC_ADRS(0x19)	/* IPb General Control Reg.   */
#define	IPIC_IPC_GCR		IPIC_ADRS(0x1a)	/* IPc General Control Reg.   */
#define	IPIC_IPD_GCR		IPIC_ADRS(0x1b)	/* IPd General Control Reg.   */
#define	IPIC_IP_RESET		IPIC_ADRS(0x1f)	/* IP Reset                   */


/****************************************************************
 * MEM SIZE		0x0c-0x0f	Memory Size Register	*
 ****************************************************************/

#define IP_MEM_SIZE_64KB	0x00	/* 64 KB memory space          */
#define IP_MEM_SIZE_128KB	0x01	/* 128 KB memory space         */
#define IP_MEM_SIZE_256KB	0x03	/* 256 KB memory space         */
#define IP_MEM_SIZE_512KB	0x07	/* 512 KB memory space         */
#define IP_MEM_SIZE_1MB		0x0f	/* 1 MB memory space           */
#define IP_MEM_SIZE_2MB		0x1f	/* 2 MB memory space           */
#define IP_MEM_SIZE_4MB		0x3f	/* 4 MB memory space           */
#define IP_MEM_SIZE_8MB		0x7f	/* 8 MB memory space           */
#define IP_MEM_SIZE_16MB	0xff	/* 16 MB memory space          */


/****************************************************************
 * INTERRUPT CONTROL 	0x10-0x17	Interrupt Control	*
 ****************************************************************/

#define IP_IT_LEVEL_1		0x01	/* IT request level 1          */
#define IP_IT_LEVEL_2		0x02	/* IT request level 2          */
#define IP_IT_LEVEL_3		0x03	/* IT request level 3          */
#define IP_IT_LEVEL_4		0x04	/* IT request level 4          */
#define IP_IT_LEVEL_5		0x05	/* IT request level 5          */
#define IP_IT_LEVEL_6		0x06	/* IT request level 6          */
#define IP_IT_CLEAR_STATUS	0x08	/* Clear IT status (edge mode) */
#define IP_IT_ENABLE		0x10	/* Enable interrupt            */
#define IP_IT_SENSE_LEVEL	0x00	/* Level sensitive interrupt   */
#define IP_IT_SENSE_EDGE	0x40	/* Edge sensitive interrupt    */
#define IP_IT_FALLING_EDGE	0x00	/* IT on falling edge          */
#define IP_IT_RISING_EDGE	0x80	/* IT on rising edge           */


/************************************************************************
 * GCR			0x18-0x1b	General Control Register	*
 ************************************************************************/

#define	GCR_MEM_ENABLE	0x01	/* Enable memory access for local bus	*/
#define	GCR_MEM_DISABLE	0x00	/* Disable memory access for local bus  */
#define GCR_MEM_8_BITS	0x04	/* Memory space data-bus is 8 bits      */
#define GCR_MEM_16_BITS	0x08	/* Memory space data-bus is 16 bits     */
#define GCR_MEM_32_BITS	0x00	/* Memory space data-bus is 32 bits     */
#define GCR_RT_0_US	0x00	/* Recovery time is 0 microseconds      */
#define GCR_RT_2_US	0x10	/* Recovery time is 2 microseconds      */
#define GCR_RT_4_US	0x20	/* Recovery time is 4 microseconds      */
#define GCR_RT_8_US	0x30	/* Recovery time is 8 microseconds      */
#define GCR_IP_ERROR	0x80	/* Error status bit                     */


/****************************************************************
 * RESET		0x1f	IP RESET Register               *
 ****************************************************************/

#define	IPIC_RESET	0x01	/* Reset the IPIC and the 4 IndustryPacks */
