/*
**   FILE   : ipg_ccd.h
**
**   AUTHOR : sr
**
**   PRODUCT: logiciel de gestion IPG, interface camera CCD.
**
**   VERSION: 1.18
**
**   CREATED : 98/07/15 from /home/devel/travail/sun/include/SCCS/s.ipg_ccd.h . Retrieved 98/07/15
**
**   COMMENT: 	
**
*/

/*
  17.12.96 dz
   Ajout de la constante d'erreur IP_DMA
   prototypes des 2 fonctions de mesure du temps 
 
  */
#ifndef _prec_ipg_ccd_h
#define _prec_ipg_ccd_h

#define	u16	unsigned short
#define u32	unsigned int

	/* Pour ipAdr, registre Commandes */
#define IPA_REG		0x1000	/* acces registre			*/
#define	IPA_MEM		0	/* acces memoire			*/
#define	IPA_COL		0	/* incrementation colonne en premier	*/
#define IPA_LIG		0x2000	/* incrementation ligne en premier	*/
#define IPA_MONO	0	/* mode monocoup			*/
#define IPA_BLOC	0x4000	/* mode fenetre				*/
#define IPA_NOP		0
#define IPA_EXEC	0x8000	/* ordre d'execution			*/	

#define	IPA_IEDMA	0x100	/* it interne			*/
#define IPA_IEN1	0x200	/* interruption externe 1	*/	
#define IPA_IEN2	0x400	/* interruption externe 2	*/	
#define IPA_IEN3	0x800	/* interruption externe 3	*/	
#define IPA_IEN4	0x1000	/* interruption externe 4	*/	
#define IPA_IEN5	0x2000	/* interruption externe 5	*/	
#define IPA_GIEN	0x4000	/* validation globale des it	*/

#define IPA_MASK_BUSY	0x8000	/* masque bit busy			*/

#define IPA_INC_LIG	0x2000	/* incrementation ligne en premier	*/
#define IPA_INC_COL	0	/* incrementation colonne en premier	*/

	/* Pour ipAdr, registre it */
#define	IPA_AACK	0x8000	/* Auto ack			*/

	/* Pour ipIn et ipOut */
#define IP_ON		3	/* Validation d'un module	*/
#define IP_OFF		1	/* Arret d'un module		*/
#define IP_MASK_EMPTY	4	/* Fifo vide			*/	
#define IP_MASK_HALF	2	/* Fifo a moitie vide		*/	
#define IP_MASK_FULL	1	/* Fifo pleine			*/	
#define IP_MASK_OVFL	0x10	/* Il y a eu overflow		*/	
#define	IPO_AACK	0x0010	/* Auto ack			*/
#define	IPI_AACK	0x0010	/* Auto ack			*/
#define	IPI_DMA		0x0020	/* Mode DMA lecture FIFO	*/

/* Structure permettant l'acces au module IPG3 adresse*/
struct	ipg_adr	
	{
	u16	eeprom;		/* identificateur		*/
	u16	it;		/* vecteur d'IT			*/
	u16	csr;		/* Registre de commande/status 	*/
	u16	acq;		/* Registre acquitement des it	*/
	u16	adrys;		/* registre d entree compteur ligne	*/
	u16	adrye;		/* registre derniere ligne		*/
	u16	adrxs;		/* registre d entree compteur colonnes	*/
	u16	adrxe;		/* registre derniere colonnes		*/
	};

/* Structure permettant l'acces au module IPG3 data*/
struct	ipg_data	
	{
	u16	eeprom;		/* identificateur		*/
	u16	cmd;		/* Registre de commande		*/
	u16	sts;		/* Registre de status		*/
	u16	data;		/* data				*/
	u16	fifo;		/* fifo				*/
	};



#define IP_FIFO	(2048/2)	/* Taille d'une demi fifo sur les IPG */

/* Error codes */

#define IPCCD	0x1000		/* Error displacement */
#define IP_INST	(IPCCD + 0x02)	/* Erreur a l'installation du driver	*/
#define IP_DRV	(IPCCD + 0x04)	/* Driver non installe		*/
#define IP_TMO_1 (IPCCD + 0x10)	/* Acces en timeout 		*/
#define IP_TMO_2 (IPCCD + 0x11)	/* Acces en timeout 		*/
#define IP_PARM	(IPCCD + 0x12)	/* Erreur de parametre		*/
#define IP_SEM	(IPCCD + 0x14)	/* Erreur a la creation d'un semaphore	*/
#define IP_OVER	(IPCCD + 0x16)	/* Debordement de la fifo de reception */
#define IP_DMA  (IPCCD + 0x18)  /* Acces registre alors que DMA en cours */

/* Prototypes des fonctions */

int     ipg_init	(void) ;
int     ipg_reset	(void) ;
int     ipg_wr_reg      (u16 adrs, u16 val) ;
int     ipg_rd_reg      (u16 adrs, u16 *dest) ;
int     ipg_wr_data     (u16 ligne, u16 colonne, u16 val) ;
int     ipg_rd_data     (u16 ligne, u16 colonne, u16 *dest) ;
int     ipg_rd_bloc     (u16 Sligne, u16 Scolonne, u16 Eligne, u16 Ecolonne,
                         u16 *buffer, int sizeDest, int sens) ;
int ipg_wr_bloc         (u16 Sligne, u16 Scolonne, u16 Eligne, u16 Ecolonne,
                         u16 *buffer, int sens) ;

/* fonctions de validation/inhibition des interruptions entrant sur la carte IP*/

int disable_ipg_it(u16 masque_it);
int enable_ipg_it(u16 masque_it);

/* comptage du temps */

void start_mcchip_timer( u32 valeur );
u32 lect_mcchip_timer( void );

#endif	/* _prec_ipg_ccd_h */
