/* ipdma.h - IndustryPack DMA */

/*
modification history
--------------------
01 11 august 95 ac	written 
*/

/*
 * This file contains constants for the IndustryPack DMA Controller 
 */

#ifdef	_ASMLANGUAGE
#define CAST
#define	CASTINT
#else
#define CAST (char *)
#define	CASTINT (int *)
#endif	/* _ASMLANGUAGE */

/* on-board access, register definitions */

#define	IPDMA_A		0xFFFBC020
#define	IPDMA_B		0xFFFBC038
#define	IPDMA_C		0xFFFBC050
#define	IPDMA_D		0xFFFBC068

typedef struct
{
	uchar_t	sts ;		/* Status register		*/
	uchar_t	itc ;		/* Interrupt control register	*/
	uchar_t	timeout ;	/* DMA bus timeout register	*/
	uchar_t	res0 ;
	uchar_t	ctr1 ;		/* Control register 1		*/
	uchar_t	ctr2 ;		/* Control register 2		*/
	uchar_t	res1 ;
	uchar_t	res2 ;
	uint_t	busadr ;	/* Local bus address counter	*/
	uint_t	ipadr ;		/* IP bus address counter	*/
	uint_t	count ;		/* Byter counter		*/
	uint_t	tbladr ;	/* Table address counter	*/
} S_IPDMA ;


/****************************************************************
 *	Status register						*
 ****************************************************************/

#define DMASR_DONE	0x01	/* End without error, or HALT	*/
#define DMASR_IPTO	0x02	/* Timed out			*/
#define DMASR_TBL	0x04	/* Error while reading cmd pkt	*/
#define DMASR_CHANI	0x08	/* Terminated because DMA2_INTE	*/
#define DMASR_IPEND	0x10	/* Terminated because DMAEND	*/
#define DMASR_DLBE	0x40	/* Terminated because TEA	*/

/****************************************************************
 *	Interrupt Control register				*
 ****************************************************************/

#define DMAIT_DICLR	0x08	/* Clear the DINT status bit	*/
#define DMAIT_DIEN	0x10	/* Enable interrupt		*/
#define DMAIT_DINT	0x20	/* Interrupt is being generated	*/

#define DMA_IT_LEVEL_1		0x01	/* IT request level 1          */
#define DMA_IT_LEVEL_2		0x02	/* IT request level 2          */
#define DMA_IT_LEVEL_3		0x03	/* IT request level 3          */
#define DMA_IT_LEVEL_4		0x04	/* IT request level 4          */
#define DMA_IT_LEVEL_5		0x05	/* IT request level 5          */
#define DMA_IT_LEVEL_6		0x06	/* IT request level 6          */

/****************************************************************
 *	Bus Time Out						*
 ****************************************************************/

#define DMATO_NONE	0x0	/* No time out	*/
#define DMATO_16	0x1	/* 16 us	*/
#define DMATO_32	0x2	/* */
#define DMATO_64	0x3	/* */
#define DMATO_128	0x4	/* */
#define DMATO_256	0x5	/* */
#define DMATO_512	0x6	/* */
#define DMATO_1024	0x7	/* */

/****************************************************************
 *	Control Register 1					*
 ****************************************************************/

#define DMAC1_FLUSH	0x01	/* Flush DMA path			*/
#define DMAC1_ACH1	0x02	/* IP A channel 1 associated to DMA_B	*/
#define DMAC1_CCH1	0x02	/* IP C channel 1 associated to DMA_D	*/
#define DMAC1_8		0x04	/* IP data bus width is 8  bits		*/
#define DMAC1_16	0x08	/* IP data bus width is 16 bits		*/
#define DMAC1_32	0x00	/* IP data bus width is 32 bits		*/
#define DMAC1_ADMA	0x10	/* Address  mode DMA operation		*/
#define DMAC1_SDMA	0x00	/* Standard mode DMA operation		*/
#define DMAC1_DTBL	0x00	/* Direct   mode			*/
#define DMAC1_CHAIN	0x20	/* Chaining mode			*/
#define DMAC1_DEN	0x40	/* DMA enable (W only)			*/
#define DMAC1_DHALT	0x80	/* Halt at end of chained command (W only)*/

/****************************************************************
 *	Control Register 2					*
 ****************************************************************/

#define DMAC2_SNOOP0	0x00	/* MC68040 SNOOP control signal	*/
#define DMAC2_SNOOP1	0x01	/* MC68040 SNOOP control signal	*/
#define DMAC2_SNOOP2	0x02	/* MC68040 SNOOP control signal	*/
#define DMAC2_TOIP	0x04	/* DMA direction: Write to IP	*/
#define DMAC2_FROMIP	0x00	/* DMA direction: Read from IP	*/
#define DMAC2_DMAE0	0x10	/* DMA drive DMAEND		*/
#define DMAC2_DMAE1	0x20	/* DMA end if DMAEND is detected*/
#define DMAC2_DMAEC	0x40	/* Force end of DMA		*/
#define DMAC2_INTE	0x80	/* It at end of packet		*/


