	/*;+********************************************************************
-----------------
ENTETE DE FICHIER	:	INTF.H
-----------------
-Auteur(s): Denis Ziegler
-Role:	Definitions des constantes utilisees pour piloter et acceder a
	l'electronique de la carte "controleur cameras" et des cameras.
	Prototypes des fonctions de la bibliotheque LIB_INTF.A
-Constantes
	Internes au fichier:
		
-Variables
	Internes au fichier:
	 	
-Fonctions:
	Internes au fichier:
	 
-Commentaires:

********************************************************************;-*/
/*
 * 12 Octobre 1998 dz
 * Ajout de quelques prototypes de fonctions 
 * 14 Janvier 1996
 * Ajout des constantes NB_IT , IT_INTG , IT_NUM , IT_TIMOUT , IT_SYNC
 * IT_GEN
 * definissant les interruptions arrivant sur la carte IP LORIN

 * 12 Avril 1996
 * Des modifications ont ete apportees sur la carte Interface.
 * Entres autres choses, ajout d'un sequenceur hardware, donc de nouvelles
 * constantes font leur apparition.
 * modification de l'arrangement des bits du registre R_STAT
 */

#ifndef _prec_intf_h
#define _prec_intf_h

/* inclusion du fichier header des cartes IPG LORIN */

#ifndef _prec_ipg_ccd_h
#include <ipg_ccd.h>
#endif

/* inclusion du fichier table de controle des camras */

#ifndef _prec_tb_ctrl_cam_h
#include <tb_ctrl_cam.h>
#endif

/* inclusion du fichier des constantes des camras */

#ifndef _prec_camera_h
#include <camera.h>
#endif

/* inclusion du fichier des codes d'erreurs */

#ifndef _prec_the_errno_h
#include <the_errno.h>
#endif

/*
 * 		ADRESSES DES REGISTRES DE l'INTERFACE
 */
#define BASE	0x2000	/* adresse de base des registres de l'interface */
#define RADRCAM BASE+0x00  /* No de camera et plan memoire 8bits           */
#define R_CTRL  BASE+0x01  /* registre de controle 8bits                   */
#define R_STAT  BASE+0x01  /* registre d'etats 16bits                      */
#define R_OBT   BASE+0x02  /* controle des obturateurs 8bits               */
#define R_START BASE+0x03  /* lancement des integrations ( automate ) 8bits*/
#define R_INT   BASE+0x04  /* lancement des integrations (logiciel) 8bits  */

/* 
 * 		LES REGISTRES DES TIMERS 82C54 
 * tous les registres internes des timers sont en 16 bits sauf les CWRs (8 bits)
 * cependant leur acces se fait en deux temps : LSB puis MSB
 * cf documentation du composant
 */
#define C0      BASE+0x10 /* Horloge de base des integrations  */
#define C1      BASE+0x11 /* Timer affecte a l'obturateur No 1 */
#define C2      BASE+0x12 /* Timer affecte a l'obturateur No 2 */
#define CWR0_2  BASE+0x13 /* registre de controle pour C0 C1 C2*/
#define C3      BASE+0x14 /* Timer affecte a l'obturateur No 3 */
#define C4      BASE+0x15 /* Timer affecte a l'obturateur No 4 */
#define C5      BASE+0x16 /* Timer affecte a l'obturateur No 5 */
#define CWR3_5  BASE+0x17 /* registre de controle C3 C4 C5     */
#define C6      BASE+0x18 /* Timer affecte a l'obturateur No 6 */
#define C7      BASE+0x19 /* Timer affecte a l'obturateur No 7 */
#define CWOUAF  BASE+0x1A /* Chien de garde de l'automate */
#define CWR6_W  BASE+0x1B /* registre de controle C6 C7 CWOUAF */
#define C9      BASE+0x1C /* Cadenceur hardware */
#define C10     BASE+0x1D /* Timer affecte a la led Visucad en face avant
                             de la carte interface */
#define CWR9_11 BASE+0x1F /* registre de controle C9 C10 C11 */

/*
 * 		CONSTANTES D'INITIALISATION DES TIMERS
 */
#define INIT_C0  0x36 /* C0 en mode generateur de frequence (square wave mode)*/
#define INIT_C1  0x72 /* C1 en mode monostable */
#define INIT_C2  0xB2 /* C2 en mode monostable */
#define INIT_C3  0x32 /* C3  "   "     "       */
#define INIT_C4  0x72
#define INIT_C5  0xB2
#define INIT_C6  0x32
#define INIT_C7  0x72
#define INIT_CW  0xB2 /* chien de garde en mode monostable */
#define INIT_C9  0x34 /* cadenceur hardware en mode Rate Generator */
#define INIT_C10 0x76 /* compteur gerant la Led Visucad ( sur face avant de la
                         carte interface ) en mode Square wave mode */
#define T_1MILLI  8000  /* Pour fabriquer l'horloge a 1kHz ( T=1ms )*/
#define T_10MICRO 80 /* pour fabriquer l'horloge a 100kHz ( T=10micros) */
#define T_5MICRO  40 /*  ''                 ''     200kHz ( T=5 micros) */
#define TINT_DEF  300 /* Temps d'integration par defaut en ms */
#define T_CAD     1500 /* Cadence hard par defaut en ms */
#define T_WOUAF   3000 /* Chien de garde des obturateurs  en ms */

/*
 *          	CONSTANTES DES REGISTRE DE CONTROLE R_CTRL
 *              ET REGISTRE D'ETAT R_STAT
 */
#define RAZ_INT     0x0001 /* Remise a zero de l'interface */
#define MODE_AUTO   0x0002 /* controle par l'automate */
#define SOL_ENTIER  0x0004 /* mode soleil entier */
#define HARD_CAD    0x0008 /* Cadenceur hardware */
#define RAZ_CAM     0x0010 /* remise a zero des buffers */
#define DAM         0x0020 /* demande d'acces aux buffers */
#define ECRM1       0x0040 /* ecriture de l'image en memoire obscurite */
#define SOM_INTG    0x0100 /* OU logique de toutes les integrations */
#define TIMOUT      0x0200  
#define RECEPT_OBT  0x0400 /* Flag de controle reception fibre (obturateurs) */
#define INTNA       0x1000 /* Integration non autorisee */
#define ERRNUM      0x2000 /* Erreur de numerisation */
#define MEMOCC      0x4000 /* Memoires buffers occupees */

/*
 * 		COMMANDES DES OBTURATEURS
 */ 

#define V_OBTURATION 0

/*
 * 		LANCEMENT DES INTEGRATIONS EN MODE AUTOMATIQUE
 */
#define GO1   0x02
#define GO2   0x04
#define GO3   0x08
#define GO4   0x10
#define GO5   0x20
#define GO6   0x40
#define GO7   0x80

/*
 * 		LANCEMENT DES INTEGRATIONS EN MODE MANUEL
 */
#define INTG1 0x02
#define INTG2 0x04
#define INTG3 0x08
#define INTG4 0x10
#define INTG5 0x20
#define INTG6 0x40
#define INTG7 0x80

/*              
 *                  INTERRUPTIONS SUR CARTE LORIN
 */
#define NB_IT     6
#define IT_INTG   IPA_IEN1 /* fin d'integration */
#define IT_NUM    IPA_IEN2  /* fin de numerisation */
#define IT_TIMOUT IPA_IEN3/* It de timout */
#define IT_SYNC   IPA_IEN4/* Synchro GPS */
#define IT_GEN    IPA_GIEN /* Toutes les its */


/*
 *--------------------------------------------------------------------------
 */
#ifndef MSB
#define MSB(x) ( (x) >>8 & 0x00FF ) /* octet de poids fort de x  */
#endif
#ifndef LSB
#define LSB(x) ( (x) & 0x00FF ) /* octet de poids faible de x  */
#endif

/*
 *----------------------------------------------------------------------
 */
#define OUVERT 1
#define FERME 0
#define OPEN 1
#define CLOSE 0
#define FLAG_ON 1
#define FLAG_OFF 0

#ifndef BUSY
#define BUSY 1
#endif
#ifndef NOT_BUSY
#define NOT_BUSY 0
#endif
#ifndef OK
#define OK 0
#endif
#ifndef ERROR
#define ERROR (-1)
#endif

		    
enum plan_mem { P0,P1,P2,P3 };

typedef unsigned char Byte;   /* Octet */
typedef unsigned short U16; /* 16 bits non signes */
typedef unsigned int U32;
/* 
 pour des problemes d'alignement en memoire commune VME-SUN
 toutes les variables communes sont de type long
 */


/*
 *			DECLARATIONS DES PROTOTYPES
 */

/* INTF.C Fonctions de base d'acces aux registres de l'interface */

int intf_init( void ); /* initialisation minimale de l'interface */
int ipg_wr_timer( U16 adr , U16 data ); 
int intf_wr_timer( Byte timer_num , U16 valeur );
int start_intg( Byte masque_intg ); /* lancement d'une integration automatique */
int start_hard_cad( U16 cadence , Byte masque_intg );
int stop_hard_cad( void );
int intf_wr_rctrl( U16 masque , Byte etat ); 
int intf_rd_rstat( U16 masque , Byte *etat );
int raz_cam( void ); /* reset sur carte buffers */
int raz_intf( void ); /* reset de l'interface */
int reset_cam( void ); /* un autre reset sur les cartes buffers */

/* OBTURATEUR.C manipulation des obturateurs */

int lect_obt( Byte num , Byte *flag );
int cmde_obt( Byte num , Byte flag );

/* CAMERA.C manipulation des registres des cameras */

int affect_obt( Byte num_cam , Byte num_obt );  
int affect_theta( Byte num_cam , Byte theta );
int lect_stat_cam( Byte num_cam , U16 *etat);
int charge_tb_obt( Tb_ctrl_cam *pointeur);
int charge_tb_theta( Tb_ctrl_cam *pointeur);
int deselect_tb_obt( void );

#endif /* _prec_intf_h */
