




#ifndef _prec_enrg_h
#define _prec_enrg_h

#ifndef _prec_acq_h
#include <acq.h>
#endif



#ifdef _test
#define FILE_RAO_ACQ	"/data/pc/images.don"
#define FILE_OBS_ACQ	"/data/pc/acquis.don"
#define PATH_ACQ        "themis/\0"
#define DISK1          "/data/"
#define DISK2          "/data/"
#endif

#ifndef _test
#define FILE_RAO_ACQ	"/data/pc/images.don"
#define FILE_OBS_ACQ	"/data/pc/acquis.don"
#define PATH_ACQ        "themis/\0"
#define DISK1          "/data/"
#define DISK2          "/data/"
#endif


#define LOGIN		501 /*10*/
#define GROUP		500 /*10*/
#define PRIORITY	0664

#define TAILLE_ENT_ACQ	2
#define TAILLE_ENT_FEN	6
#define TAILLE_FILENAME 80    /*Taille maximale pour le nom d'un fichier fullpath!*/
#define TAILLE_DATEFICH 30    /*Taille maximale pour la date d'un fichier ecrite a la facon FITS*/



/*****************************
Structure de donnees des parametres semi-statiques du formatage
******************************/




typedef struct tb_sem
{
  long   solrot_n;
  double  solar_r;
  double  solar_p0;
  double  solar_b0;
  double  predang;
  long   predres;
  double  echelang;
  double  tempqwp1;
  double  tempqwp2;
  double  tempbmsp; 
}       Tb_sem;

/*****************************
Structure de donnees des parametres fixes du formatage
******************************/

typedef struct tb_fix
{
  char    simple;
  long    bitpix;
  char    extend;
  chfits  telescop;
  chfits  origin;
  double   bscale;
  double   bzero;
  long    blank;
  chfits  bunit;
  chfits  dimpix;
  chfits  grechel;
  chfits  xtension;
}       Tb_fix;


/*****************************
Structure de donnees des parametres physiques du formatage
******************************/


typedef struct tb_phy
{
  long    naxis;
  long    naxis1;
  long    naxis2;
  long    naxis3;
  chfits  ctype1;
  chfits  ctype2;
  chfits  ctype3;
  chfits  obs_type;
  chfits  physpara;
  chfits  email;
  chfits  author;
  chfits  prog_id;
  chfits  obs_prog;
  chfits  sci_obj;
  chfits  contact;
  chfits  institut;
  chfits  cmp_name;
  long    cmp_no;
  chfits  cmp_type;
  long    waveunit;
  chfits  analys;
  chfits  instrume;
  chfits  observer;
  chfits  rescient;
  chfits  object;
  chfits  obj_id;
  chfits  obs_mode;
  long    prog_num;
  chfits  fileorig[NB_MAX_FEN];
  chfits  detector;
  double   timestep;
  chfits  fielview;
  double   ixwidth;
  double   iywidth;
  char    actifmir;
  char    beamex;
  double   xscale;
  double   yscale;
  long    count;
  double   wavelnth[NB_MAX_FEN];
  long    nrbuf[NB_MAX_FEN];
  double   angle;
  chfits  nomask;
  chfits  offname;
  char    offsets;
  chfits  fileacq;
  double   lngstart;
  double   latstart;
  chfits  syscoord;
  double   latirc;
  double   longtrc;
  long    tcycle;
  long    tregion;
  chfits  grpred;
  double   spatscal;
  double   specscal;
  double   scalfac;
  chfits  slit;
  chfits  filterch;
  chfits  filterfe;
  chfits  filtersp;
  chfits  sequence;
}       Tb_phy;


/*****************************
Structure de donnees des parametres d'enregistrement
******************************/


typedef struct tb_enrg
{
long	nbfen;	        	/*nb de fen a enregistrer*/
long	numfen[NB_MAX_FEN];	/*num des fen a enregistrer*/
long    nb_li_princ;            /*nb de cases ecrites ds le tab d'entetes ppales*/
long    nb_li_dyn;              /*nb de cases ecrites ds le tab d'entetes dyn*/
long    indstart_dyn;           /*ind de debut des infos dyn dans le tab dyn*/
FILE    *fich[NB_MAX_FEN];      /*pointeur sur le fichier*/
char    nomfich[NB_MAX_FEN][TAILLE_FILENAME];
chfits  datefich[NB_MAX_FEN][TAILLE_DATEFICH];
Tb_sem  tab_sem;
Tb_fix  tab_fix;
Tb_phy  tab_phy;
}	Tb_enrg;

 



#endif


