
#ifndef _prec_com_ucci_vme_h
#define _prec_com_ucci_vme_h

/*-----------------------LES CONSTANTES ET PARAMETRES----------------------*/

#define RS232_0 "/tyCo/0"
#define RS232_1 "/tyCo/1"
#define SPEED_RS232 19200  /* liaison configuree a 19200Bds */
#define NB_MAX_BYTES 160   /* Nombre de caracteres maxi recus par
			     la ligne RS232 */
#define NB_MAX_LONG_PARAM 2
#define NB_MAX_INT_PARAM  3 
#define NB_MAX_FLOAT_PARAM 16
#define CR 0x0d
#define NL 0x0a

typedef struct
{
  char *chaine;     /* pointeur sur la chaine de caracteres a decoder */
  int (*pt_fonc)(); /* pointeur sur la fonction de traitement associee */
  char **erreur; /* pointeur sur la table des erreurs */
} Cmd_ucci_vme;

typedef enum
{
  NO_ERR_CMD_UCCI,
  ERR_CMD_UCCI_1,
  ERR_CMD_UCCI_2,
  ERR_CMD_UCCI_3,
  ERR_CMD_UCCI_4,
  ERR_CMD_UCCI_5,
  ERR_CMD_UCCI_6,
  ERR_CMD_UCCI_7,
  ERR_CMD_UCCI_8,
  ERR_CMD_UCCI_9
} Err_cmd_ucci ;

/*-------------------------DECLARATIONS DES FONCTIONS-----------------------*/
int init_rs232( char *port) ;
int test_rd_rs232( char *port );
int test_wr_rs232( char *port );
int init_com( void );
int decode( char *chaine , char *table );
void write_rs232( char *msg );
void read_rs232( char *msg );

int acqui();
int utc();
int inde();
int lambda();
int step();
int ana();
int ppou();
int plam();
int da0();
int stepx();
int stepy();

int extract_long_param( char * , char * , long * );
int extract_int_param( char * , char * , int * );
int extract_float_param( char *, char *, double *);

#endif /* _prec_com_ucci_vme_h */
